/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Interpolator;
import org.jogamp.java3d.internal.J3dUtilsI18N;

abstract class FloatValueInterpolator
extends Interpolator {
    private float[] knots;
    private int knotsLength;
    protected int currentKnotIndex;
    protected float currentInterpolationRatio;
    protected float[] values;
    protected float currentValue;

    FloatValueInterpolator(Alpha alpha, float[] k, float[] v) {
        super(alpha);
        this.knotsLength = k.length;
        if ((double)k[0] < -1.0E-4 || (double)k[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator0"));
        }
        if ((double)(k[this.knotsLength - 1] - 1.0f) < -1.0E-4 || (double)(k[this.knotsLength - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator1"));
        }
        this.knots = new float[this.knotsLength];
        int i = 0;
        while (i < this.knotsLength) {
            if (i > 0 && k[i] < k[i - 1]) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator2"));
            }
            this.knots[i] = k[i];
            ++i;
        }
        if (this.knotsLength != v.length) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator3"));
        }
        this.values = new float[this.knotsLength];
        i = 0;
        while (i < this.knotsLength) {
            this.values[i] = v[i];
            ++i;
        }
    }

    void setValue(int index, float value) {
        this.values[index] = value;
    }

    float getValue(int index) {
        return this.values[index];
    }

    protected void computePathInterpolation() {
        float alphaValue = this.getAlpha().value();
        int i = 0;
        while (i < this.knotsLength) {
            if (i == 0 && alphaValue <= this.knots[i] || i > 0 && alphaValue >= this.knots[i - 1] && alphaValue <= this.knots[i]) {
                if (i == 0) {
                    this.currentInterpolationRatio = 0.0f;
                    this.currentKnotIndex = 0;
                    this.currentValue = this.values[0];
                    break;
                }
                this.currentInterpolationRatio = (alphaValue - this.knots[i - 1]) / (this.knots[i] - this.knots[i - 1]);
                this.currentKnotIndex = i - 1;
                this.currentValue = this.values[i - 1] + this.currentInterpolationRatio * (this.values[i] - this.values[i - 1]);
                break;
            }
            ++i;
        }
    }
}

