/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.solvent;

import java.util.logging.Logger;

public enum SolventModel {
    NONE,
    BINARY,
    GAUSSIAN,
    POLYNOMIAL;

    private static final Logger logger;

    public static SolventModel parse(String solventName) {
        try {
            return SolventModel.valueOf(solventName.trim().toUpperCase());
        }
        catch (Exception e) {
            logger.info(String.format(" %s was not recognized; Polynomial solvent model selected.", solventName));
            return POLYNOMIAL;
        }
    }

    static {
        logger = Logger.getLogger(SolventModel.class.getName());
    }
}

