/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.solvent;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.SliceRegion;
import ffx.xray.solvent.BulkSolventList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BulkSolventSliceRegion
extends SliceRegion {
    protected static final Logger logger = Logger.getLogger(BulkSolventSliceRegion.class.getName());
    private final BulkSolventList bulkSolventList;
    private final int gZ;

    public BulkSolventSliceRegion(int gX, int gY, int gZ, double[] grid, int nSymm, int threadCount, Crystal crystal, Atom[] atoms, double[][][] coordinates, double cutoff, ParallelTeam parallelTeam) {
        super(gX, gY, gZ, grid, nSymm, threadCount, atoms, coordinates);
        this.gZ = gZ;
        Arrays.fill(this.select[0], false);
        this.bulkSolventList = new BulkSolventList(crystal, atoms, cutoff, parallelTeam);
    }

    public void run() {
        try {
            this.execute(0, this.gZ - 1, (IntegerForLoop)this.sliceLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = " Exception in BulkSolventSliceRegion.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void selectAtoms() {
        this.bulkSolventList.buildList(this.coordinates, this.select, false);
    }
}

