/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.solvent;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelTeam;
import ffx.crystal.Crystal;
import ffx.potential.bonded.Atom;
import ffx.potential.nonbonded.RowRegion;
import ffx.xray.solvent.BulkSolventList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BulkSolventRowRegion
extends RowRegion {
    protected static final Logger logger = Logger.getLogger(BulkSolventRowRegion.class.getName());
    private final BulkSolventList bulkSolventList;
    private final int gZ;
    private final int gY;

    public BulkSolventRowRegion(int gX, int gY, int gZ, double[] grid, int nSymm, int threadCount, Crystal crystal, Atom[] atoms, double[][][] coordinates, double cutoff, ParallelTeam parallelTeam) {
        super(gX, gY, gZ, grid, nSymm, threadCount, atoms, coordinates);
        this.gZ = gZ;
        this.gY = gY;
        Arrays.fill(this.select[0], false);
        this.bulkSolventList = new BulkSolventList(crystal, atoms, cutoff, parallelTeam);
    }

    public void run() {
        try {
            this.execute(0, this.gZ * this.gY - 1, (IntegerForLoop)this.rowLoop[this.getThreadIndex()]);
        }
        catch (Exception e) {
            String message = " Exception in BulkSolventRowRegion.";
            logger.log(Level.SEVERE, message, e);
        }
    }

    public void selectAtoms() {
        this.bulkSolventList.buildList(this.coordinates, this.select, false);
    }
}

