/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.parallel;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public class SliceSchedule
extends IntegerSchedule {
    private final int fftZ;
    private final int[] lowerBounds;
    private int nThreads;
    private boolean[] threadDone;
    private Range[] ranges;
    private int[] weights;

    public SliceSchedule(int nThreads, int fftZ) {
        this.nThreads = nThreads;
        this.fftZ = fftZ;
        int length = FastMath.min((int)nThreads, (int)fftZ);
        this.threadDone = new boolean[length];
        this.ranges = new Range[length];
        this.lowerBounds = new int[length + 1];
    }

    public boolean isFixedSchedule() {
        return true;
    }

    public Range next(int threadID) {
        if (threadID >= FastMath.min((int)this.fftZ, (int)this.nThreads)) {
            return null;
        }
        if (!this.threadDone[threadID]) {
            this.threadDone[threadID] = true;
            return this.ranges[threadID];
        }
        return null;
    }

    public void start(int nThreads, Range chunkRange) {
        this.nThreads = nThreads;
        int length = FastMath.min((int)nThreads, (int)this.fftZ);
        if (length != this.threadDone.length) {
            this.threadDone = new boolean[length];
        }
        Arrays.fill(this.threadDone, false);
        if (length != this.ranges.length) {
            this.ranges = new Range[length];
        }
        Arrays.fill(this.lowerBounds, 0);
        this.defineRanges();
    }

    public void updateWeights(int[] weights) {
        this.weights = weights;
    }

    private int totalWeight() {
        int totalWeight = 0;
        for (int i = 0; i < this.fftZ; ++i) {
            totalWeight += this.weights[i];
        }
        return totalWeight;
    }

    private void defineRanges() {
        int currentThread;
        int length;
        double totalWeight = this.totalWeight();
        if (totalWeight <= (double)(length = FastMath.min((int)this.nThreads, (int)this.fftZ))) {
            Range temp = new Range(0, this.fftZ - 1);
            this.ranges = temp.subranges(length);
            return;
        }
        if (this.nThreads == 1) {
            this.ranges[0] = new Range(0, this.fftZ - 1);
            return;
        }
        double targetWeight = totalWeight / (double)this.nThreads * 0.96;
        int lastSlice = this.fftZ - 1;
        int currentSlice = 0;
        this.lowerBounds[0] = 0;
        for (currentThread = 0; currentThread < length; ++currentThread) {
            int threadWeight = 0;
            while ((double)threadWeight < targetWeight && currentSlice < lastSlice) {
                threadWeight += this.weights[currentSlice];
                ++currentSlice;
            }
            if (currentSlice < lastSlice) {
                this.lowerBounds[currentThread] = currentSlice;
                continue;
            }
            this.lowerBounds[currentThread] = lastSlice;
            break;
        }
        int lastThread = currentThread;
        for (currentThread = 0; currentThread < lastThread - 1; ++currentThread) {
            this.ranges[currentThread] = new Range(this.lowerBounds[currentThread], this.lowerBounds[currentThread + 1] - 1);
        }
        this.ranges[lastThread - 1] = new Range(this.lowerBounds[lastThread - 1], lastSlice);
        for (int it = lastThread; it < length; ++it) {
            this.ranges[it] = null;
        }
    }

    public int[] getThreadWeights() {
        int length = FastMath.min((int)this.fftZ, (int)this.nThreads);
        int[] weightsToReturn = new int[length];
        System.arraycopy(this.weights, 0, weightsToReturn, 0, length);
        return weightsToReturn;
    }

    public int[] getLowerBounds() {
        int length = FastMath.min((int)this.fftZ, (int)this.nThreads);
        int[] boundsToReturn = new int[length];
        System.arraycopy(this.lowerBounds, 1, boundsToReturn, 0, length);
        return boundsToReturn;
    }
}

