/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands.test;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.utilities.FFXBinding;
import ffx.utilities.StringUtils;
import ffx.xray.DiffractionData;
import ffx.xray.XRayEnergy;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinedParameter;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.math3.util.FastMath;
import picocli.CommandLine;

@CommandLine.Command(description={" Test the potential energy gradient."}, name="test.Gradient")
public class Gradient
extends AlgorithmsCommand {
    @CommandLine.Mixin
    AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Mixin
    XrayOptions xrayOptions;
    @CommandLine.Option(names={"-d", "--dx"}, defaultValue="1.0e-5", paramLabel="1.0e-5", description={"Finite-difference step size."})
    public double dx = 1.0E-5;
    @CommandLine.Option(names={"--tol", "--tolerance"}, defaultValue="1.0e-3", paramLabel="1.0e-3 kcal/mol/param", description={"Gradient error tolerance."})
    public double tolerance = 0.001;
    @CommandLine.Option(names={"--params", "--gradientParams"}, paramLabel="ALL", defaultValue="ALL", description={"Ranges of degrees of freedom to test [ALL, NONE, Range(s): 1-3,6-N]."})
    public String gradientParams = "ALL";
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionData diffractionData;
    private XRayEnergy xrayEnergy;
    public int nFailures = 0;

    public Gradient() {
    }

    public Gradient(FFXBinding binding) {
        super(binding);
    }

    public Gradient(String[] args) {
        super(args);
    }

    public Gradient run() {
        ArrayList<Integer> parametersToTest;
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.getFirst());
            this.activeAssembly = this.molecularAssemblies[0];
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        String filename = this.activeAssembly.getFile().getAbsolutePath();
        for (MolecularAssembly assembly : this.molecularAssemblies) {
            this.atomSelectionOptions.setActiveAtoms(assembly);
        }
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        this.diffractionData.scaleBulkFit();
        this.diffractionData.printStats();
        this.xrayEnergy = new XRayEnergy(this.diffractionData);
        RefinementModel refinementModel = this.diffractionData.getRefinementModel();
        RefinementMode refinementMode = refinementModel.getRefinementMode();
        logger.info("\n Testing the gradient of " + filename);
        logger.info(refinementMode.toString());
        logger.info(refinementModel.toString());
        int n = refinementModel.getNumParameters();
        double[] x = new double[n];
        double[] g = new double[n];
        refinementModel.getParameters(x);
        this.xrayEnergy.energyAndGradient(x, g);
        List<RefinedParameter> refinedParameters = refinementModel.getRefinedParameters();
        int numParameters = refinedParameters.size();
        if (this.gradientParams.equalsIgnoreCase("NONE")) {
            logger.info(" The gradient of no parameters will be evaluated.");
            return this;
        }
        if (this.gradientParams.equalsIgnoreCase("ALL")) {
            logger.info(" Checking the gradient for all parameters.\n");
            parametersToTest = new ArrayList<Integer>();
            for (int i = 0; i < numParameters; ++i) {
                parametersToTest.add(i);
            }
        } else {
            parametersToTest = StringUtils.parseAtomRanges((String)" Parameters", (String)this.gradientParams, (int)numParameters);
            logger.info(" Checking the gradient for parameters in the range: " + this.gradientParams + "\n");
        }
        for (Integer parameter : parametersToTest) {
            RefinedParameter refinedParameter = refinedParameters.get(parameter);
            int index = refinedParameter.getIndex();
            int numParams = refinedParameter.getNumberOfParameters();
            double[] grad = new double[numParams];
            double error = 0.0;
            for (int i = 0; i < numParams; ++i) {
                double orig = x[index + i];
                x[index + i] = orig + this.dx;
                double eplus = this.xrayEnergy.energy(x);
                x[index + i] = orig - this.dx;
                double eminus = this.xrayEnergy.energy(x);
                x[index + i] = orig;
                grad[i] = (eplus - eminus) / (2.0 * this.dx);
                double diff = grad[i] - g[index + i];
                error += diff * diff;
            }
            error = FastMath.sqrt((double)error);
            Atom atom = refinedParameter.getAtom();
            if (numParams == 1) {
                logger.info(String.format("\n Refinement parameter %d with index %d: %s", parameter + 1, index, atom));
            } else {
                logger.info(String.format("\n Refinement parameter %d with indices %d - %s: %s", parameter + 1, index, index + numParams - 1, atom));
            }
            logger.info(String.format(" %s", refinedParameter));
            if (error > this.tolerance) {
                logger.info(String.format("  Failed: %10.6f", error));
                ++this.nFailures;
            } else {
                logger.info(String.format("  Passed: %10.6f", error));
            }
            StringBuilder numeric = new StringBuilder("  Numeric:  ");
            StringBuilder analytic = new StringBuilder("  Analytic: ");
            for (int i = 0; i < numParams; ++i) {
                numeric.append(String.format(" %10.6f", grad[i]));
                analytic.append(String.format(" %10.6f", g[index + i]));
            }
            logger.info(numeric.toString());
            logger.info(analytic.toString());
        }
        logger.info("\n %d / %d failures.".formatted(this.nFailures, numParameters));
        return this;
    }

    public List<Potential> getPotentials() {
        List potentials = this.getPotentialsFromAssemblies(this.molecularAssemblies);
        if (this.xrayEnergy != null) {
            potentials.add(this.xrayEnergy);
        }
        return potentials;
    }
}

