/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands.test;

import edu.rit.pj.Comm;
import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.DynamicsOptions;
import ffx.algorithms.cli.LambdaParticleOptions;
import ffx.algorithms.dynamics.MolecularDynamics;
import ffx.algorithms.dynamics.integrators.IntegratorEnum;
import ffx.algorithms.dynamics.thermostats.ThermostatEnum;
import ffx.algorithms.thermodynamics.HistogramData;
import ffx.algorithms.thermodynamics.LambdaData;
import ffx.algorithms.thermodynamics.OrthogonalSpaceTempering;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.bonded.MSNode;
import ffx.realspace.cli.RealSpaceOptions;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.XrayOptions;
import ffx.xray.refine.RefinementMode;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Simulated annealing on an X-ray target."}, name="xray.test.Alchemical")
public class Alchemical
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private DynamicsOptions dynamicsOptions;
    @CommandLine.Mixin
    private LambdaParticleOptions lambdaParticleOptions;
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    private static final Logger logger = Logger.getLogger(RealSpaceOptions.class.getName());
    @CommandLine.Option(names={"-I", "--onlyIons"}, paramLabel="false", description={"Set to only optimize ions (of a single type)."})
    private boolean onlyIons = false;
    @CommandLine.Option(names={"--itype", "--iontype"}, paramLabel="null", description={"Specify which ion to run optimization on. If none is specified, default behavior chooses the first ion found in the PDB file."})
    private String[] ionType = null;
    @CommandLine.Option(names={"-N", "--neutralize"}, paramLabel="false", description={"Neutralize the crystal's charge by adding more of the selected ion"})
    private boolean neutralize = false;
    @CommandLine.Option(names={"-W", "--onlyWater"}, paramLabel="false", description={"Set to only optimize water."})
    private boolean onlyWater = false;
    private RefinementMode refinementMode = RefinementMode.COORDINATES;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private double lambda = 1.0;
    private ThermostatEnum thermostat = ThermostatEnum.ADIABATIC;
    private IntegratorEnum integrator = IntegratorEnum.STOCHASTIC;
    private String fileType = "PDB";
    private boolean runOST = true;
    private boolean initVelocities = true;
    private OrthogonalSpaceTempering orthogonalSpaceTempering;

    public Alchemical() {
    }

    public Alchemical(String[] args) {
        super(args);
    }

    public Alchemical(FFXBinding binding) {
        super(binding);
    }

    public Alchemical run() {
        String modelfilename;
        MolecularAssembly[] assemblies;
        if (!this.init()) {
            return this;
        }
        this.dynamicsOptions.init();
        this.xrayOptions.init();
        System.setProperty("lambdaterm", "true");
        if (this.filenames != null && this.filenames.size() > 0) {
            assemblies = this.algorithmFunctions.openAll(this.filenames.get(0));
            this.activeAssembly = assemblies[0];
            modelfilename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            modelfilename = this.activeAssembly.getFile().getAbsolutePath();
            assemblies = new MolecularAssembly[]{this.activeAssembly};
        }
        logger.info("\n Running Alchemical Changes on " + modelfilename);
        File structureFile = new File(FilenameUtils.normalize((String)modelfilename));
        structureFile = new File(structureFile.getAbsolutePath());
        String baseFilename = FilenameUtils.removeExtension((String)structureFile.getName());
        File histogramRestart = new File(baseFilename + ".his");
        File lambdaRestart = new File(baseFilename + ".lam");
        File dyn = new File(baseFilename + ".dyn");
        Comm world = Comm.world();
        int size = world.size();
        int rank = 0;
        double[] energyArray = new double[world.size()];
        for (int i = 0; i < world.size(); ++i) {
            energyArray[i] = Double.MAX_VALUE;
        }
        if (size > 1) {
            rank = world.rank();
            File rankDirectory = new File(structureFile.getParent() + File.separator + Integer.toString(rank));
            if (!rankDirectory.exists()) {
                rankDirectory.mkdir();
            }
            lambdaRestart = new File(rankDirectory.getPath() + File.separator + baseFilename + ".lam");
            dyn = new File(rankDirectory.getPath() + File.separator + baseFilename + ".dyn");
            structureFile = new File(rankDirectory.getPath() + File.separator + structureFile.getName());
        }
        if (!dyn.exists()) {
            dyn = null;
        }
        Atom[] atoms = this.activeAssembly.getAtomArray();
        ForceFieldEnergy forceFieldEnergy = this.activeAssembly.getPotentialEnergy();
        forceFieldEnergy.setPrintOnFailure(false, false);
        for (int i = 0; i <= atoms.length; ++i) {
            Atom ai = atoms[i - 1];
            ai.setUse(true);
            ai.setActive(false);
            ai.setApplyLambda(false);
        }
        double crystalCharge = this.activeAssembly.getCharge(true);
        logger.info(" Overall crystal charge: " + crystalCharge);
        List ions = assemblies[0].getIons();
        List water = assemblies[0].getWater();
        if (!this.onlyWater) {
            logger.info("Doing ions.");
            if (ions == null || ions.size() == 0) {
                logger.info("\n Please add an ion to the PDB file to scan with.");
                return this;
            }
            for (MSNode msNode : ions) {
                String atomName;
                Object atomList;
                boolean ionSelected = false;
                if (this.ionType != null) {
                    logger.info("Selecting ion.");
                    atomList = msNode.getAtomList();
                    if (!atomList.isEmpty()) {
                        atomName = ((Atom)atomList.get(0)).getName();
                        for (String string : this.ionType) {
                            if (!atomName.equals(string)) continue;
                            ionSelected = true;
                            break;
                        }
                    }
                }
                if (ionSelected) {
                    logger.info("Ion has been selected.");
                    for (Atom atom : msNode.getAtomList()) {
                        System.out.println("Activating ions");
                        atom.setUse(true);
                        atom.setActive(true);
                        atom.setApplyLambda(true);
                        logger.info(" Alchemical atom: " + atom.toString());
                    }
                    continue;
                }
                logger.info("Ion has not been selected.");
                if (this.neutralize) {
                    logger.info("Neutralizing crystal.");
                    double ionCharge = 0.0;
                    for (Atom atom : msNode.getAtomList()) {
                        ionCharge += atom.getMultipoleType().getCharge();
                    }
                    logger.info("Ion charge is: " + Double.toString(ionCharge));
                    int numIons = (int)(-1.0 * Math.ceil(crystalCharge / ionCharge));
                    if (numIons <= 0) continue;
                    List atomList2 = msNode.getAtomList();
                    String atomName2 = atomList2.isEmpty() ? "" : ((Atom)atomList2.get(0)).getName();
                    logger.info(numIons + " " + atomName2 + " ions needed to neutralize the crystal.");
                    this.ionType = new String[]{atomName2};
                    for (Atom atom : msNode.getAtomList()) {
                        atom.setUse(true);
                        atom.setActive(true);
                        atom.setApplyLambda(true);
                        logger.info(" Alchemical atom: " + atom.toString());
                    }
                    continue;
                }
                atomList = msNode.getAtomList();
                atomName = atomList.isEmpty() ? "" : ((Atom)atomList.get(0)).getName();
                this.ionType = new String[]{atomName};
                for (Atom atom : msNode.getAtomList()) {
                    atom.setUse(true);
                    atom.setActive(true);
                    atom.setApplyLambda(true);
                    logger.info(" Alchemical atom: " + atom.toString());
                }
            }
        }
        if (this.onlyWater) {
            for (MSNode msNode : water) {
                for (Atom atom : msNode.getAtomList()) {
                    atom.setUse(true);
                    atom.setActive(true);
                    atom.setApplyLambda(true);
                    logger.info(" Water atom:      " + atom.toString());
                }
            }
        }
        CompositeConfiguration properties = assemblies[0].getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        DiffractionData diffractionData = this.xrayOptions.getDiffractionData(this.filenames, assemblies, properties);
        RefinementEnergy refinementEnergy = this.xrayOptions.toXrayEnergy(diffractionData);
        double[] x = new double[refinementEnergy.getNumberOfVariables()];
        x = refinementEnergy.getCoordinates(x);
        refinementEnergy.energy(x, true);
        refinementEnergy.setLambda(this.lambda);
        CompositeConfiguration props = assemblies[0].getProperties();
        HistogramData histogramData = HistogramData.readHistogram((File)histogramRestart);
        if (lambdaRestart == null) {
            String filename = histogramRestart.toString().replaceFirst("\\.his$", ".lam");
            lambdaRestart = new File(filename);
        }
        LambdaData lambdaData = LambdaData.readLambdaData((File)lambdaRestart);
        OrthogonalSpaceTempering orthogonalSpaceTempering = new OrthogonalSpaceTempering((LambdaInterface)refinementEnergy, (CrystalPotential)refinementEnergy, histogramData, lambdaData, props, this.dynamicsOptions, this.lambdaParticleOptions, this.algorithmListener);
        orthogonalSpaceTempering.setLambda(this.lambda);
        orthogonalSpaceTempering.getOptimizationParameters().setOptimization(true, this.activeAssembly);
        MolecularDynamics molecularDynamics = new MolecularDynamics(assemblies[0], (Potential)orthogonalSpaceTempering, this.algorithmListener, this.thermostat, this.integrator);
        this.algorithmFunctions.energy(assemblies[0]);
        molecularDynamics.dynamic(this.dynamicsOptions.getSteps(), this.dynamicsOptions.getDt(), this.dynamicsOptions.getReport(), this.dynamicsOptions.getWrite(), this.dynamicsOptions.getTemperature(), true, this.fileType, this.dynamicsOptions.getWrite(), dyn);
        logger.info(" Searching for low energy coordinates");
        OrthogonalSpaceTempering.OptimizationParameters opt = orthogonalSpaceTempering.getOptimizationParameters();
        double[] lowEnergyCoordinates = opt.getOptimumCoordinates();
        double currentOSTOptimum = opt.getOptimumEnergy();
        if (lowEnergyCoordinates != null) {
            forceFieldEnergy.setCoordinates(lowEnergyCoordinates);
        } else {
            logger.info(" OST stage did not succeed in finding a minimum.");
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.orthogonalSpaceTempering == null ? Collections.emptyList() : Collections.singletonList(this.orthogonalSpaceTempering);
    }
}

