/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.MSNode;
import ffx.potential.bonded.Molecule;
import ffx.utilities.FFXBinding;
import java.io.File;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(description={" Edit a PDB model for use in refinement."}, name="xray.EditPDB")
public class EditPDB
extends AlgorithmsCommand {
    @CommandLine.Option(names={"--rd", "--repaceDeuterium"}, paramLabel="false", defaultValue="false", description={"Replace deuterium with hydrogen."})
    private boolean replaceDeuterium = false;
    @CommandLine.Option(names={"--altLoc", "--saveAltLoc"}, paramLabel=" ", defaultValue=" ", description={"Save a specific alternate location"})
    private Character altLoc = Character.valueOf(' ');
    @CommandLine.Option(names={"-o", "--occupancy"}, paramLabel="false", defaultValue="false", description={"If a single alternate conformation is being saved, set occupancy values to 1.0."})
    private boolean occupancy = false;
    @CommandLine.Parameters(arity="1", paramLabel="file", description={"PDB input file."})
    private String filename;
    private MolecularAssembly[] molecularAssemblies;

    public EditPDB() {
    }

    public EditPDB(String[] args) {
        super(args);
    }

    public EditPDB(FFXBinding binding) {
        super(binding);
    }

    public EditPDB run() {
        if (!this.init()) {
            return this;
        }
        if (this.filename != null) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filename);
            this.activeAssembly = this.molecularAssemblies[0];
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
            this.filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        logger.info("\n Running xray.EditPDB on " + this.filename);
        for (MolecularAssembly molecularAssembly : this.molecularAssemblies) {
            if (this.replaceDeuterium) {
                List atoms = molecularAssembly.getAtomList();
                for (Atom atom : atoms) {
                    if (!atom.isDeuterium()) continue;
                    String name = atom.getName().toUpperCase();
                    atom.setName(name.replaceFirst("D", "H"));
                }
                List water = molecularAssembly.getWater();
                for (MSNode node : water) {
                    Molecule wat = (Molecule)node;
                    wat.setName("HOH");
                }
            }
            if (this.altLoc.charValue() != ' ' && !molecularAssembly.getAlternateLocation().equals(this.altLoc) || this.altLoc.charValue() == ' ') continue;
            molecularAssembly.setAtomicAltLoc(Character.valueOf(' '));
            if (this.occupancy) {
                molecularAssembly.setOccupancy(1.0);
            }
            this.algorithmFunctions.saveAsPDB(molecularAssembly, new File(this.filename));
        }
        if (this.altLoc.charValue() == ' ') {
            this.algorithmFunctions.saveAsPDB(this.molecularAssemblies, new File(this.filename));
        }
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }
}

