/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.numerics.Potential;
import ffx.potential.MolecularAssembly;
import ffx.utilities.FFXBinding;
import ffx.xray.DiffractionData;
import ffx.xray.cli.XrayOptions;
import ffx.xray.parsers.MTZWriter;
import java.util.List;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Write out computed structure factors without bulk solvent."}, name="xray.ComputeFc")
public class ComputeFc
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private XrayOptions xrayOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Diffraction input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private DiffractionData diffractionData;

    public ComputeFc() {
    }

    public ComputeFc(String[] args) {
        super(args);
    }

    public ComputeFc(FFXBinding binding) {
        super(binding);
    }

    public ComputeFc run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        this.xrayOptions.init();
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.molecularAssemblies = this.algorithmFunctions.openAll(this.filenames.get(0));
            this.activeAssembly = this.molecularAssemblies[0];
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        logger.info("\n Running xray.ComputeFc on " + filename);
        CompositeConfiguration properties = this.activeAssembly.getProperties();
        this.xrayOptions.setProperties(this.parseResult, properties);
        this.diffractionData = this.xrayOptions.getDiffractionData(this.filenames, this.molecularAssemblies, properties);
        this.diffractionData.scaleBulkFit();
        this.diffractionData.printStats();
        MTZWriter mtzWriter = new MTZWriter(this.diffractionData.getReflectionList()[0], this.diffractionData.getRefinementData()[0], FilenameUtils.getBaseName((String)filename) + "_fc.mtz", 2);
        mtzWriter.write();
        return this;
    }

    public List<Potential> getPotentials() {
        return this.getPotentialsFromAssemblies(this.molecularAssemblies);
    }

    public boolean destroyPotentials() {
        return this.diffractionData == null ? true : this.diffractionData.destroy();
    }
}

