/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.crystal.Crystal;
import ffx.crystal.CrystalPotential;
import ffx.numerics.Potential;
import ffx.numerics.math.MatrixMath;
import ffx.numerics.math.ScalarMath;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.LambdaInterface;
import ffx.potential.parameters.ForceField;
import ffx.xray.DiffractionData;
import ffx.xray.refine.RefinementMode;
import ffx.xray.refine.RefinementModel;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class XRayEnergy
implements LambdaInterface,
CrystalPotential {
    private static final Logger logger = Logger.getLogger(XRayEnergy.class.getName());
    private static final double eightPI2 = 78.95683520871486;
    private static final double eightPI23 = 492231.2671105558;
    private final DiffractionData diffractionData;
    private final RefinementModel refinementModel;
    private final RefinementMode refinementMode;
    private final Atom[] activeAtomArray;
    private double[] optimizationScaling = null;
    private final double kTbNonzero;
    private final double kTbSimWeight;
    private final boolean lambdaTerm;
    private final double[] g2;
    private final double[] dUdXdL;
    protected double lambda = 1.0;
    private final int nXYZ;
    private final int nB;
    private final int nOCC;
    private boolean xrayTerms = true;
    private boolean restraintTerms = true;
    private double totalEnergy;
    private double dEdL;
    private Potential.STATE state = Potential.STATE.BOTH;

    public XRayEnergy(DiffractionData diffractionData) {
        this.diffractionData = diffractionData;
        this.refinementModel = diffractionData.getRefinementModel();
        this.refinementMode = this.refinementModel.getRefinementMode();
        this.nXYZ = this.refinementModel.getNumCoordParameters();
        this.nB = this.refinementModel.getNumBFactorParameters();
        this.nOCC = this.refinementModel.getNumOccupancyParameters();
        double temperature = 50.0;
        this.kTbNonzero = 0.0019872042586408316 * temperature * diffractionData.getbNonZeroWeight();
        this.kTbSimWeight = 0.0019872042586408316 * temperature * diffractionData.getbSimWeight();
        ForceField forceField = diffractionData.getAssembly()[0].getForceField();
        this.lambdaTerm = forceField.getBoolean("LAMBDATERM", false);
        this.activeAtomArray = this.refinementModel.getActiveAtoms();
        int count = this.activeAtomArray.length;
        this.dUdXdL = new double[count * 3];
        this.g2 = new double[count * 3];
        if (this.refinementMode.includesBFactors()) {
            logger.info("\n B-Factor Refinement Parameters");
            logger.info("  Temperature:                 " + temperature);
            logger.info("  Non-zero restraint weight:   " + diffractionData.getbNonZeroWeight());
            logger.info("  Similarity restraint weight: " + diffractionData.getbSimWeight());
        }
    }

    public boolean destroy() {
        return this.diffractionData.destroy();
    }

    public double energy(double[] x) {
        double e = 0.0;
        this.unscaleCoordinates(x);
        this.refinementModel.setParameters(x);
        if (this.refinementMode.includesCoordinates()) {
            this.diffractionData.updateCoordinates();
        }
        if (this.xrayTerms) {
            if (this.lambdaTerm) {
                this.diffractionData.setLambdaTerm(false);
            }
            this.diffractionData.computeAtomicDensity();
            e = this.diffractionData.computeLikelihood();
            if (this.lambdaTerm) {
                this.diffractionData.setLambdaTerm(true);
                this.diffractionData.computeAtomicDensity();
                double e2 = this.diffractionData.computeLikelihood();
                this.dEdL = e - e2;
                e = this.lambda * e + (1.0 - this.lambda) * e2;
                this.diffractionData.setLambdaTerm(false);
            }
        }
        if (this.restraintTerms && this.refinementMode.includesBFactors()) {
            e += this.getBFactorRestraints(false);
        }
        this.scaleCoordinates(x);
        this.totalEnergy = e;
        return e;
    }

    public double energyAndGradient(double[] x, double[] g) {
        double e = 0.0;
        this.unscaleCoordinates(x);
        this.refinementModel.setParameters(x);
        this.refinementModel.zeroGradient();
        if (this.refinementMode.includesCoordinates()) {
            this.diffractionData.updateCoordinates();
        }
        if (this.xrayTerms) {
            if (this.lambdaTerm) {
                this.diffractionData.setLambdaTerm(false);
            }
            this.diffractionData.computeAtomicDensity();
            e = this.diffractionData.computeLikelihood();
            this.diffractionData.computeAtomicGradients(this.refinementMode);
            if (this.lambdaTerm) {
                logger.severe(" Lambda Refinement is not supported.");
                int n = this.dUdXdL.length;
                System.arraycopy(g, 0, this.dUdXdL, 0, n);
                for (Atom a : this.activeAtomArray) {
                    a.setXYZGradient(0.0, 0.0, 0.0);
                    a.setLambdaXYZGradient(0.0, 0.0, 0.0);
                }
                this.diffractionData.setLambdaTerm(true);
                this.diffractionData.computeAtomicDensity();
                double e2 = this.diffractionData.computeLikelihood();
                this.diffractionData.computeAtomicGradients(this.refinementMode);
                this.dEdL = e - e2;
                e = this.lambda * e + (1.0 - this.lambda) * e2;
                for (int i = 0; i < g.length; ++i) {
                    int n2 = i;
                    this.dUdXdL[n2] = this.dUdXdL[n2] - this.g2[i];
                    g[i] = this.lambda * g[i] + (1.0 - this.lambda) * this.g2[i];
                }
                this.diffractionData.setLambdaTerm(false);
            }
        }
        if (this.restraintTerms && this.refinementMode.includesBFactors()) {
            e += this.getBFactorRestraints(true);
        }
        this.refinementModel.getGradient(g);
        this.scaleCoordinatesAndGradient(x, g);
        this.totalEnergy = e;
        return e;
    }

    public double[] getCoordinates(double[] x) {
        if (x == null || x.length != this.refinementModel.getNumParameters()) {
            x = new double[this.refinementModel.getNumParameters()];
        }
        this.refinementModel.getParameters(x);
        return x;
    }

    public void setCoordinates(double[] x) {
        this.refinementModel.setParameters(x);
    }

    public Crystal getCrystal() {
        return this.diffractionData.getCrystal()[0];
    }

    public void setCrystal(Crystal crystal) {
        logger.severe(" XRayEnergy does implement setCrystal yet.");
    }

    public Potential.STATE getEnergyTermState() {
        return this.state;
    }

    public void setEnergyTermState(Potential.STATE state) {
        this.state = state;
        switch (state) {
            case FAST: {
                this.xrayTerms = false;
                this.restraintTerms = true;
                break;
            }
            case SLOW: {
                this.xrayTerms = true;
                this.restraintTerms = false;
                break;
            }
            default: {
                this.xrayTerms = true;
                this.restraintTerms = true;
            }
        }
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        if (lambda <= 1.0 && lambda >= 0.0) {
            this.lambda = lambda;
        } else {
            String message = String.format("Lambda value %8.3f is not in the range [0..1].", lambda);
            logger.warning(message);
        }
    }

    public double[] getMass() {
        double[] mass = new double[this.nXYZ + this.nB + this.nOCC];
        this.refinementModel.getMass(mass);
        return mass;
    }

    public int getNumberOfVariables() {
        return this.nXYZ + this.nB + this.nOCC;
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(@Nullable double[] scaling) {
        this.optimizationScaling = scaling;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public Potential.VARIABLE_TYPE[] getVariableTypes() {
        Potential.VARIABLE_TYPE[] vtypes = new Potential.VARIABLE_TYPE[this.nXYZ + this.nB + this.nOCC];
        int i = 0;
        if (this.refinementMode.includesCoordinates()) {
            for (Atom a : this.activeAtomArray) {
                vtypes[i++] = Potential.VARIABLE_TYPE.X;
                vtypes[i++] = Potential.VARIABLE_TYPE.Y;
                vtypes[i++] = Potential.VARIABLE_TYPE.Z;
            }
        }
        if (this.refinementMode.includesBFactors()) {
            for (int j = i; j < this.nXYZ + this.nB; ++j) {
                vtypes[j] = Potential.VARIABLE_TYPE.OTHER;
                ++i;
            }
        }
        if (this.refinementMode.includesOccupancies()) {
            for (int j = i; j < this.nXYZ + this.nB + this.nOCC; ++j) {
                vtypes[j] = Potential.VARIABLE_TYPE.OTHER;
                ++i;
            }
        }
        return vtypes;
    }

    public double[] getVelocity(double[] velocity) {
        if (velocity == null || velocity.length != this.refinementModel.getNumParameters()) {
            velocity = new double[this.refinementModel.getNumParameters()];
        }
        this.refinementModel.getVelocity(velocity);
        return velocity;
    }

    public void setVelocity(double[] velocity) {
        this.refinementModel.setVelocity(velocity);
    }

    public double getd2EdL2() {
        return 0.0;
    }

    public double getdEdL() {
        return this.dEdL;
    }

    public void getdEdXdL(double[] gradient) {
        int n = this.dUdXdL.length;
        System.arraycopy(this.dUdXdL, 0, gradient, 0, n);
    }

    public void setAcceleration(double[] acceleration) {
        this.refinementModel.setAcceleration(acceleration);
    }

    public double[] getAcceleration(double[] acceleration) {
        if (acceleration == null || acceleration.length != this.refinementModel.getNumParameters()) {
            acceleration = new double[this.refinementModel.getNumParameters()];
        }
        this.refinementModel.getAcceleration(acceleration);
        return acceleration;
    }

    public void setPreviousAcceleration(double[] previousAcceleration) {
        this.refinementModel.setPreviousAcceleration(previousAcceleration);
    }

    public double[] getPreviousAcceleration(double[] previousAcceleration) {
        if (previousAcceleration == null || previousAcceleration.length != this.refinementModel.getNumParameters()) {
            previousAcceleration = new double[this.refinementModel.getNumParameters()];
        }
        this.refinementModel.getPreviousAcceleration(previousAcceleration);
        return previousAcceleration;
    }

    private double getBFactorRestraints(boolean gradient) {
        double e = 0.0;
        double[] anisou1 = new double[6];
        double[] gradu = new double[6];
        double threeHalves = 1.5;
        double oneHalf = 0.5;
        for (Atom a : this.activeAtomArray) {
            if (a.getAnisou(null) == null) {
                double biso = a.getTempFactor();
                e += -this.kTbNonzero * Math.log(Math.pow(biso, threeHalves));
                if (!gradient) continue;
                double gradb = -this.kTbNonzero * threeHalves / biso;
                a.addToTempFactorGradient(gradb);
                continue;
            }
            anisou1 = a.getAnisou(anisou1);
            double det = MatrixMath.mat3Determinant((double[])anisou1);
            e += ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * Math.log(det)));
            if (!gradient) continue;
            gradu[0] = ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * ((anisou1[1] * anisou1[2] - anisou1[5] * anisou1[5]) / det)));
            gradu[1] = ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * ((anisou1[0] * anisou1[2] - anisou1[4] * anisou1[4]) / det)));
            gradu[2] = ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * ((anisou1[0] * anisou1[1] - anisou1[3] * anisou1[3]) / det)));
            gradu[3] = ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * (2.0 * (anisou1[4] * anisou1[5] - anisou1[3] * anisou1[2]) / det)));
            gradu[4] = ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * (2.0 * (anisou1[3] * anisou1[5] - anisou1[4] * anisou1[1]) / det)));
            gradu[5] = ScalarMath.u2b((double)(-oneHalf * this.kTbNonzero * (2.0 * (anisou1[3] * anisou1[4] - anisou1[5] * anisou1[0]) / det)));
            a.addToAnisouGradient(gradu);
        }
        List<Atom[]> bonds = this.refinementModel.getBFactorRestraints();
        for (Atom[] atoms : bonds) {
            double bdiff;
            boolean isAnisou2;
            Atom a1 = atoms[0];
            Atom a2 = atoms[1];
            boolean isAnisou1 = a1.getAnisou(null) != null;
            boolean bl = isAnisou2 = a2.getAnisou(null) != null;
            if (!isAnisou1 && !isAnisou2) {
                double b1 = a1.getTempFactor();
                double b2 = a2.getTempFactor();
                bdiff = b1 - b2;
                e += this.kTbSimWeight * bdiff * bdiff;
                if (!gradient) continue;
                double gradb = 2.0 * this.kTbSimWeight * bdiff;
                a1.addToTempFactorGradient(gradb);
                a2.addToTempFactorGradient(-gradb);
                continue;
            }
            if (isAnisou1 && isAnisou2) {
                anisou1 = a1.getAnisou(anisou1);
                double[] anisou2 = a2.getAnisou(anisou1);
                double det1 = MatrixMath.mat3Determinant((double[])anisou1);
                double det2 = MatrixMath.mat3Determinant((double[])anisou2);
                bdiff = det1 - det2;
                double bdiff2 = bdiff * bdiff;
                e += 492231.2671105558 * this.kTbSimWeight * bdiff2;
                if (!gradient) continue;
                double gradb = 984462.5342211116 * this.kTbSimWeight * bdiff;
                gradu[0] = gradb * (anisou1[1] * anisou1[2] - anisou1[5] * anisou1[5]);
                gradu[1] = gradb * (anisou1[0] * anisou1[2] - anisou1[4] * anisou1[4]);
                gradu[2] = gradb * (anisou1[0] * anisou1[1] - anisou1[3] * anisou1[3]);
                gradu[3] = gradb * (2.0 * (anisou1[4] * anisou1[5] - anisou1[3] * anisou1[2]));
                gradu[4] = gradb * (2.0 * (anisou1[3] * anisou1[5] - anisou1[4] * anisou1[1]));
                gradu[5] = gradb * (2.0 * (anisou1[3] * anisou1[4] - anisou1[5] * anisou1[0]));
                a1.addToAnisouGradient(gradu);
                gradu[0] = gradb * (anisou2[5] * anisou2[5] - anisou2[1] * anisou2[2]);
                gradu[1] = gradb * (anisou2[4] * anisou2[4] - anisou2[0] * anisou2[2]);
                gradu[2] = gradb * (anisou2[3] * anisou2[3] - anisou2[0] * anisou2[1]);
                gradu[3] = gradb * (2.0 * (anisou2[3] * anisou2[2] - anisou2[4] * anisou2[5]));
                gradu[4] = gradb * (2.0 * (anisou2[4] * anisou2[1] - anisou2[3] * anisou2[5]));
                gradu[5] = gradb * (2.0 * (anisou2[5] * anisou2[0] - anisou2[3] * anisou2[4]));
                a2.addToAnisouGradient(gradu);
                continue;
            }
            if (!isAnisou1) {
                a1 = atoms[1];
                a2 = atoms[0];
            }
            anisou1 = a1.getAnisou(anisou1);
            double u2 = ScalarMath.b2u((double)a2.getTempFactor());
            double det1 = MatrixMath.mat3Determinant((double[])anisou1);
            double det2 = u2 * u2 * u2;
            double bdiff2 = det1 - det2;
            double bdiff22 = bdiff2 * bdiff2;
            e += 492231.2671105558 * this.kTbSimWeight * bdiff22;
            if (!gradient) continue;
            double gradb = 984462.5342211116 * this.kTbSimWeight * bdiff2;
            gradu[0] = gradb * (anisou1[1] * anisou1[2] - anisou1[5] * anisou1[5]);
            gradu[1] = gradb * (anisou1[0] * anisou1[2] - anisou1[4] * anisou1[4]);
            gradu[2] = gradb * (anisou1[0] * anisou1[1] - anisou1[3] * anisou1[3]);
            gradu[3] = gradb * (2.0 * (anisou1[4] * anisou1[5] - anisou1[3] * anisou1[2]));
            gradu[4] = gradb * (2.0 * (anisou1[3] * anisou1[5] - anisou1[4] * anisou1[1]));
            gradu[5] = gradb * (2.0 * (anisou1[3] * anisou1[4] - anisou1[5] * anisou1[0]));
            a1.addToAnisouGradient(gradu);
            double gradBiso = ScalarMath.u2b((double)(-gradb * u2 * u2));
            a2.addToTempFactorGradient(gradBiso);
        }
        return e;
    }
}

