/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.ReflectionSpline;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.math.ComplexNumber;
import ffx.xray.DiffractionRefinementData;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class SplineEnergy
implements OptimizationInterface {
    private static final Logger logger = Logger.getLogger(SplineEnergy.class.getName());
    private final ReflectionList reflectionList;
    private final ReflectionSpline spline;
    private final int nParams;
    private final SplineType type;
    private final Crystal crystal;
    private final DiffractionRefinementData refinementData;
    private final double[][] fc;
    private final double[][] fo;
    private final ComplexNumber fct = new ComplexNumber();
    private double[] optimizationScaling = null;
    private double totalEnergy;

    SplineEnergy(ReflectionList reflectionList, DiffractionRefinementData refinementData, int nParams, SplineType type) {
        this.reflectionList = reflectionList;
        this.crystal = reflectionList.crystal;
        this.refinementData = refinementData;
        this.type = type;
        this.fc = refinementData.fc;
        this.fo = refinementData.fSigF;
        this.spline = new ReflectionSpline(reflectionList, nParams);
        this.nParams = nParams;
    }

    public boolean destroy() {
        return true;
    }

    public double energy(double[] x) {
        this.unscaleCoordinates(x);
        double sum = this.target(x, null, false, false);
        this.scaleCoordinates(x);
        return sum;
    }

    public double energyAndGradient(double[] x, double[] g) {
        this.unscaleCoordinates(x);
        double sum = this.target(x, g, true, false);
        this.scaleCoordinatesAndGradient(x, g);
        return sum;
    }

    public double[] getCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getNumberOfVariables() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(double[] scaling) {
        this.optimizationScaling = (double[])(scaling != null && scaling.length == this.nParams ? scaling : null);
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double target(double[] x, double[] g, boolean gradient, boolean print) {
        int i;
        double r = 0.0;
        double rf = 0.0;
        double rfree = 0.0;
        double rfreef = 0.0;
        double sum = 0.0;
        double sumfo = 1.0;
        if (gradient) {
            Arrays.fill(g, 0.0);
        }
        for (HKL ih : this.reflectionList.hklList) {
            i = ih.getIndex();
            if (Double.isNaN(this.fc[i][0]) || Double.isNaN(this.fo[i][0]) || this.fo[i][1] <= 0.0 || this.type == SplineType.FOTOESQ && this.fo[i][0] <= 0.0) continue;
            double eps = ih.getEpsilon();
            double s = this.crystal.invressq(ih);
            double fh = this.spline.f(s, x);
            this.refinementData.getFcTotIP(i, this.fct);
            double d2 = 0.0;
            double dr = 0.0;
            double w = 0.0;
            switch (this.type.ordinal()) {
                case 0: {
                    w = 1.0;
                    double f1 = this.refinementData.getF(i);
                    double f2 = this.fct.abs();
                    double d = f1 - fh * f2;
                    d2 = d * d;
                    dr = -2.0 * f2 * d;
                    sumfo += f1 * f1;
                    break;
                }
                case 1: {
                    w = 2.0 / (double)ih.epsilonc();
                    double ieps = 1.0 / eps;
                    double f1 = FastMath.pow((double)this.fct.abs(), (double)2.0) * ieps;
                    double f2 = FastMath.pow((double)this.refinementData.getF(i), (int)2) * ieps;
                    double d = fh * f1 - f2;
                    d2 = d * d / f1;
                    dr = 2.0 * d;
                    break;
                }
                case 2: {
                    w = 2.0 / (double)ih.epsilonc();
                    double f1 = FastMath.pow((double)(this.fct.abs() / FastMath.sqrt((double)eps)), (int)2);
                    double d = f1 * fh - 1.0;
                    d2 = d * d / f1;
                    dr = 2.0 * d;
                    break;
                }
                case 3: {
                    w = 2.0 / (double)ih.epsilonc();
                    double f1 = FastMath.pow((double)(this.refinementData.getF(i) / FastMath.sqrt((double)eps)), (int)2);
                    double d = f1 * fh - 1.0;
                    d2 = d * d / f1;
                    dr = 2.0 * d;
                }
            }
            sum += w * d2;
            double afo = FastMath.abs((double)this.fo[i][0]);
            double afh = FastMath.abs((double)(fh * this.fct.abs()));
            if (this.refinementData.isFreeR(i)) {
                rfree += FastMath.abs((double)(afo - afh));
                rfreef += afo;
            } else {
                r += FastMath.abs((double)(afo - afh));
                rf += afo;
            }
            if (!gradient) continue;
            int i0 = this.spline.i0();
            int i1 = this.spline.i1();
            int i2 = this.spline.i2();
            double g0 = this.spline.dfi0();
            double g1 = this.spline.dfi1();
            double g2 = this.spline.dfi2();
            int n = i0;
            g[n] = g[n] + w * dr * g0;
            int n2 = i1;
            g[n2] = g[n2] + w * dr * g1;
            int n3 = i2;
            g[n3] = g[n3] + w * dr * g2;
        }
        if (gradient && this.type == SplineType.FOFC) {
            double isumfo = 1.0 / sumfo;
            i = 0;
            while (i < g.length) {
                int n = i++;
                g[n] = g[n] * isumfo;
            }
        }
        if (print) {
            StringBuilder sb = new StringBuilder("\n");
            sb.append(" Computed Potential Energy\n");
            sb.append(String.format("   residual:  %8.3f\n", sum / sumfo));
            if (this.type == SplineType.FOFC || this.type == SplineType.F1F2) {
                sb.append(String.format("   R:  %8.3f  Rfree:  %8.3f\n", r / rf * 100.0, rfree / rfreef * 100.0));
            }
            sb.append("x: ");
            for (double x1 : x) {
                sb.append(String.format("%8g ", x1));
            }
            sb.append("\ng: ");
            for (double v : g) {
                sb.append(String.format("%8g ", v));
            }
            sb.append("\n");
            logger.info(sb.toString());
        }
        this.totalEnergy = sum / sumfo;
        return sum / sumfo;
    }

    public static enum SplineType {
        FOFC,
        F1F2,
        FCTOESQ,
        FOTOESQ;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Fo to Fc";
                case 1 -> "F1 to F2";
                case 2 -> "Fc to Esq";
                case 3 -> "Fo to Esq";
            };
        }
    }
}

