/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import edu.rit.pj.ParallelTeam;
import ffx.algorithms.Terminatable;
import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.math.ScalarMath;
import ffx.numerics.optimization.LBFGS;
import ffx.numerics.optimization.LineSearch;
import ffx.numerics.optimization.OptimizationListener;
import ffx.xray.CrystalReciprocalSpace;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.ScaleBulkEnergy;
import ffx.xray.solvent.SolventModel;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

public class ScaleBulkMinimize
implements OptimizationListener,
Terminatable {
    private static final Logger logger = Logger.getLogger(ScaleBulkMinimize.class.getName());
    private final ReflectionList reflectionList;
    private final DiffractionRefinementData refinementData;
    private final Crystal crystal;
    private final CrystalReciprocalSpace crystalReciprocalSpace;
    private final ScaleBulkEnergy bulkSolventEnergy;
    private final int solventN;
    private final int n;
    private final double[] x;
    private final double[] grad;
    private final double[] scaling;
    private boolean done = false;
    private boolean terminate = false;
    private long time;
    private double grms;
    private int nSteps;

    public ScaleBulkMinimize(ReflectionList reflectionList, DiffractionRefinementData refinementData, CrystalReciprocalSpace crystalReciprocalSpace, ParallelTeam parallelTeam) {
        this.reflectionList = reflectionList;
        this.refinementData = refinementData;
        this.crystal = reflectionList.crystal;
        this.crystalReciprocalSpace = crystalReciprocalSpace;
        this.solventN = crystalReciprocalSpace.getSolventModel() == SolventModel.NONE || refinementData.bulkSolventFixed ? 1 : 3;
        this.n = this.solventN + refinementData.nScale;
        this.bulkSolventEnergy = new ScaleBulkEnergy(reflectionList, refinementData, this.n, parallelTeam);
        this.x = new double[this.n];
        this.grad = new double[this.n];
        this.scaling = new double[this.n];
        Arrays.fill(this.scaling, 1.0);
        if (refinementData.modelScaleK == 0.0) {
            this.x[0] = this.getInitialKOverall(this.x);
            logger.info(String.format("\n Initial K_Overall (Fc to Fo Scale): %4.2f", FastMath.exp((double)(0.25 * this.x[0]))));
        } else {
            this.x[0] = refinementData.modelScaleK;
        }
        if (this.solventN > 1) {
            this.x[1] = refinementData.bulkSolventK;
            this.x[2] = refinementData.bulkSolventUeq;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.crystal.scaleB[i] < 0) continue;
            this.x[this.solventN + this.crystal.scaleB[i]] = refinementData.modelAnisoB[i];
        }
    }

    public double[] getCoordinates(@Nullable double[] x) {
        if (x == null) {
            x = new double[this.x.length];
        }
        System.arraycopy(this.x, 0, x, 0, this.x.length);
        return x;
    }

    public int getNumberOfVariables() {
        return this.x.length;
    }

    public ScaleBulkEnergy minimize(double eps) {
        return this.minimize(7, eps);
    }

    public ScaleBulkEnergy minimize(int m, double eps) {
        this.bulkSolventEnergy.setScaling(this.scaling);
        double e = this.bulkSolventEnergy.energyAndGradient(this.x, this.grad);
        long mtime = -System.nanoTime();
        this.time = -System.nanoTime();
        this.done = false;
        int status = LBFGS.minimize((int)this.n, (int)m, (double[])this.x, (double)e, (double[])this.grad, (double)eps, (OptimizationInterface)this.bulkSolventEnergy, (OptimizationListener)this);
        this.done = true;
        switch (status) {
            case 0: {
                logger.info(String.format("\n Optimization achieved convergence criteria: %10.5f\n", this.grms));
                break;
            }
            case 1: {
                logger.info(String.format("\n Optimization terminated at step %d.\n", this.nSteps));
                break;
            }
            default: {
                logger.warning("\n Optimization failed.\n");
            }
        }
        this.refinementData.modelScaleK = this.x[0] / this.scaling[0];
        if (this.solventN > 1) {
            this.refinementData.bulkSolventK = this.x[1] / this.scaling[1];
            this.refinementData.bulkSolventUeq = this.x[2] / this.scaling[2];
        }
        for (int i = 0; i < 6; ++i) {
            int offset = this.crystal.scaleB[i];
            if (offset < 0) continue;
            int index = this.solventN + offset;
            this.refinementData.modelAnisoB[i] = this.x[index] / this.scaling[index];
        }
        logger.info(String.format(" Optimization time: %8.3f (sec)\n", (double)(mtime += System.nanoTime()) * 1.0E-9));
        this.bulkSolventEnergy.setScaling(null);
        return this.bulkSolventEnergy;
    }

    public boolean optimizationUpdate(int iter, int nBFGS, int nfun, double grms, double xrms, double f, double df, double angle, LineSearch.LineSearchResult info) {
        long currentTime = System.nanoTime();
        Double seconds = (double)(currentTime - this.time) * 1.0E-9;
        this.time = currentTime;
        this.grms = grms;
        this.nSteps = iter;
        if (iter == 0) {
            if (nBFGS > 0) {
                if (this.solventN > 1) {
                    logger.info("\n Limited Memory BFGS Quasi-Newton Optimization of Scaling and Solvent Parameters\n");
                } else {
                    logger.info("\n Limited Memory BFGS Quasi-Newton Optimization of Overall Scaling Parameters\n");
                }
            } else if (this.solventN > 1) {
                logger.info("\n Steepest Decent Optimization of Scaling and Solvent Parameters\n");
            } else {
                logger.info("\n Steepest Decent Optimization of Overall Scaling Parameters\n");
            }
            logger.info(" Cycle       Energy      G RMS    Delta E   Delta X    Angle  Evals     Time      R  Rfree");
        }
        if (info == null) {
            logger.info(String.format("%6d %12.5f %10.6f", iter, f, grms));
        } else if (info == LineSearch.LineSearchResult.Success) {
            double R = this.bulkSolventEnergy.getR();
            double Rfree = this.bulkSolventEnergy.getRfree();
            logger.info(String.format("%6d %12.5f %10.6f %10.6f %9.5f %8.2f %6d %8.3f %5.3f %5.3f", iter, f, grms, df, xrms, angle, nfun, seconds, R, Rfree));
        } else {
            logger.info(String.format("%6d %12.5f %10.6f %10.6f %9.5f %8.2f %6d %8s", iter, f, grms, df, xrms, angle, nfun, info));
        }
        if (this.terminate) {
            logger.info(" The optimization received a termination request.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminate = true;
        while (!this.done) {
            ScaleBulkMinimize scaleBulkMinimize = this;
            synchronized (scaleBulkMinimize) {
                try {
                    this.wait(1L);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception terminating minimization.\n", e);
                }
            }
        }
    }

    ScaleBulkEnergy getScaleBulkEnergy() {
        return this.bulkSolventEnergy;
    }

    private double getInitialKOverall(double[] x) {
        double[][] fc = this.refinementData.fc;
        double[][] fSigf = this.refinementData.fSigF;
        double[] grad = new double[x.length];
        this.bulkSolventEnergy.setScaling(this.scaling);
        double e = this.bulkSolventEnergy.energyAndGradient(x, grad);
        this.bulkSolventEnergy.setScaling(null);
        double sumfofc = 0.0;
        double sumfc = 0.0;
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            if (Double.isNaN(fc[i][0]) || Double.isNaN(fSigf[i][0]) || fSigf[i][1] <= 0.0) continue;
            double fcTotF = this.refinementData.fcTotF(i);
            sumfofc += fSigf[i][0] * fcTotF;
            sumfc += fcTotF * fcTotF;
        }
        return 4.0 * FastMath.log((double)(sumfofc / sumfc));
    }

    public void gridOptimizeBulkSolventModel() {
        double initialTarget;
        if (this.crystalReciprocalSpace == null) {
            return;
        }
        this.bulkSolventEnergy.setScaling(this.scaling);
        this.crystalReciprocalSpace.setDefaultSolventAB();
        this.crystalReciprocalSpace.computeDensity(this.refinementData.fs);
        double min = initialTarget = this.bulkSolventEnergy.energy(this.x);
        double R = this.bulkSolventEnergy.getR();
        double Rfree = this.bulkSolventEnergy.getRfree();
        double minR = R;
        double minRfree = Rfree;
        double solventA = this.crystalReciprocalSpace.getSolventA();
        double solventB = this.crystalReciprocalSpace.getSolventB();
        double amin = solventA - 2.0;
        double amax = solventA + 2.0;
        double astep = 0.25;
        double bmin = solventB - 0.2;
        double bmax = solventB + 0.2;
        double bstep = 0.05;
        if (this.crystalReciprocalSpace.getSolventModel() == SolventModel.BINARY) {
            amin = solventA - 0.4;
            amax = solventA + 0.4;
            astep = 0.05;
        }
        logger.info(" Grid Search for Bulk Solvent Model Parameters");
        logger.info("               A      B    Target      R  Rfree");
        logger.info(String.format(" Initial: %6.3f %6.3f %9.6f %6.3f %6.3f ", solventA, solventB, min, R, Rfree));
        int index = 0;
        for (double a = amin; a <= amax; a += astep) {
            for (double b = bmin; b <= bmax; b += bstep) {
                this.crystalReciprocalSpace.setSolventAB(a, b);
                this.crystalReciprocalSpace.computeDensity(this.refinementData.fs);
                double sum = this.bulkSolventEnergy.energy(this.x);
                R = this.bulkSolventEnergy.getR();
                Rfree = this.bulkSolventEnergy.getRfree();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" %8d %6.3f %6.3f %9.6f %6.3f %6.3f ", index, a, b, sum, R, Rfree));
                } else if (sum < min) {
                    logger.info(String.format(" %8d %6.3f %6.3f %9.6f %6.3f %6.3f ", index, a, b, sum, R, Rfree));
                }
                ++index;
                if (!(sum < min)) continue;
                min = sum;
                minR = R;
                minRfree = Rfree;
                solventA = a;
                solventB = b;
            }
        }
        logger.info(String.format(" Minimum: %6.3f %6.3f %9.6f %6.3f %6.3f ", solventA, solventB, min, minR, minRfree));
        if (min < initialTarget) {
            this.crystalReciprocalSpace.setSolventAB(solventA, solventB);
            this.crystalReciprocalSpace.computeDensity(this.refinementData.fs);
        }
        this.bulkSolventEnergy.setScaling(null);
    }

    public void gridOptimizeKsBs() {
        if (this.solventN < 3) {
            return;
        }
        this.bulkSolventEnergy.setScaling(this.scaling);
        double bulkSolventK = this.refinementData.bulkSolventK;
        double bulkSolventUeq = this.refinementData.bulkSolventUeq;
        this.x[0] = this.refinementData.modelScaleK;
        this.x[1] = bulkSolventK;
        this.x[2] = bulkSolventUeq;
        double initialSum = this.bulkSolventEnergy.energy(this.x);
        double initialR = this.bulkSolventEnergy.getR();
        double initialRfree = this.bulkSolventEnergy.getRfree();
        double min = initialSum;
        if (bulkSolventK < 0.3) {
            bulkSolventK = 0.3;
        }
        if (ScalarMath.u2b((double)bulkSolventUeq) < 40.0) {
            bulkSolventUeq = ScalarMath.b2u((double)40.0);
        }
        double kmin = bulkSolventK - 0.3;
        double kmax = bulkSolventK + 0.3;
        double kstep = 0.02;
        double initialB = ScalarMath.u2b((double)bulkSolventUeq);
        double umin = ScalarMath.b2u((double)Math.max(0.0, initialB - 40.0));
        double umax = ScalarMath.b2u((double)(initialB + 40.0));
        double ustep = ScalarMath.b2u((double)2.0);
        logger.info("\n Grid Search for Bulk Solvent Ks and Bs");
        logger.info("             Ks       Bs   Target      R  Rfree");
        logger.info(String.format(" Initial: %5.3f %8.3f %8.5f %5.3f %5.3f", bulkSolventK, ScalarMath.u2b((double)bulkSolventUeq), initialSum, initialR, initialRfree));
        int index = 0;
        for (double ks = kmin; ks <= kmax; ks += kstep) {
            for (double ku = umin; ku <= umax; ku += ustep) {
                this.x[1] = ks;
                this.x[2] = ku;
                double sum = this.bulkSolventEnergy.energy(this.x);
                double R = this.bulkSolventEnergy.getR();
                double Rfree = this.bulkSolventEnergy.getRfree();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format(" %8d %5.3f %8.3f %8.5f %5.3f %5.3f", index, ks, ScalarMath.u2b((double)ku), sum, R, Rfree));
                } else if (sum < min) {
                    logger.info(String.format(" %8d %5.3f %8.3f %8.5f %5.3f %5.3f", index, ks, ScalarMath.u2b((double)ku), sum, R, Rfree));
                }
                ++index;
                if (!(sum < min)) continue;
                min = sum;
                bulkSolventK = ks;
                bulkSolventUeq = ku;
            }
        }
        this.x[1] = bulkSolventK;
        this.x[2] = bulkSolventUeq;
        double sum = this.bulkSolventEnergy.energy(this.x);
        double R = this.bulkSolventEnergy.getR();
        double Rfree = this.bulkSolventEnergy.getRfree();
        logger.info(String.format(" Minimum: %5.3f %8.3f %8.5f %5.3f %5.3f", bulkSolventK, ScalarMath.u2b((double)bulkSolventUeq), sum, R, Rfree));
        if (sum < initialSum) {
            this.refinementData.bulkSolventK = bulkSolventK;
            this.refinementData.bulkSolventUeq = bulkSolventUeq;
        }
        this.bulkSolventEnergy.setScaling(null);
    }
}

