/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.SharedDouble;
import edu.rit.pj.reduction.SharedDoubleArray;
import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.numerics.OptimizationInterface;
import ffx.numerics.math.ComplexNumber;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.MatrixMath;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.solvent.SolventModel;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.math3.util.FastMath;

public class ScaleBulkEnergy
implements OptimizationInterface {
    private static final Logger logger = Logger.getLogger(ScaleBulkEnergy.class.getName());
    private static final double twopi2 = 19.739208802178716;
    private static final double[] v000 = new double[]{0.0, 0.0, 0.0};
    private static final double[] v100 = new double[]{1.0, 0.0, 0.0};
    private static final double[] v010 = new double[]{0.0, 1.0, 0.0};
    private static final double[] v001 = new double[]{0.0, 0.0, 1.0};
    private static final double[][] u11 = new double[][]{v100, v000, v000};
    private static final double[][] u22 = new double[][]{v000, v010, v000};
    private static final double[][] u33 = new double[][]{v000, v000, v001};
    private static final double[][] u12 = new double[][]{v010, v100, v000};
    private static final double[][] u13 = new double[][]{v001, v000, v100};
    private static final double[][] u23 = new double[][]{v000, v001, v010};
    private final double[][] recipt;
    private final double[][] j11;
    private final double[][] j22;
    private final double[][] j33;
    private final double[][] j12;
    private final double[][] j13;
    private final double[][] j23;
    private final ReflectionList reflectionList;
    private final Crystal crystal;
    private final DiffractionRefinementData refinementData;
    private final double[][] fc;
    private final double[][] fcTot;
    private final double[][] fSigF;
    private final int n;
    private final int solventN;
    private final ParallelTeam parallelTeam;
    private final ScaleBulkEnergyRegion scaleBulkEnergyRegion;
    private double[] optimizationScaling = null;
    private double totalEnergy;
    private double R;
    private double Rfree;

    ScaleBulkEnergy(ReflectionList reflectionList, DiffractionRefinementData refinementData, int n, ParallelTeam parallelTeam) {
        this.reflectionList = reflectionList;
        this.crystal = reflectionList.crystal;
        this.refinementData = refinementData;
        this.fc = refinementData.fc;
        this.fcTot = refinementData.fcTot;
        this.fSigF = refinementData.fSigF;
        this.n = n;
        this.solventN = n - refinementData.nScale;
        this.recipt = MatrixMath.mat3Transpose((double[][])this.crystal.A);
        this.j11 = MatrixMath.mat3Mat3Multiply((double[][])MatrixMath.mat3Mat3Multiply((double[][])this.crystal.A, (double[][])u11), (double[][])this.recipt);
        this.j22 = MatrixMath.mat3Mat3Multiply((double[][])MatrixMath.mat3Mat3Multiply((double[][])this.crystal.A, (double[][])u22), (double[][])this.recipt);
        this.j33 = MatrixMath.mat3Mat3Multiply((double[][])MatrixMath.mat3Mat3Multiply((double[][])this.crystal.A, (double[][])u33), (double[][])this.recipt);
        this.j12 = MatrixMath.mat3Mat3Multiply((double[][])MatrixMath.mat3Mat3Multiply((double[][])this.crystal.A, (double[][])u12), (double[][])this.recipt);
        this.j13 = MatrixMath.mat3Mat3Multiply((double[][])MatrixMath.mat3Mat3Multiply((double[][])this.crystal.A, (double[][])u13), (double[][])this.recipt);
        this.j23 = MatrixMath.mat3Mat3Multiply((double[][])MatrixMath.mat3Mat3Multiply((double[][])this.crystal.A, (double[][])u23), (double[][])this.recipt);
        int threadCount = parallelTeam.getThreadCount();
        this.parallelTeam = parallelTeam;
        this.scaleBulkEnergyRegion = new ScaleBulkEnergyRegion(this, threadCount);
    }

    public boolean destroy() {
        return true;
    }

    public double energy(double[] x) {
        this.unscaleCoordinates(x);
        double sum = this.target(x, null, false, false);
        this.scaleCoordinates(x);
        return sum;
    }

    public double energyAndGradient(double[] x, double[] g) {
        this.unscaleCoordinates(x);
        double sum = this.target(x, g, true, false);
        this.scaleCoordinatesAndGradient(x, g);
        return sum;
    }

    public double getR() {
        return this.R;
    }

    public double getRfree() {
        return this.Rfree;
    }

    public double[] getCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCoordinates(double[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getNumberOfVariables() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] getScaling() {
        return this.optimizationScaling;
    }

    public void setScaling(@Nullable double[] scaling) {
        this.optimizationScaling = (double[])(scaling != null && scaling.length == this.n ? scaling : null);
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double target(double[] x, double[] g, boolean gradient, boolean print) {
        try {
            this.scaleBulkEnergyRegion.init(x, g, gradient);
            this.parallelTeam.execute((ParallelRegion)this.scaleBulkEnergyRegion);
        }
        catch (Exception e) {
            logger.severe(e.toString());
        }
        double sum = this.scaleBulkEnergyRegion.sum.get();
        double sumfo = this.scaleBulkEnergyRegion.sumFo.get();
        double r = this.scaleBulkEnergyRegion.r.get();
        double rf = this.scaleBulkEnergyRegion.rf.get();
        double rfree = this.scaleBulkEnergyRegion.rFree.get();
        double rfreef = this.scaleBulkEnergyRegion.rFreeF.get();
        this.R = r / rf * 100.0;
        this.Rfree = rfree / rfreef * 100.0;
        this.totalEnergy = sum / sumfo;
        if (gradient) {
            double isumfo = 1.0 / sumfo;
            int i = 0;
            while (i < g.length) {
                int n = i++;
                g[n] = g[n] * isumfo;
            }
        }
        if (print) {
            StringBuilder sb = new StringBuilder("\n");
            sb.append(" Bulk solvent and scale fit\n");
            sb.append(String.format("  Residual:  %10.5f  R:  %8.3f  Rfree:  %8.3f\n", this.totalEnergy, this.R, this.Rfree));
            sb.append("  Params:   ");
            for (double x1 : x) {
                sb.append(String.format("%16.8f ", x1));
            }
            if (gradient) {
                sb.append("\n  Gradient: ");
                for (double v : g) {
                    sb.append(String.format("%16.8f ", v));
                }
            }
            sb.append("\n");
            logger.info(sb.toString());
        }
        return this.totalEnergy;
    }

    private class ScaleBulkEnergyRegion
    extends ParallelRegion {
        private final double[] modelB;
        private final double[][] uStar;
        private final double[][] resM;
        boolean gradient;
        double[] x;
        double[] g;
        double solventK;
        double modelK;
        double solventUEq;
        SharedDouble r;
        SharedDouble rf;
        SharedDouble rFree;
        SharedDouble rFreeF;
        SharedDouble sum;
        SharedDouble sumFo;
        SharedDoubleArray grad;
        ScaleBulkEnergyLoop[] scaleBulkEnergyLoop;
        final /* synthetic */ ScaleBulkEnergy this$0;

        ScaleBulkEnergyRegion(ScaleBulkEnergy scaleBulkEnergy, int nThreads) {
            ScaleBulkEnergy scaleBulkEnergy2 = scaleBulkEnergy;
            Objects.requireNonNull(scaleBulkEnergy2);
            this.this$0 = scaleBulkEnergy2;
            this.modelB = new double[6];
            this.uStar = new double[3][3];
            this.resM = new double[3][3];
            this.gradient = true;
            this.scaleBulkEnergyLoop = new ScaleBulkEnergyLoop[nThreads];
            this.r = new SharedDouble();
            this.rf = new SharedDouble();
            this.rFree = new SharedDouble();
            this.rFreeF = new SharedDouble();
            this.sum = new SharedDouble();
            this.sumFo = new SharedDouble();
        }

        public void finish() {
            if (this.gradient) {
                for (int i = 0; i < this.g.length; ++i) {
                    this.g[i] = this.grad.get(i);
                }
            }
        }

        public void init(double[] x, double[] g, boolean gradient) {
            this.x = x;
            this.g = g;
            this.gradient = gradient;
        }

        public void run() {
            int ti = this.getThreadIndex();
            if (this.scaleBulkEnergyLoop[ti] == null) {
                this.scaleBulkEnergyLoop[ti] = new ScaleBulkEnergyLoop(this);
            }
            try {
                this.execute(0, this.this$0.reflectionList.hklList.size() - 1, this.scaleBulkEnergyLoop[ti]);
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }

        public void start() {
            int i;
            this.r.set(0.0);
            this.rf.set(0.0);
            this.rFree.set(0.0);
            this.rFreeF.set(0.0);
            this.sum.set(0.0);
            this.sumFo.set(0.0);
            for (i = 0; i < 6; ++i) {
                if (this.this$0.crystal.scaleB[i] < 0) continue;
                this.modelB[i] = this.x[this.this$0.solventN + this.this$0.crystal.scaleB[i]];
            }
            this.modelK = this.x[0];
            this.solventK = this.this$0.refinementData.bulkSolventK;
            this.solventUEq = this.this$0.refinementData.bulkSolventUeq;
            if (this.this$0.solventN > 1) {
                this.solventK = this.x[1];
                this.solventUEq = this.x[2];
            }
            MatrixMath.mat3SymVec6((double[][])this.this$0.crystal.A, (double[])this.modelB, (double[][])this.resM);
            MatrixMath.mat3Mat3Multiply((double[][])this.resM, (double[][])this.this$0.recipt, (double[][])this.uStar);
            if (this.gradient) {
                if (this.grad == null) {
                    this.grad = new SharedDoubleArray(this.g.length);
                }
                for (i = 0; i < this.g.length; ++i) {
                    this.grad.set(i, 0.0);
                }
            }
        }

        private class ScaleBulkEnergyLoop
        extends IntegerForLoop {
            private final double[] resv;
            private final double[] ihc;
            private final ComplexNumber resc;
            private final ComplexNumber fcc;
            private final ComplexNumber fsc;
            private final ComplexNumber fct;
            private final ComplexNumber kfct;
            private final double[] lgrad;
            private double lr;
            private double lrf;
            private double lrfree;
            private double lrfreef;
            private double lsum;
            private double lsumfo;
            final /* synthetic */ ScaleBulkEnergyRegion this$1;

            ScaleBulkEnergyLoop(ScaleBulkEnergyRegion scaleBulkEnergyRegion) {
                ScaleBulkEnergyRegion scaleBulkEnergyRegion2 = scaleBulkEnergyRegion;
                Objects.requireNonNull(scaleBulkEnergyRegion2);
                this.this$1 = scaleBulkEnergyRegion2;
                this.resv = new double[3];
                this.ihc = new double[3];
                this.resc = new ComplexNumber();
                this.fcc = new ComplexNumber();
                this.fsc = new ComplexNumber();
                this.fct = new ComplexNumber();
                this.kfct = new ComplexNumber();
                this.lgrad = new double[scaleBulkEnergyRegion.this$0.n];
            }

            public void finish() {
                this.this$1.r.addAndGet(this.lr);
                this.this$1.rf.addAndGet(this.lrf);
                this.this$1.rFree.addAndGet(this.lrfree);
                this.this$1.rFreeF.addAndGet(this.lrfreef);
                this.this$1.sum.addAndGet(this.lsum);
                this.this$1.sumFo.addAndGet(this.lsumfo);
                if (this.this$1.gradient) {
                    for (int i = 0; i < this.lgrad.length; ++i) {
                        this.this$1.grad.getAndAdd(i, this.lgrad[i]);
                    }
                }
            }

            public void run(int lb, int ub) {
                for (int j = lb; j <= ub; ++j) {
                    HKL ih = (HKL)this.this$1.this$0.reflectionList.hklList.get(j);
                    int i = ih.getIndex();
                    if (Double.isNaN(this.this$1.this$0.fc[i][0]) || Double.isNaN(this.this$1.this$0.fSigF[i][0]) || this.this$1.this$0.fSigF[i][1] <= 0.0) continue;
                    double s = this.this$1.this$0.crystal.invressq(ih);
                    this.ihc[0] = ih.getH();
                    this.ihc[1] = ih.getK();
                    this.ihc[2] = ih.getL();
                    MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.uStar, (double[])this.resv);
                    double u = this.this$1.modelK - DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                    double expBS = FastMath.exp((double)(-19.739208802178716 * this.this$1.solventUEq * s));
                    double ksExpBS = this.this$1.solventK * expBS;
                    double expU = FastMath.exp((double)(0.25 * u));
                    this.this$1.this$0.refinementData.getFcIP(i, this.fcc);
                    this.this$1.this$0.refinementData.getFsIP(i, this.fsc);
                    this.fct.copy(this.fcc);
                    if (this.this$1.this$0.refinementData.crystalReciprocalSpaceFs.getSolventModel() != SolventModel.NONE) {
                        this.resc.copy(this.fsc);
                        this.resc.timesIP(ksExpBS);
                        this.fct.plusIP(this.resc);
                    }
                    this.kfct.copy(this.fct);
                    this.kfct.timesIP(expU);
                    this.this$1.this$0.fcTot[i][0] = this.kfct.re();
                    this.this$1.this$0.fcTot[i][1] = this.kfct.im();
                    double f1 = this.this$1.this$0.refinementData.getF(i);
                    double akfct = this.kfct.abs();
                    double af1 = FastMath.abs((double)f1);
                    double d = f1 - akfct;
                    double d2 = d * d;
                    double dr = -2.0 * d;
                    this.lsum += d2;
                    this.lsumfo += f1 * f1;
                    if (this.this$1.this$0.refinementData.isFreeR(i)) {
                        this.lrfree += FastMath.abs((double)(af1 - FastMath.abs((double)akfct)));
                        this.lrfreef += af1;
                    } else {
                        this.lr += FastMath.abs((double)(af1 - FastMath.abs((double)akfct)));
                        this.lrf += af1;
                    }
                    if (!this.this$1.gradient) continue;
                    double dfm = 0.25 * akfct * dr;
                    double afsc = this.fsc.abs();
                    double dfb = expBS * (this.fcc.re() * this.fsc.re() + this.fcc.im() * this.fsc.im() + ksExpBS * afsc * afsc);
                    this.lgrad[0] = this.lgrad[0] + dfm;
                    if (this.this$1.this$0.solventN > 1) {
                        double iafct = 1.0 / this.fct.abs();
                        this.lgrad[1] = this.lgrad[1] + expU * dfb * dr * iafct;
                        this.lgrad[2] = this.lgrad[2] + expU * -19.739208802178716 * s * this.this$1.solventK * dfb * dr * iafct;
                    }
                    block9: for (int jj = 0; jj < 6; ++jj) {
                        if (this.this$1.this$0.crystal.scaleB[jj] < 0) continue;
                        switch (jj) {
                            case 0: {
                                MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.this$0.j11, (double[])this.resv);
                                int n = this.this$1.this$0.solventN + this.this$1.this$0.crystal.scaleB[jj];
                                this.lgrad[n] = this.lgrad[n] + -dfm * DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                                continue block9;
                            }
                            case 1: {
                                MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.this$0.j22, (double[])this.resv);
                                int n = this.this$1.this$0.solventN + this.this$1.this$0.crystal.scaleB[jj];
                                this.lgrad[n] = this.lgrad[n] + -dfm * DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                                continue block9;
                            }
                            case 2: {
                                MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.this$0.j33, (double[])this.resv);
                                int n = this.this$1.this$0.solventN + this.this$1.this$0.crystal.scaleB[jj];
                                this.lgrad[n] = this.lgrad[n] + -dfm * DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                                continue block9;
                            }
                            case 3: {
                                MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.this$0.j12, (double[])this.resv);
                                int n = this.this$1.this$0.solventN + this.this$1.this$0.crystal.scaleB[jj];
                                this.lgrad[n] = this.lgrad[n] + -dfm * DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                                continue block9;
                            }
                            case 4: {
                                MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.this$0.j13, (double[])this.resv);
                                int n = this.this$1.this$0.solventN + this.this$1.this$0.crystal.scaleB[jj];
                                this.lgrad[n] = this.lgrad[n] + -dfm * DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                                continue block9;
                            }
                            case 5: {
                                MatrixMath.vec3Mat3((double[])this.ihc, (double[][])this.this$1.this$0.j23, (double[])this.resv);
                                int n = this.this$1.this$0.solventN + this.this$1.this$0.crystal.scaleB[jj];
                                this.lgrad[n] = this.lgrad[n] + -dfm * DoubleMath.dot((double[])this.resv, (double[])this.ihc);
                            }
                        }
                    }
                }
            }

            public void start() {
                this.lr = 0.0;
                this.lrf = 0.0;
                this.lrfree = 0.0;
                this.lrfreef = 0.0;
                this.lsum = 0.0;
                this.lsumfo = 0.0;
                Arrays.fill(this.lgrad, 0.0);
            }
        }
    }
}

