/*
 * Decompiled with CFR 0.152.
 */
package ffx.xray;

import ffx.crystal.Crystal;
import ffx.crystal.HKL;
import ffx.crystal.ReflectionList;
import ffx.crystal.ReflectionSpline;
import ffx.numerics.math.ComplexNumber;
import ffx.numerics.math.ScalarMath;
import ffx.xray.CrystalReciprocalSpace;
import ffx.xray.DiffractionRefinementData;
import ffx.xray.solvent.SolventModel;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;

public class CrystalStats {
    private static final Logger logger = Logger.getLogger(CrystalStats.class.getName());
    private final ReflectionList reflectionList;
    private final DiffractionRefinementData refinementData;
    private final Crystal crystal;
    private final int nBins;
    private final double[][] fSigF;
    private final int[] freeR;
    private final double[][] fcTot;
    private final double[][] fomPhi;
    private final ReflectionSpline spline;
    private double blowDPI = -1.0;
    private boolean print = true;
    private int nObsHKL;
    private int highnObsHKL;
    private int nObsRFree;
    private int highnObsRFree;
    private double resHigh;
    private double resLow;
    private double highResHigh;
    private double highResLow;
    private double completeness;
    private double highCompleteness;
    private double rall;
    private double r;
    private double rfree;
    private double highR;
    private double highRfree;
    private double blowDPIH;
    private double cruickDPI;
    private double cruickDPIH;

    CrystalStats(ReflectionList reflectionList, DiffractionRefinementData refinementData) {
        this.reflectionList = reflectionList;
        this.refinementData = refinementData;
        this.crystal = reflectionList.crystal;
        this.nBins = refinementData.nBins;
        this.fSigF = refinementData.fSigF;
        this.freeR = refinementData.freeR;
        this.fcTot = refinementData.fcTot;
        this.fomPhi = refinementData.fomPhi;
        this.spline = new ReflectionSpline(reflectionList, refinementData.spline.length);
    }

    public double getR() {
        double sum = 0.0;
        double sumfo = 0.0;
        double sumall = 0.0;
        double sumfoall = 0.0;
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            if (Double.isNaN(this.fcTot[i][0]) || Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double ss = this.crystal.invressq(ih);
            double fh = this.spline.f(ss, this.refinementData.spline);
            ComplexNumber c = new ComplexNumber(this.fcTot[i][0], this.fcTot[i][1]);
            double numer = FastMath.abs((double)(FastMath.abs((double)this.fSigF[i][0]) - fh * FastMath.abs((double)c.abs())));
            double denom = FastMath.abs((double)this.fSigF[i][0]);
            sumall += numer;
            sumfoall += denom;
            if (this.refinementData.isFreeR(i)) continue;
            sum += numer;
            sumfo += denom;
        }
        this.rall = sumall / sumfoall * 100.0;
        this.r = sum / sumfo * 100.0;
        return this.r;
    }

    public double getSigmaA() {
        double sum = 0.0;
        int nhkl = 0;
        ReflectionSpline sigmaaspline = new ReflectionSpline(this.reflectionList, this.refinementData.sigmaA.length);
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            if (Double.isNaN(this.fcTot[i][0]) || Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double ss = this.crystal.invressq(ih);
            this.spline.f(ss, this.refinementData.spline);
            double sa = sigmaaspline.f(ss, this.refinementData.sigmaA);
            sum += (sa - sum) / (double)(++nhkl);
        }
        return sum;
    }

    String getPDBHeaderString() {
        this.print = false;
        this.printHKLStats();
        this.printRStats();
        this.print = true;
        StringBuilder sb = new StringBuilder();
        sb.append("REMARK   3  DATA USED IN REFINEMENT\n");
        sb.append(String.format("REMARK   3   RESOLUTION RANGE HIGH (ANGSTROMS) : %6.2f\n", this.resHigh));
        sb.append(String.format("REMARK   3   RESOLUTION RANGE LOW  (ANGSTROMS) : %6.2f\n", this.resLow));
        if (this.refinementData.fSigFCutoff > 0.0) {
            sb.append(String.format("REMARK   3   DATA CUTOFF            (SIGMA(F)) : %6.2f\n", this.refinementData.fSigFCutoff));
        } else {
            sb.append("REMARK   3   DATA CUTOFF            (SIGMA(F)) : NONE\n");
        }
        sb.append(String.format("REMARK   3   COMPLETENESS FOR RANGE        (%%) : %6.2f\n", this.completeness));
        sb.append("REMARK   3   NUMBER OF REFLECTIONS             : ").append(this.nObsHKL).append("\n");
        sb.append("REMARK   3\n");
        sb.append("REMARK   3  FIT TO DATA USED IN REFINEMENT\n");
        sb.append("REMARK   3   CROSS-VALIDATION METHOD          : THROUGHOUT\n");
        sb.append("REMARK   3   FREE R VALUE TEST SET SELECTION  : RANDOM\n");
        sb.append(String.format("REMARK   3   R VALUE               (OBSERVED) : %8.6f\n", this.rall / 100.0));
        sb.append(String.format("REMARK   3   R VALUE            (WORKING SET) : %8.6f\n", this.r / 100.0));
        sb.append(String.format("REMARK   3   FREE R VALUE                     : %8.6f\n", this.rfree / 100.0));
        sb.append(String.format("REMARK   3   FREE R VALUE TEST SET SIZE   (%%) : %6.1f\n", (double)this.nObsRFree / (double)this.nObsHKL * 100.0));
        sb.append("REMARK   3   FREE R VALUE TEST SET COUNT      : ").append(this.nObsRFree).append("\n");
        sb.append("REMARK   3\n");
        sb.append("REMARK   3  FIT IN THE HIGHEST RESOLUTION BIN\n");
        sb.append("REMARK   3   TOTAL NUMBER OF BINS USED           : ").append(this.nBins).append("\n");
        sb.append(String.format("REMARK   3   BIN RESOLUTION RANGE HIGH           : %6.2f\n", this.highResHigh));
        sb.append(String.format("REMARK   3   BIN RESOLUTION RANGE LOW            : %6.2f\n", this.highResLow));
        sb.append("REMARK   3   REFLECTION IN BIN     (WORKING SET) : ").append(this.highnObsHKL).append("\n");
        sb.append(String.format("REMARK   3   BIN COMPLETENESS (WORKING+TEST) (%%) : %6.2f\n", this.highCompleteness));
        sb.append(String.format("REMARK   3   BIN R VALUE           (WORKING SET) : %8.6f\n", this.highR / 100.0));
        sb.append("REMARK   3   BIN FREE R VALUE SET COUNT          : ").append(this.highnObsRFree).append("\n");
        sb.append(String.format("REMARK   3   BIN FREE R VALUE                    : %8.6f\n", this.highRfree / 100.0));
        sb.append("REMARK   3\n");
        sb.append("REMARK   3  OVERALL SCALE FACTORS\n");
        sb.append(String.format("REMARK   3   SCALE: %4.2f\n", FastMath.exp((double)(0.25 * this.refinementData.modelScaleK))));
        sb.append("REMARK   3   ANISOTROPIC SCALE TENSOR:\n");
        sb.append(String.format("REMARK   3    %g %g %g\n", this.refinementData.modelAnisoB[0], this.refinementData.modelAnisoB[3], this.refinementData.modelAnisoB[4]));
        sb.append(String.format("REMARK   3    %g %g %g\n", this.refinementData.modelAnisoB[3], this.refinementData.modelAnisoB[1], this.refinementData.modelAnisoB[5]));
        sb.append(String.format("REMARK   3    %g %g %g\n", this.refinementData.modelAnisoB[4], this.refinementData.modelAnisoB[5], this.refinementData.modelAnisoB[2]));
        sb.append("REMARK   3\n");
        CrystalReciprocalSpace crystalReciprocalSpaceFs = this.refinementData.crystalReciprocalSpaceFs;
        SolventModel solventModel = crystalReciprocalSpaceFs.getSolventModel();
        if (solventModel != SolventModel.NONE) {
            sb.append("REMARK   3  BULK SOLVENT MODELLING\n");
            double solventA = crystalReciprocalSpaceFs.getSolventA();
            double solventB = crystalReciprocalSpaceFs.getSolventB();
            switch (solventModel) {
                case BINARY: {
                    sb.append("REMARK   3   METHOD USED: BINARY MASK\n");
                    sb.append(String.format("REMARK   3    PROBE RADIUS  : %g\n", solventA));
                    sb.append(String.format("REMARK   3    SHRINK RADIUS : %g\n", solventB));
                    break;
                }
                case POLYNOMIAL: {
                    sb.append("REMARK   3   METHOD USED: POLYNOMIAL SWITCH\n");
                    sb.append(String.format("REMARK   3    ATOMIC RADIUS BUFFER : %g\n", solventA));
                    sb.append(String.format("REMARK   3    SWITCH RADIUS        : %g\n", solventB));
                    break;
                }
                case GAUSSIAN: {
                    sb.append("REMARK   3   METHOD USED: GAUSSIAN\n");
                    sb.append(String.format("REMARK   3    ATOMIC RADIUS BUFFER : %g\n", solventA));
                    sb.append(String.format("REMARK   3    STD DEV SCALE        : %g\n", solventB));
                }
            }
            sb.append(String.format("REMARK   3    K_SOL: %g\n", this.refinementData.bulkSolventK));
            sb.append(String.format("REMARK   3    B_SOL: %g\n", this.refinementData.bulkSolventUeq * 8.0 * Math.PI * Math.PI));
            sb.append("REMARK   3\n");
        }
        if (this.blowDPI > 0.0) {
            sb.append("REMARK   3  ERROR ESTIMATES\n");
            sb.append("REMARK   3   ACTA CRYST (1999) D55, 583-601\n");
            sb.append("REMARK   3   ACTA CRYST (2002) D58, 792-797\n");
            sb.append(String.format("REMARK   3   BLOW DPI ALL ATOMS (EQN 7)          : %7.4f\n", this.blowDPIH));
            sb.append(String.format("REMARK   3   BLOW DPI NONH ATOMS (EQN 7)         : %7.4f\n", this.blowDPI));
            sb.append(String.format("REMARK   3   CRUICKSHANK DPI ALL ATOMS (EQN 27)  : %7.4f\n", this.cruickDPIH));
            sb.append(String.format("REMARK   3   CRUICKSHANK DPI NONH ATOMS (EQN 27) : %7.4f\n", this.cruickDPI));
            sb.append("REMARK   3\n");
        }
        sb.append("REMARK   3  DATA TARGET\n");
        sb.append("REMARK   3   METHOD USED: MAXIMUM LIKELIHOOD\n");
        sb.append(String.format("REMARK   3    -LOG LIKELIHOOD            : %g\n", this.refinementData.llkR));
        sb.append(String.format("REMARK   3    -LOG LIKELIHOOD (FREE SET) : %g\n", this.refinementData.llkF));
        sb.append("REMARK   3\n");
        return sb.toString();
    }

    double getRFree() {
        double sum = 0.0;
        double sumfo = 0.0;
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            if (Double.isNaN(this.fcTot[i][0]) || Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double ss = this.crystal.invressq(ih);
            double fh = this.spline.f(ss, this.refinementData.spline);
            ComplexNumber c = new ComplexNumber(this.fcTot[i][0], this.fcTot[i][1]);
            if (!this.refinementData.isFreeR(i)) continue;
            sum += FastMath.abs((double)(FastMath.abs((double)this.fSigF[i][0]) - fh * FastMath.abs((double)c.abs())));
            sumfo += FastMath.abs((double)this.fSigF[i][0]);
        }
        this.rfree = sum / sumfo * 100.0;
        return this.rfree;
    }

    double getSigmaW() {
        double sum = 0.0;
        int nhkl = 0;
        ReflectionSpline sigmaaspline = new ReflectionSpline(this.reflectionList, this.refinementData.sigmaA.length);
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            if (Double.isNaN(this.fcTot[i][0]) || Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double ss = this.crystal.invressq(ih);
            this.spline.f(ss, this.refinementData.spline);
            double wa = sigmaaspline.f(ss, this.refinementData.sigmaW);
            sum += (wa - sum) / (double)(++nhkl);
        }
        return sum;
    }

    void printDPIStats(int nAtoms, int nNonHydrogenAtoms) {
        int nhkli = 0;
        int nhklo = this.refinementData.n;
        double rfreefrac = this.getRFree() * 0.01;
        double res = this.reflectionList.resolution.resolutionLimit();
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            if (Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            ++nhkli;
        }
        double va = FastMath.pow((double)(this.crystal.volume / (double)this.crystal.spaceGroup.getNumberOfSymOps()), (double)0.3333);
        this.blowDPIH = 1.28 * FastMath.sqrt((double)nAtoms) * va * FastMath.pow((double)nhkli, (double)-0.8333) * rfreefrac;
        this.blowDPI = 1.28 * FastMath.sqrt((double)nNonHydrogenAtoms) * va * FastMath.pow((double)nhkli, (double)-0.8333) * rfreefrac;
        double natni = FastMath.sqrt((double)((double)nAtoms / (double)nhkli));
        double noni = FastMath.pow((double)((double)nhkli / (double)nhklo), (double)-0.3333);
        this.cruickDPIH = natni * noni * rfreefrac * res;
        natni = FastMath.sqrt((double)((double)nNonHydrogenAtoms / (double)nhkli));
        this.cruickDPI = natni * noni * rfreefrac * res;
        StringBuilder sb = new StringBuilder("\n");
        sb.append(String.format(" Blow DPI for all / non-H atoms:        %7.4f / %7.4f\n", this.blowDPIH, this.blowDPI));
        sb.append(String.format(" Cruickshank DPI for all / non-H atoms: %7.4f / %7.4f", this.cruickDPIH, this.cruickDPI));
        if (this.print) {
            logger.info(sb.toString());
        }
    }

    void printHKLStats() {
        double[][] res = new double[this.nBins][2];
        int[][] nhkl = new int[this.nBins][3];
        for (int i = 0; i < this.nBins; ++i) {
            res[i][0] = Double.NEGATIVE_INFINITY;
            res[i][1] = Double.POSITIVE_INFINITY;
        }
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            int b = ih.getBin();
            if (Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) {
                int[] nArray = nhkl[b];
                nArray[2] = nArray[2] + 1;
                continue;
            }
            double rh = this.crystal.res(ih);
            if (rh > res[b][0]) {
                res[b][0] = rh;
            }
            if (rh < res[b][1]) {
                res[b][1] = rh;
            }
            if (this.freeR[i] == this.refinementData.rFreeFlag) {
                int[] nArray = nhkl[b];
                nArray[1] = nArray[1] + 1;
                continue;
            }
            int[] nArray = nhkl[b];
            nArray[0] = nArray[0] + 1;
        }
        StringBuilder sb = new StringBuilder(String.format("\n %15s | %8s|%9s| %7s | %7s | %s\n", "Res. Range", " HKL (R)", " HKL (cv)", " Bin", " Miss", "Complete (%)"));
        for (int i = 0; i < this.nBins; ++i) {
            sb.append(String.format(" %7.3f %7.3f | ", res[i][0], res[i][1]));
            sb.append(String.format("%7d | %7d | %7d | %7d | ", nhkl[i][0], nhkl[i][1], nhkl[i][0] + nhkl[i][1], nhkl[i][2]));
            sb.append(String.format("%6.2f\n", ((double)nhkl[i][0] + (double)nhkl[i][1]) / (double)(nhkl[i][0] + nhkl[i][1] + nhkl[i][2]) * 100.0));
        }
        sb.append(String.format(" %7.3f %7.3f | ", res[0][0], res[this.nBins - 1][1]));
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = 0;
        for (int i = 0; i < this.nBins; ++i) {
            sum1 += nhkl[i][0];
            sum2 += nhkl[i][1];
            sum3 += nhkl[i][2];
        }
        sb.append(String.format("%7d | %7d | %7d | %7d | ", sum1, sum2, sum1 + sum2, sum3));
        sb.append(String.format("%6.2f\n", ((double)sum1 + (double)sum2) / (double)(sum1 + sum2 + sum3) * 100.0));
        sb.append(String.format(" Number of reflections if complete: %10d", this.refinementData.n));
        this.nObsHKL = sum1 + sum2;
        this.highnObsHKL = nhkl[this.nBins - 1][0] + nhkl[this.nBins - 1][1];
        this.nObsRFree = sum2;
        this.highnObsRFree = nhkl[this.nBins - 1][1];
        this.completeness = ((double)sum1 + (double)sum2) / (double)(sum1 + sum2 + sum3) * 100.0;
        this.highCompleteness = ((double)nhkl[this.nBins - 1][0] + (double)nhkl[this.nBins - 1][1]) / (double)(nhkl[this.nBins - 1][0] + nhkl[this.nBins - 1][1] + nhkl[this.nBins - 1][2]) * 100.0;
        if (this.print) {
            logger.info(sb.toString());
        }
    }

    void printRStats() {
        double[][] res = new double[this.nBins][2];
        double[] nhkl = new double[this.nBins + 1];
        double[][] rb = new double[this.nBins + 1][2];
        double[][] sumfo = new double[this.nBins + 1][2];
        double[][] s = new double[this.nBins + 1][4];
        double sumall = 0.0;
        double sumfoall = 0.0;
        ReflectionSpline sigmaASpline = new ReflectionSpline(this.reflectionList, this.refinementData.sigmaA.length);
        for (int i = 0; i < this.nBins; ++i) {
            res[i][0] = Double.NEGATIVE_INFINITY;
            res[i][1] = Double.POSITIVE_INFINITY;
        }
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            int b = ih.getBin();
            if (Double.isNaN(this.fcTot[i][0]) || Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double ss = this.crystal.invressq(ih);
            double fh = this.spline.f(ss, this.refinementData.spline);
            double sa = sigmaASpline.f(ss, this.refinementData.sigmaA);
            double wa = sigmaASpline.f(ss, this.refinementData.sigmaW);
            double eoscale = sigmaASpline.f(ss, this.refinementData.esqFo);
            double rs = this.crystal.res(ih);
            if (rs > res[b][0]) {
                res[b][0] = rs;
            }
            if (rs < res[b][1]) {
                res[b][1] = rs;
            }
            ComplexNumber c = new ComplexNumber(this.fcTot[i][0], this.fcTot[i][1]);
            double numer = FastMath.abs((double)(FastMath.abs((double)this.fSigF[i][0]) - fh * FastMath.abs((double)c.abs())));
            double denom = FastMath.abs((double)this.fSigF[i][0]);
            if (this.refinementData.isFreeR(i)) {
                double[] dArray = rb[b];
                dArray[1] = dArray[1] + numer;
                double[] dArray2 = sumfo[b];
                dArray2[1] = dArray2[1] + denom;
                double[] dArray3 = rb[this.nBins];
                dArray3[1] = dArray3[1] + numer;
                double[] dArray4 = sumfo[this.nBins];
                dArray4[1] = dArray4[1] + denom;
                sumall += numer;
                sumfoall += denom;
            } else {
                double[] dArray = rb[b];
                dArray[0] = dArray[0] + numer;
                double[] dArray5 = sumfo[b];
                dArray5[0] = dArray5[0] + denom;
                double[] dArray6 = rb[this.nBins];
                dArray6[0] = dArray6[0] + numer;
                double[] dArray7 = sumfo[this.nBins];
                dArray7[0] = dArray7[0] + denom;
                sumall += numer;
                sumfoall += denom;
            }
            int n = b;
            nhkl[n] = nhkl[n] + 1.0;
            int n2 = this.nBins;
            nhkl[n2] = nhkl[n2] + 1.0;
            double[] dArray = s[b];
            dArray[0] = dArray[0] + (sa - s[b][0]) / nhkl[b];
            double[] dArray8 = s[b];
            dArray8[1] = dArray8[1] + (wa - s[b][1]) / nhkl[b];
            double[] dArray9 = s[b];
            dArray9[2] = dArray9[2] + (wa / FastMath.sqrt((double)eoscale) - s[b][2]) / nhkl[b];
            double[] dArray10 = s[b];
            dArray10[3] = dArray10[3] + (this.fomPhi[i][0] - s[b][3]) / nhkl[b];
            double[] dArray11 = s[this.nBins];
            dArray11[0] = dArray11[0] + (sa - s[this.nBins][0]) / nhkl[this.nBins];
            double[] dArray12 = s[this.nBins];
            dArray12[1] = dArray12[1] + (wa - s[this.nBins][1]) / nhkl[this.nBins];
            double[] dArray13 = s[this.nBins];
            dArray13[2] = dArray13[2] + (wa / Math.sqrt(eoscale) - s[this.nBins][2]) / nhkl[this.nBins];
            double[] dArray14 = s[this.nBins];
            dArray14[3] = dArray14[3] + (this.fomPhi[i][0] - s[this.nBins][3]) / nhkl[this.nBins];
        }
        StringBuilder sb = new StringBuilder(String.format("\n %15s | %7s | %7s | %7s | %7s | %7s | %7s\n", "Res. Range", "  R", "Rfree", "s", "w(E)", "w(F)", "FOM"));
        for (int i = 0; i < this.nBins; ++i) {
            sb.append(String.format(" %7.3f %7.3f | ", res[i][0], res[i][1]));
            sb.append(String.format("%7.2f | %7.2f | %7.4f | %7.4f | %7.2f | %7.4f\n", rb[i][0] / sumfo[i][0] * 100.0, rb[i][1] / sumfo[i][1] * 100.0, s[i][0], s[i][1], s[i][2], s[i][3]));
        }
        sb.append(String.format(" %7.3f %7.3f | ", res[0][0], res[this.nBins - 1][1]));
        sb.append(String.format("%7.2f | %7.2f | %7.4f | %7.4f | %7.2f | %7.4f\n", rb[this.nBins][0] / sumfo[this.nBins][0] * 100.0, rb[this.nBins][1] / sumfo[this.nBins][1] * 100.0, s[this.nBins][0], s[this.nBins][1], s[this.nBins][2], s[this.nBins][3]));
        this.resLow = res[0][0];
        this.resHigh = res[this.nBins - 1][1];
        this.highResLow = res[this.nBins - 1][0];
        this.highResHigh = res[this.nBins - 1][1];
        this.r = rb[this.nBins][0] / sumfo[this.nBins][0] * 100.0;
        this.rfree = rb[this.nBins][1] / sumfo[this.nBins][1] * 100.0;
        this.rall = sumall / sumfoall * 100.0;
        this.highR = rb[this.nBins - 1][0] / sumfo[this.nBins - 1][0] * 100.0;
        this.highRfree = rb[this.nBins - 1][1] / sumfo[this.nBins - 1][1] * 100.0;
        if (this.print) {
            logger.info(sb.toString());
        }
    }

    void printScaleStats() {
        int[] nhkl = new int[this.nBins];
        double[] scale = new double[this.nBins];
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            int b = ih.getBin();
            if (Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double ss = this.crystal.invressq(ih);
            double fh = this.spline.f(ss, this.refinementData.spline);
            int n = b;
            nhkl[n] = nhkl[n] + 1;
            int n2 = b;
            scale[n2] = scale[n2] + (fh - scale[b]) / (double)nhkl[b];
        }
        StringBuilder sb = new StringBuilder(String.format(" K_Overall (Fc to Fo Scale): %4.2f\n", FastMath.exp((double)(0.25 * this.refinementData.modelScaleK))));
        sb.append(" Fc to Fo Spline Scale: ");
        for (int i = 0; i < this.nBins; ++i) {
            sb.append(String.format("%4.2f ", scale[i]));
        }
        sb.append("\n B_Overall Anisotropic Tensor:\n");
        sb.append(String.format("  %10.4f %10.4f %10.4f\n", this.refinementData.modelAnisoB[0], this.refinementData.modelAnisoB[3], this.refinementData.modelAnisoB[4]));
        sb.append(String.format("  %10.4f %10.4f %10.4f\n", this.refinementData.modelAnisoB[3], this.refinementData.modelAnisoB[1], this.refinementData.modelAnisoB[5]));
        sb.append(String.format("  %10.4f %10.4f %10.4f\n", this.refinementData.modelAnisoB[4], this.refinementData.modelAnisoB[5], this.refinementData.modelAnisoB[2]));
        CrystalReciprocalSpace crystalReciprocalSpaceFs = this.refinementData.crystalReciprocalSpaceFs;
        SolventModel solventModel = crystalReciprocalSpaceFs.getSolventModel();
        if (solventModel != SolventModel.NONE) {
            double solventA = crystalReciprocalSpaceFs.getSolventA();
            double solventB = crystalReciprocalSpaceFs.getSolventB();
            switch (solventModel) {
                case BINARY: {
                    sb.append(" Bulk Solvent Model: Binary Mask\n");
                    sb.append(String.format("  Probe Radius:           %8.4f\n", solventA));
                    sb.append(String.format("  Shrink Radius:          %8.4f\n", solventB));
                    break;
                }
                case POLYNOMIAL: {
                    sb.append(" Bulk Solvent Model: Polynomial Switch\n");
                    sb.append(String.format("  Probe Radius:           %8.4f\n", solventA));
                    sb.append(String.format("  Window Width:           %8.4f\n", solventB));
                    break;
                }
                case GAUSSIAN: {
                    sb.append(" Bulk Solvent Model: Gaussian\n");
                    sb.append(String.format("  Exponential Scale A:    %8.4f\n", solventA));
                    sb.append(String.format("  Radius Scale Factor:    %8.4f\n", solventB));
                    break;
                }
                case NONE: {
                    sb.append(" Bulk Solvent Model: None\n");
                }
            }
            sb.append(String.format("  Scattering Density (k): %8.4f\n", this.refinementData.bulkSolventK));
            sb.append(String.format("  B-Factor:               %8.4f\n", ScalarMath.u2b((double)this.refinementData.bulkSolventUeq)));
        }
        sb.append(String.format("\n -log Likelihood: %14.3f (free set: %14.3f)", this.refinementData.llkR, this.refinementData.llkF));
        if (this.print) {
            logger.info(sb.toString());
        }
    }

    void printSNStats() {
        double[][] res = new double[this.nBins][2];
        double[] nhkl = new double[this.nBins + 1];
        double[][] sn = new double[this.nBins + 1][3];
        for (int i = 0; i < this.nBins; ++i) {
            res[i][0] = Double.NEGATIVE_INFINITY;
            res[i][1] = Double.POSITIVE_INFINITY;
        }
        for (HKL ih : this.reflectionList.hklList) {
            int i = ih.getIndex();
            int b = ih.getBin();
            if (Double.isNaN(this.fSigF[i][0]) || this.fSigF[i][1] <= 0.0) continue;
            double rs = this.crystal.res(ih);
            if (rs > res[b][0]) {
                res[b][0] = rs;
            }
            if (rs < res[b][1]) {
                res[b][1] = rs;
            }
            int n = b;
            nhkl[n] = nhkl[n] + 1.0;
            int n2 = this.nBins;
            nhkl[n2] = nhkl[n2] + 1.0;
            double[] dArray = sn[b];
            dArray[0] = dArray[0] + (this.fSigF[i][0] - sn[b][0]) / nhkl[b];
            double[] dArray2 = sn[b];
            dArray2[1] = dArray2[1] + (this.fSigF[i][1] - sn[b][1]) / nhkl[b];
            double[] dArray3 = sn[b];
            dArray3[2] = dArray3[2] + (this.fSigF[i][0] / this.fSigF[i][1] - sn[b][2]) / nhkl[b];
            double[] dArray4 = sn[this.nBins];
            dArray4[0] = dArray4[0] + (this.fSigF[i][0] - sn[this.nBins][0]) / nhkl[b];
            double[] dArray5 = sn[this.nBins];
            dArray5[1] = dArray5[1] + (this.fSigF[i][1] - sn[this.nBins][1]) / nhkl[b];
            double[] dArray6 = sn[this.nBins];
            dArray6[2] = dArray6[2] + (this.fSigF[i][0] / this.fSigF[i][1] - sn[this.nBins][2]) / nhkl[this.nBins];
        }
        StringBuilder sb = new StringBuilder(String.format("\n %15s | %7s | %7s | %7s \n", "Res. Range", "Signal", "Sigma", "S/N"));
        for (int i = 0; i < this.nBins; ++i) {
            sb.append(String.format(" %7.3f %7.3f | ", res[i][0], res[i][1]));
            sb.append(String.format("%7.2f | %7.2f | %7.2f\n", sn[i][0], sn[i][1], sn[i][2]));
        }
        sb.append(String.format(" %7.3f %7.3f | ", res[0][0], res[this.nBins - 1][1]));
        sb.append(String.format("%7.2f | %7.2f | %7.2f", sn[this.nBins][0], sn[this.nBins][1], sn[this.nBins][2]));
        if (this.print) {
            logger.info(sb.toString());
        }
    }
}

