/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.commands;

import ffx.algorithms.cli.AlgorithmsCommand;
import ffx.algorithms.cli.MinimizeOptions;
import ffx.potential.MolecularAssembly;
import ffx.potential.cli.AtomSelectionOptions;
import ffx.realspace.RealSpaceData;
import ffx.realspace.cli.RealSpaceOptions;
import ffx.realspace.parsers.RealSpaceFile;
import ffx.utilities.FFXBinding;
import ffx.utilities.TinkerUtils;
import ffx.xray.RefinementMinimize;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

@CommandLine.Command(description={" Minimization on a Real Space target."}, name="realspace.Minimize")
public class Minimize
extends AlgorithmsCommand {
    @CommandLine.Mixin
    private MinimizeOptions minimizeOptions;
    @CommandLine.Mixin
    private RealSpaceOptions realSpaceOptions;
    @CommandLine.Mixin
    private AtomSelectionOptions atomSelectionOptions;
    @CommandLine.Parameters(arity="1..*", paramLabel="files", description={"PDB and Real Space input files."})
    private List<String> filenames;
    private MolecularAssembly[] molecularAssemblies;
    private RealSpaceData realspaceData;

    public Minimize() {
    }

    public Minimize(String[] args) {
        super(args);
    }

    public Minimize(FFXBinding binding) {
        super(binding);
    }

    public Minimize run() {
        String filename;
        if (!this.init()) {
            return this;
        }
        if (this.filenames != null && !this.filenames.isEmpty()) {
            this.activeAssembly = this.algorithmFunctions.open(this.filenames.get(0));
            filename = this.filenames.get(0);
        } else {
            if (this.activeAssembly == null) {
                logger.info(this.helpString());
                return this;
            }
            filename = this.activeAssembly.getFile().getAbsolutePath();
        }
        this.molecularAssemblies = new MolecularAssembly[]{this.activeAssembly};
        logger.info("\n Running Real Space Minimization on " + filename);
        this.atomSelectionOptions.setActiveAtoms(this.activeAssembly);
        RealSpaceFile[] mapFiles = this.realSpaceOptions.processData(this.filenames, this.activeAssembly).toArray(new RealSpaceFile[0]);
        this.realspaceData = new RealSpaceData(this.molecularAssemblies, this.activeAssembly.getProperties(), this.activeAssembly.getParallelTeam(), mapFiles);
        this.algorithmFunctions.energy(this.activeAssembly);
        RefinementMinimize refinementMinimize = new RefinementMinimize(this.realspaceData);
        int nBFGS = this.minimizeOptions.getNBFGS();
        double eps = this.minimizeOptions.getEps();
        int maxiter = this.minimizeOptions.getIterations();
        if (eps < 0.0) {
            eps = 1.0;
        }
        if (maxiter < Integer.MAX_VALUE) {
            logger.info(String.format("\n RMS gradient convergence criteria: %8.5f, Maximum iterations %d", eps, maxiter));
        } else {
            logger.info(String.format("\n RMS gradient convergence criteria: %8.5f", eps));
        }
        refinementMinimize.minimize(nBFGS, eps, maxiter);
        this.algorithmFunctions.energy(this.activeAssembly);
        File file = TinkerUtils.version((File)new File(FilenameUtils.removeExtension((String)filename) + ".pdb"));
        this.algorithmFunctions.saveAsPDB(this.molecularAssemblies, file);
        return this;
    }

    public boolean destroyPotentials() {
        boolean destroyedSuccess = true;
        if (this.molecularAssemblies != null) {
            if (this.realspaceData != null) {
                destroyedSuccess = this.realspaceData.destroy();
            }
            for (int i = 1; i < this.molecularAssemblies.length; ++i) {
                destroyedSuccess = destroyedSuccess && this.molecularAssemblies[i].getPotentialEnergy().destroy();
            }
        }
        return destroyedSuccess;
    }
}

