/*
 * Decompiled with CFR 0.152.
 */
package ffx.realspace.cli;

import ffx.potential.MolecularAssembly;
import ffx.realspace.RealSpaceData;
import ffx.realspace.parsers.RealSpaceFile;
import ffx.xray.RefinementEnergy;
import ffx.xray.cli.DataRefinementOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import picocli.CommandLine;

public class RealSpaceOptions
extends DataRefinementOptions {
    private static final Logger logger = Logger.getLogger(RealSpaceOptions.class.getName());
    @CommandLine.Option(names={"-X", "--data"}, arity="2", description={"Specify input data filename and its weight (wA) (e.g. -X filename 1.0)."})
    String[] data = null;

    public List<RealSpaceFile> processData(List<String> filenames, MolecularAssembly molecularAssembly) {
        RealSpaceFile realspacefile;
        logger.info("\n");
        ArrayList<RealSpaceFile> mapfiles = new ArrayList<RealSpaceFile>();
        if (filenames.size() > 1) {
            realspacefile = new RealSpaceFile(filenames.get(1), this.wA);
            mapfiles.add(realspacefile);
        }
        if (this.data != null) {
            for (int i = 0; i < this.data.length; i += 2) {
                double w = this.wA;
                if (this.data.length > i + 1) {
                    try {
                        w = Double.parseDouble(this.data[i + 1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                RealSpaceFile realspacefile2 = new RealSpaceFile(this.data[i], w);
                mapfiles.add(realspacefile2);
            }
        }
        if (mapfiles.isEmpty()) {
            realspacefile = new RealSpaceFile(molecularAssembly, this.wA);
            mapfiles.add(realspacefile);
        }
        return mapfiles;
    }

    public RefinementEnergy toRealSpaceEnergy(List<String> filenames, MolecularAssembly[] molecularAssemblies) {
        RealSpaceFile[] mapFiles = this.processData(filenames, molecularAssemblies[0]).toArray(new RealSpaceFile[0]);
        RealSpaceData realspaceData = new RealSpaceData(molecularAssemblies, molecularAssemblies[0].getProperties(), molecularAssemblies[0].getParallelTeam(), mapFiles);
        return new RefinementEnergy(realspaceData);
    }
}

