/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.ASULimit;
import ffx.crystal.CrystalSystem;
import ffx.crystal.LatticeSystem;
import ffx.crystal.LaueSystem;
import ffx.crystal.SpaceGroup;
import ffx.crystal.SpaceGroupInfo;
import ffx.crystal.SymOp;

public class SpaceGroupDefinitions {
    private static final double f12 = 0.5;
    private static final double f13 = 0.3333333333333333;
    private static final double f23 = 0.6666666666666666;
    private static final double f14 = 0.25;
    private static final double f16 = 0.16666666666666666;
    private static final double f18 = 0.125;
    private static final double f112 = 0.08333333333333333;

    private SpaceGroupDefinitions() {
    }

    static SpaceGroup getSpaceGroup1(int num) {
        SpaceGroup spaceGroup = null;
        switch (num) {
            case 1: {
                spaceGroup = new SpaceGroup(1, 1, 1, "P1", "PG1", "P 1", CrystalSystem.TRICLINIC, LatticeSystem.TRICLINIC_LATTICE, LaueSystem.L111, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 2: {
                spaceGroup = new SpaceGroup(2, 2, 2, "P-1", "PG1bar", "P -1", CrystalSystem.TRICLINIC, LatticeSystem.TRICLINIC_LATTICE, LaueSystem.L111, new ASULimit[]{ASULimit.LT, ASULimit.LTE, ASULimit.LT}, new double[]{1.0, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 3: {
                spaceGroup = new SpaceGroup(3, 2, 2, "P2", "PG2", "P 1 2 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LT}, new double[]{0.5, 1.0, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 4: {
                spaceGroup = new SpaceGroup(4, 2, 2, "P21", "PG2", "P 1 21 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_0));
                break;
            }
            case 5: {
                spaceGroup = new SpaceGroup(5, 4, 2, "C2", "PG2", "C 1 2 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LT}, new double[]{0.5, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 6: {
                spaceGroup = new SpaceGroup(6, 2, 2, "Pm", "PGm", "P 1 m 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 7: {
                spaceGroup = new SpaceGroup(7, 2, 2, "Pc", "PGm", "P 1 c 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 8: {
                spaceGroup = new SpaceGroup(8, 4, 2, "Cm", "PGm", "C 1 m 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 9: {
                spaceGroup = new SpaceGroup(9, 4, 2, "Cc", "PGm", "C 1 c 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 10: {
                spaceGroup = new SpaceGroup(10, 4, 4, "P2/m", "PG2/m", "P 1 2/m 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 11: {
                spaceGroup = new SpaceGroup(11, 4, 4, "P21/m", "PG2/m", "P 1 21/m 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_0));
                break;
            }
            case 12: {
                spaceGroup = new SpaceGroup(12, 8, 4, "C2/m", "PG2/m", "C 1 2/m 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 13: {
                spaceGroup = new SpaceGroup(13, 4, 4, "P2/c", "PG2/m", "P 1 2/c 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 14: {
                spaceGroup = new SpaceGroup(14, 4, 4, "P21/c", "PG2/m", "P 1 21/c 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12));
                break;
            }
            case 15: {
                spaceGroup = new SpaceGroup(15, 8, 4, "C2/c", "PG2/m", "C 1 2/c 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 16: {
                spaceGroup = new SpaceGroup(16, 4, 4, "P222", "PG222", "P 2 2 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 17: {
                spaceGroup = new SpaceGroup(17, 4, 4, "P2221", "PG222", "P 2 2 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 18: {
                spaceGroup = new SpaceGroup(18, 4, 4, "P21212", "PG222", "P 21 21 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LTE, ASULimit.LT}, new double[]{1.0, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 19: {
                spaceGroup = new SpaceGroup(19, 4, 4, "P212121", "PG222", "P 21 21 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 20: {
                spaceGroup = new SpaceGroup(20, 8, 4, "C2221", "PG222", "C 2 2 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 21: {
                spaceGroup = new SpaceGroup(21, 8, 4, "C222", "PG222", "C 2 2 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 22: {
                spaceGroup = new SpaceGroup(22, 16, 4, "F222", "PG222", "F 2 2 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.25, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 23: {
                spaceGroup = new SpaceGroup(23, 8, 4, "I222", "PG222", "I 2 2 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 24: {
                spaceGroup = new SpaceGroup(24, 8, 4, "I212121", "PG222", "I 21 21 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 25: {
                spaceGroup = new SpaceGroup(25, 4, 4, "Pmm2", "PGmm2", "P m m 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 26: {
                spaceGroup = new SpaceGroup(26, 4, 4, "Pmc21", "PGmm2", "P m c 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 27: {
                spaceGroup = new SpaceGroup(27, 4, 4, "Pcc2", "PGmm2", "P c c 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 28: {
                spaceGroup = new SpaceGroup(28, 4, 4, "Pma2", "PGmm2", "P m a 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_0));
                break;
            }
            case 29: {
                spaceGroup = new SpaceGroup(29, 4, 4, "Pca21", "PGmm2", "P c a 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12));
                break;
            }
            case 30: {
                spaceGroup = new SpaceGroup(30, 4, 4, "Pnc2", "PGmm2", "P n c 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12));
                break;
            }
            case 31: {
                spaceGroup = new SpaceGroup(31, 4, 4, "Pmn21", "PGmm2", "P m n 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 32: {
                spaceGroup = new SpaceGroup(32, 4, 4, "Pba2", "PGmm2", "P b a 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 33: {
                spaceGroup = new SpaceGroup(33, 4, 4, "Pna21", "PGmm2", "P n a 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 34: {
                spaceGroup = new SpaceGroup(34, 4, 4, "Pnn2", "PGmm2", "P n n 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 35: {
                spaceGroup = new SpaceGroup(35, 8, 4, "Cmm2", "PGmm2", "C m m 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 36: {
                spaceGroup = new SpaceGroup(36, 8, 4, "Cmc21", "PGmm2", "C m c 21", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 37: {
                spaceGroup = new SpaceGroup(37, 8, 4, "Ccc2", "PGmm2", "C c c 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 38: {
                spaceGroup = new SpaceGroup(38, 8, 4, "Amm2", "PGmm2", "A m m 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12));
                break;
            }
            case 39: {
                spaceGroup = new SpaceGroup(39, 8, 4, "Abm2", "PGmm2", "A b m 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 40: {
                spaceGroup = new SpaceGroup(40, 8, 4, "Ama2", "PGmm2", "A m a 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 41: {
                spaceGroup = new SpaceGroup(41, 8, 4, "Aba2", "PGmm2", "A b a 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12));
                break;
            }
            case 42: {
                spaceGroup = new SpaceGroup(42, 16, 4, "Fmm2", "PGmm2", "F m m 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 43: {
                spaceGroup = new SpaceGroup(43, 16, 4, "Fdd2", "PGmm2", "F d d 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_34_14));
                break;
            }
            case 44: {
                spaceGroup = new SpaceGroup(44, 8, 4, "Imm2", "PGmm2", "I m m 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 45: {
                spaceGroup = new SpaceGroup(45, 8, 4, "Iba2", "PGmm2", "I b a 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 46: {
                spaceGroup = new SpaceGroup(46, 8, 4, "Ima2", "PGmm2", "I m a 2", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12));
                break;
            }
            case 47: {
                spaceGroup = new SpaceGroup(47, 8, 8, "Pmmm", "PGmmm", "P 2/m 2/m 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 48: {
                spaceGroup = new SpaceGroup(48, 8, 8, "Pnnn", "PGmmm", "P 2/n 2/n 2/n", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 49: {
                spaceGroup = new SpaceGroup(49, 8, 8, "Pccm", "PGmmm", "P 2/c 2/c 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 50: {
                spaceGroup = new SpaceGroup(50, 8, 8, "Pban", "PGmmm", "P 2/b 2/a 2/n", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
        }
        return spaceGroup;
    }

    static SpaceGroup getSpaceGroup2(int num) {
        SpaceGroup spaceGroup = null;
        switch (num) {
            case 51: {
                spaceGroup = new SpaceGroup(51, 8, 8, "Pmma", "PGmmm", "P 21/m 2/m 2/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_0));
                break;
            }
            case 52: {
                spaceGroup = new SpaceGroup(52, 8, 8, "Pnna", "PGmmm", "P 2/n 21/n 2/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12));
                break;
            }
            case 53: {
                spaceGroup = new SpaceGroup(53, 8, 8, "Pmna", "PGmmm", "P 2/m 2/n 21/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 54: {
                spaceGroup = new SpaceGroup(54, 8, 8, "Pcca", "PGmmm", "P 21/c 2/c 2/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12));
                break;
            }
            case 55: {
                spaceGroup = new SpaceGroup(55, 8, 8, "Pbam", "PGmmm", "P 21/b 21/a 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 56: {
                spaceGroup = new SpaceGroup(56, 8, 8, "Pccn", "PGmmm", "P 21/c 21/c 2/n", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12));
                break;
            }
            case 57: {
                spaceGroup = new SpaceGroup(57, 8, 8, "Pbcm", "PGmmm", "P 2/b 21/c 21/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_0));
                break;
            }
            case 58: {
                spaceGroup = new SpaceGroup(58, 8, 8, "Pnnm", "PGmmm", "P 21/n 21/n 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 59: {
                spaceGroup = new SpaceGroup(59, 8, 8, "Pmmn", "PGmmm", "P 21/m 21/m 2/n", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 60: {
                spaceGroup = new SpaceGroup(60, 8, 8, "Pbcn", "PGmmm", "P 21/b 2/c 21/n", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 61: {
                spaceGroup = new SpaceGroup(61, 8, 8, "Pbca", "PGmmm", "P 21/b 21/c 21/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 62: {
                spaceGroup = new SpaceGroup(62, 8, 8, "Pnma", "PGmmm", "P 21/n 21/m 21/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 63: {
                spaceGroup = new SpaceGroup(63, 16, 8, "Cmcm", "PGmmm", "C 2/m 2/c 21/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 64: {
                spaceGroup = new SpaceGroup(64, 16, 8, "Cmca", "PGmmm", "C 2/m 2/c 21/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 65: {
                spaceGroup = new SpaceGroup(65, 16, 8, "Cmmm", "PGmmm", "C 2/m 2/m 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.25, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 66: {
                spaceGroup = new SpaceGroup(66, 16, 8, "Cccm", "PGmmm", "C 2/c 2/c 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 67: {
                spaceGroup = new SpaceGroup(67, 16, 8, "Cmma", "PGmmm", "C 2/m 2/m 2/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 68: {
                spaceGroup = new SpaceGroup(68, 16, 8, "Ccca", "PGmmm", "C 2/c 2/c 2/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12));
                break;
            }
            case 69: {
                spaceGroup = new SpaceGroup(69, 32, 8, "Fmmm", "PGmmm", "F 2/m 2/m 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.25, 0.25, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 70: {
                spaceGroup = new SpaceGroup(70, 32, 8, "Fddd", "PGmmm", "F 2/d 2/d 2/d", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_34_14));
                break;
            }
            case 71: {
                spaceGroup = new SpaceGroup(71, 16, 8, "Immm", "PGmmm", "I 2/m 2/m 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.25, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 72: {
                spaceGroup = new SpaceGroup(72, 16, 8, "Ibam", "PGmmm", "I 2/b 2/a 2/m", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 73: {
                spaceGroup = new SpaceGroup(73, 16, 8, "Ibca", "PGmmm", "I 21/b 21/c 21/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 74: {
                spaceGroup = new SpaceGroup(74, 16, 8, "Imma", "PGmmm", "I 21/m 21/m 21/a", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 75: {
                spaceGroup = new SpaceGroup(75, 4, 4, "P4", "PG4", "P 4", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 76: {
                spaceGroup = new SpaceGroup(76, 4, 4, "P41", "PG4", "P 41", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_34));
                break;
            }
            case 77: {
                spaceGroup = new SpaceGroup(77, 4, 4, "P42", "PG4", "P 42", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LT}, new double[]{0.5, 1.0, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 78: {
                spaceGroup = new SpaceGroup(78, 4, 4, "P43", "PG4", "P 43", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_14));
                break;
            }
            case 79: {
                spaceGroup = new SpaceGroup(79, 8, 4, "I4", "PG4", "I 4", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 80: {
                spaceGroup = new SpaceGroup(80, 8, 4, "I41", "PG4", "I 41", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LT}, new double[]{0.5, 1.0, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14));
                break;
            }
            case 81: {
                spaceGroup = new SpaceGroup(81, 4, 4, "P-4", "PG4bar", "P -4", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 82: {
                spaceGroup = new SpaceGroup(82, 8, 4, "I-4", "PG4bar", "I -4", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 83: {
                spaceGroup = new SpaceGroup(83, 8, 8, "P4/m", "PG4/m", "P 4/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 84: {
                spaceGroup = new SpaceGroup(84, 8, 8, "P42/m", "PG4/m", "P 42/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 85: {
                spaceGroup = new SpaceGroup(85, 8, 8, "P4/n", "PG4/m", "P 4/n", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 86: {
                spaceGroup = new SpaceGroup(86, 8, 8, "P42/n", "PG4/m", "P 42/n", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 87: {
                spaceGroup = new SpaceGroup(87, 16, 8, "I4/m", "PG4/m", "I 4/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 88: {
                spaceGroup = new SpaceGroup(88, 16, 8, "I41/a", "PG4/m", "I 41/a", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 89: {
                spaceGroup = new SpaceGroup(89, 8, 8, "P422", "PG422", "P 4 2 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 90: {
                spaceGroup = new SpaceGroup(90, 8, 8, "P4212", "PG422", "P 4 21 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 91: {
                spaceGroup = new SpaceGroup(91, 8, 8, "P4122", "PG422", "P 41 2 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_34), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_14));
                break;
            }
            case 92: {
                spaceGroup = new SpaceGroup(92, 8, 8, "P41212", "PG422", "P 41 21 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_34), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_14), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_34), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 93: {
                spaceGroup = new SpaceGroup(93, 8, 8, "P4222", "PG422", "P 42 2 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LTE}, new double[]{0.5, 1.0, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 94: {
                spaceGroup = new SpaceGroup(94, 8, 8, "P42212", "PG422", "P 42 21 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 95: {
                spaceGroup = new SpaceGroup(95, 8, 8, "P4322", "PG422", "P 43 2 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_14), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_34));
                break;
            }
            case 96: {
                spaceGroup = new SpaceGroup(96, 8, 8, "P43212", "PG422", "P 43 21 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_14), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_34), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_14), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 97: {
                spaceGroup = new SpaceGroup(97, 16, 8, "I422", "PG422", "I 4 2 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 98: {
                spaceGroup = new SpaceGroup(98, 16, 8, "I4122", "PG422", "I 41 2 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LTE}, new double[]{0.5, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 99: {
                spaceGroup = new SpaceGroup(99, 8, 8, "P4mm", "PG4mm", "P 4 m m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 100: {
                spaceGroup = new SpaceGroup(100, 8, 8, "P4bm", "PG4mm", "P 4 b m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
        }
        return spaceGroup;
    }

    static SpaceGroup getSpaceGroup3(int num) {
        SpaceGroup spaceGroup = null;
        switch (num) {
            case 101: {
                spaceGroup = new SpaceGroup(101, 8, 8, "P42cm", "PG4mm", "P 42 c m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 102: {
                spaceGroup = new SpaceGroup(102, 8, 8, "P42nm", "PG4mm", "P 42 n m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 103: {
                spaceGroup = new SpaceGroup(103, 8, 8, "P4cc", "PG4mm", "P 4 c c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 104: {
                spaceGroup = new SpaceGroup(104, 8, 8, "P4nc", "PG4mm", "P 4 n c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 105: {
                spaceGroup = new SpaceGroup(105, 8, 8, "P42mc", "PG4mm", "P 42 m c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 106: {
                spaceGroup = new SpaceGroup(106, 8, 8, "P42bc", "PG4mm", "P 42 b c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 107: {
                spaceGroup = new SpaceGroup(107, 16, 8, "I4mm", "PG4mm", "I 4 m m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 108: {
                spaceGroup = new SpaceGroup(108, 16, 8, "I4cm", "PG4mm", "I 4 c m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 109: {
                spaceGroup = new SpaceGroup(109, 16, 8, "I41md", "PG4mm", "I 41 m d", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_14));
                break;
            }
            case 110: {
                spaceGroup = new SpaceGroup(110, 16, 8, "I41cd", "PG4mm", "I 41 c d", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_34), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_14), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_34));
                break;
            }
            case 111: {
                spaceGroup = new SpaceGroup(111, 8, 8, "P-42m", "PG4bar2m", "P -4 2 m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 112: {
                spaceGroup = new SpaceGroup(112, 8, 8, "P-42c", "PG4bar2m", "P -4 2 c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 113: {
                spaceGroup = new SpaceGroup(113, 8, 8, "P-421m", "PG4bar2m", "P -4 21 m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 114: {
                spaceGroup = new SpaceGroup(114, 8, 8, "P-421c", "PG4bar2m", "P -4 21 c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 115: {
                spaceGroup = new SpaceGroup(115, 8, 8, "P-4m2", "PG4barm2", "P -4 m 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 116: {
                spaceGroup = new SpaceGroup(116, 8, 8, "P-4c2", "PG4barm2", "P -4 c 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 117: {
                spaceGroup = new SpaceGroup(117, 8, 8, "P-4b2", "PG4barm2", "P -4 b 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 118: {
                spaceGroup = new SpaceGroup(118, 8, 8, "P-4n2", "PG4barm2", "P -4 n 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 119: {
                spaceGroup = new SpaceGroup(119, 16, 8, "I-4m2", "PG4barm2", "I -4 m 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12));
                break;
            }
            case 120: {
                spaceGroup = new SpaceGroup(120, 16, 8, "I-4c2", "PG4barm2", "I -4 c 2", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0));
                break;
            }
            case 121: {
                spaceGroup = new SpaceGroup(121, 16, 8, "I-42m", "PG4bar2m", "I -4 2 m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 122: {
                spaceGroup = new SpaceGroup(122, 16, 8, "I-42d", "PG4bar2m", "I -4 2 d", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_14));
                break;
            }
            case 123: {
                spaceGroup = new SpaceGroup(123, 16, 16, "P4/mmm", "PG4/mmm", "P 4/m 2/m 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 124: {
                spaceGroup = new SpaceGroup(124, 16, 16, "P4/mcc", "PG4/mmm", "P 4/m 2/c 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 125: {
                spaceGroup = new SpaceGroup(125, 16, 16, "P4/nbm", "PG4/mmm", "P 4/n 2/b 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 126: {
                spaceGroup = new SpaceGroup(126, 16, 16, "P4/nnc", "PG4/mmm", "P 4/n 2/n 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 127: {
                spaceGroup = new SpaceGroup(127, 16, 16, "P4/mbm", "PG4/mmm", "P 4/m 21/b 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 128: {
                spaceGroup = new SpaceGroup(128, 16, 16, "P4/mnc", "PG4/mmm", "P 4/m 21/n 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 129: {
                spaceGroup = new SpaceGroup(129, 16, 16, "P4/nmm", "PG4/mmm", "P 4/n 21/m 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 130: {
                spaceGroup = new SpaceGroup(130, 16, 16, "P4/ncc", "PG4/mmm", "P 4/n 2/c 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 131: {
                spaceGroup = new SpaceGroup(131, 16, 16, "P42/mmc", "PG4/mmm", "P 42/m 2/m 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 132: {
                spaceGroup = new SpaceGroup(132, 16, 16, "P42/mcm", "PG4/mmm", "P 42/m 2/c 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 133: {
                spaceGroup = new SpaceGroup(133, 16, 16, "P42/nbc", "PG4/mmm", "P 42/n 2/b 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 134: {
                spaceGroup = new SpaceGroup(134, 16, 16, "P42/nnm", "PG4/mmm", "P 42/n 2/n 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 135: {
                spaceGroup = new SpaceGroup(135, 16, 16, "P42/mbc", "PG4/mmm", "P 42/m 21/b 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 136: {
                spaceGroup = new SpaceGroup(136, 16, 16, "P42/mnm", "PG4/mmm", "P 42/m 21/n 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 137: {
                spaceGroup = new SpaceGroup(137, 16, 16, "P42/nmc", "PG4/mmm", "P 42/n 21/m 2/c", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 138: {
                spaceGroup = new SpaceGroup(138, 16, 16, "P42/ncm", "PG4/mmm", "P 42/n 21/c 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 139: {
                spaceGroup = new SpaceGroup(139, 32, 16, "I4/mmm", "PG4/mmm", "I 4/m 2/m 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12));
                break;
            }
            case 140: {
                spaceGroup = new SpaceGroup(140, 32, 16, "I4/mcm", "PG4/mmm", "I 4/m 2/c 2/m", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0));
                break;
            }
            case 141: {
                spaceGroup = new SpaceGroup(141, 32, 16, "I41/amd", "PG4/mmm", "I 41/a 2/m 2/d", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_34));
                break;
            }
            case 142: {
                spaceGroup = new SpaceGroup(142, 32, 16, "I41/acd", "PG4/mmm", "I 41/a 2/c 2/d", CrystalSystem.TETRAGONAL, LatticeSystem.TETRAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_14), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_34), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_14), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_34), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_14), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_14), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_34), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_14));
                break;
            }
            case 143: {
                spaceGroup = new SpaceGroup(143, 3, 3, "P3", "PG3", "P 3", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.6666666666666666, 0.6666666666666666, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 144: {
                spaceGroup = new SpaceGroup(144, 3, 3, "P31", "PG3", "P 31", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.3333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23));
                break;
            }
            case 145: {
                spaceGroup = new SpaceGroup(145, 3, 3, "P32", "PG3", "P 32", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.3333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13));
                break;
            }
            case 146: {
                spaceGroup = new SpaceGroup(146, 9, 3, "H3", "PG3", "H 3", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.6666666666666666, 0.6666666666666666, 0.3333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23));
                break;
            }
            case 147: {
                spaceGroup = new SpaceGroup(147, 6, 6, "P-3", "PG3bar", "P -3", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 148: {
                spaceGroup = new SpaceGroup(148, 18, 6, "H-3", "PG3bar", "H -3", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_13_23_23));
                break;
            }
            case 149: {
                spaceGroup = new SpaceGroup(149, 6, 6, "P312", "PG312", "P 3 1 2", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 150: {
                spaceGroup = new SpaceGroup(150, 6, 6, "P321", "PG321", "P 3 2 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0));
                break;
            }
        }
        return spaceGroup;
    }

    static SpaceGroup getSpaceGroup4(int num) {
        SpaceGroup spaceGroup = null;
        switch (num) {
            case 151: {
                spaceGroup = new SpaceGroup(151, 6, 6, "P3112", "PG312", "P 31 1 2", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 152: {
                spaceGroup = new SpaceGroup(152, 6, 6, "P3121", "PG321", "P 31 2 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_13));
                break;
            }
            case 153: {
                spaceGroup = new SpaceGroup(153, 6, 6, "P3212", "PG312", "P 32 1 2", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 154: {
                spaceGroup = new SpaceGroup(154, 6, 6, "P3221", "PG321", "P 32 2 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_23));
                break;
            }
            case 155: {
                spaceGroup = new SpaceGroup(155, 18, 6, "H32", "PG321", "H 3 2", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_13_23_23));
                break;
            }
            case 156: {
                spaceGroup = new SpaceGroup(156, 6, 6, "P3m1", "PG3m1", "P 3 m 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 157: {
                spaceGroup = new SpaceGroup(157, 6, 6, "P31m", "PG31m", "P 3 1 m", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 158: {
                spaceGroup = new SpaceGroup(158, 6, 6, "P3c1", "PG3m1", "P 3 c 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 159: {
                spaceGroup = new SpaceGroup(159, 6, 6, "P31c", "PG31m", "P 3 1 c", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 160: {
                spaceGroup = new SpaceGroup(160, 18, 6, "H3m", "PG3m", "H 3 m", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_13_23_23));
                break;
            }
            case 161: {
                spaceGroup = new SpaceGroup(161, 18, 6, "H3c", "PG3m", "H 3 c", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_13_23_16));
                break;
            }
            case 162: {
                spaceGroup = new SpaceGroup(162, 12, 12, "P-31m", "PG3bar1m", "P -3 1 2/m", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 163: {
                spaceGroup = new SpaceGroup(163, 12, 12, "P-31c", "PG3bar1m", "P -3 1 2/c", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L223, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 164: {
                spaceGroup = new SpaceGroup(164, 12, 12, "P-3m1", "PG3barm1", "P -3 2/m 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.3333333333333333, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 165: {
                spaceGroup = new SpaceGroup(165, 12, 12, "P-3c1", "PG3barm1", "P -3 2/c 1", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 166: {
                spaceGroup = new SpaceGroup(166, 36, 12, "H-3m", "PG3barm", "H -3 2/m", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_13_23_23));
                break;
            }
            case 167: {
                spaceGroup = new SpaceGroup(167, 36, 12, "H-3c", "PG3barm", "H -3 2/c", CrystalSystem.TRIGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_23_13_13), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_23_13_56), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_13_23_23), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_13_23_16), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_13_23_16));
                break;
            }
            case 168: {
                spaceGroup = new SpaceGroup(168, 6, 6, "P6", "PG6", "P 6", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.6666666666666666, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 169: {
                spaceGroup = new SpaceGroup(169, 6, 6, "P61", "PG6", "P 61", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_56), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_16));
                break;
            }
            case 170: {
                spaceGroup = new SpaceGroup(170, 6, 6, "P65", "PG6", "P 65", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_16), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_56));
                break;
            }
            case 171: {
                spaceGroup = new SpaceGroup(171, 6, 6, "P62", "PG6", "P 62", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.3333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_13));
                break;
            }
            case 172: {
                spaceGroup = new SpaceGroup(172, 6, 6, "P64", "PG6", "P 64", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{1.0, 1.0, 0.3333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_23));
                break;
            }
            case 173: {
                spaceGroup = new SpaceGroup(173, 6, 6, "P63", "PG6", "P 63", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.6666666666666666, 0.6666666666666666, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 174: {
                spaceGroup = new SpaceGroup(174, 6, 6, "P-6", "PG6bar", "P -6", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 175: {
                spaceGroup = new SpaceGroup(175, 12, 12, "P6/m", "PG6/m", "P 6/m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 176: {
                spaceGroup = new SpaceGroup(176, 12, 12, "P63/m", "PG6/m", "P 63/m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L114, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 177: {
                spaceGroup = new SpaceGroup(177, 12, 12, "P622", "PG622", "P 6 2 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 178: {
                spaceGroup = new SpaceGroup(178, 12, 12, "P6122", "PG622", "P 61 2 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.08333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_56), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_16), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_56), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_16));
                break;
            }
            case 179: {
                spaceGroup = new SpaceGroup(179, 12, 12, "P6522", "PG622", "P 65 2 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.08333333333333333}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_16), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_56), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_16), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_56));
                break;
            }
            case 180: {
                spaceGroup = new SpaceGroup(180, 12, 12, "P6222", "PG622", "P 62 2 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_13));
                break;
            }
            case 181: {
                spaceGroup = new SpaceGroup(181, 12, 12, "P6422", "PG622", "P 64 2 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.16666666666666666}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_23), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_13), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_23));
                break;
            }
            case 182: {
                spaceGroup = new SpaceGroup(182, 12, 12, "P6322", "PG622", "P 63 2 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.6666666666666666, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_12));
                break;
            }
            case 183: {
                spaceGroup = new SpaceGroup(183, 12, 12, "P6mm", "PG6mm", "P 6 m m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 184: {
                spaceGroup = new SpaceGroup(184, 12, 12, "P6cc", "PG6mm", "P 6 c c", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 185: {
                spaceGroup = new SpaceGroup(185, 12, 12, "P63cm", "PG6mm", "P 63 c m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 186: {
                spaceGroup = new SpaceGroup(186, 12, 12, "P63mc", "PG6mm", "P 63 m c", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 187: {
                spaceGroup = new SpaceGroup(187, 12, 12, "P-6m2", "PG6barm2", "P -6 m 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 188: {
                spaceGroup = new SpaceGroup(188, 12, 12, "P-6c2", "PG6barm2", "P -6 c 2", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0));
                break;
            }
            case 189: {
                spaceGroup = new SpaceGroup(189, 12, 12, "P-62m", "PG6bar2m", "P -6 2 m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 190: {
                spaceGroup = new SpaceGroup(190, 12, 12, "P-62c", "PG6bar2m", "P -6 2 c", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 191: {
                spaceGroup = new SpaceGroup(191, 24, 24, "P6/mmm", "PG6/mmm", "P 6/m 2/m 2/m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.6666666666666666, 0.3333333333333333, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 192: {
                spaceGroup = new SpaceGroup(192, 24, 24, "P6/mcc", "PG6/mmm", "P 6/m 2/c 2/c", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 193: {
                spaceGroup = new SpaceGroup(193, 24, 24, "P63/mcm", "PG6/mmm", "P 63/m 2/c 2/m", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_0));
                break;
            }
            case 194: {
                spaceGroup = new SpaceGroup(194, 24, 24, "P63/mmc", "PG6/mmm", "P 63/m 2/m 2/c", CrystalSystem.HEXAGONAL, LatticeSystem.HEXAGONAL_LATTICE, LaueSystem.L224, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mXY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mXY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_XmY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mXY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_XmY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mXY_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_XmY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_XmY_mY_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mXY_Z, SymOp.Tr_0_0_12));
                break;
            }
            case 195: {
                spaceGroup = new SpaceGroup(195, 12, 12, "P23", "PG23", "P 2 3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0));
                break;
            }
            case 196: {
                spaceGroup = new SpaceGroup(196, 48, 12, "F23", "PG23", "F 2 3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.25, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0));
                break;
            }
            case 197: {
                spaceGroup = new SpaceGroup(197, 24, 12, "I23", "PG23", "I 2 3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_12));
                break;
            }
            case 198: {
                spaceGroup = new SpaceGroup(198, 12, 12, "P213", "PG23", "P 21 3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LT}, new double[]{0.5, 0.5, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12));
                break;
            }
            case 199: {
                spaceGroup = new SpaceGroup(199, 24, 12, "I213", "PG23", "I 21 3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_0));
                break;
            }
            case 200: {
                spaceGroup = new SpaceGroup(200, 24, 24, "Pm-3", "PGm3bar", "P 2/m -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0));
                break;
            }
        }
        return spaceGroup;
    }

    static SpaceGroup getSpaceGroup5(int num) {
        SpaceGroup spaceGroup = null;
        switch (num) {
            case 201: {
                spaceGroup = new SpaceGroup(201, 24, 24, "Pn-3", "PGm3bar", "P 2/n -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_12));
                break;
            }
            case 202: {
                spaceGroup = new SpaceGroup(202, 96, 24, "Fm-3", "PGm3bar", "F 2/m -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_0));
                break;
            }
            case 203: {
                spaceGroup = new SpaceGroup(203, 96, 24, "Fd-3", "PGm3bar", "F 2/d -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_34_34_14));
                break;
            }
            case 204: {
                spaceGroup = new SpaceGroup(204, 48, 24, "Im-3", "PGm3bar", "I 2/m -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_12));
                break;
            }
            case 205: {
                spaceGroup = new SpaceGroup(205, 24, 24, "Pa-3", "PGm3bar", "P 21/a -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_0_12));
                break;
            }
            case 206: {
                spaceGroup = new SpaceGroup(206, 48, 24, "Ia-3", "PGm3bar", "I 21/a -3", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3B, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_12_0));
                break;
            }
            case 207: {
                spaceGroup = new SpaceGroup(207, 24, 24, "P432", "PG432", "P 4 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LTE, ASULimit.LTE}, new double[]{1.0, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0));
                break;
            }
            case 208: {
                spaceGroup = new SpaceGroup(208, 24, 24, "P4232", "PG432", "P 42 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LTE}, new double[]{0.5, 1.0, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12));
                break;
            }
            case 209: {
                spaceGroup = new SpaceGroup(209, 96, 24, "F432", "PG432", "F 4 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_0));
                break;
            }
            case 210: {
                spaceGroup = new SpaceGroup(210, 96, 24, "F4132", "PG432", "F 41 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LTE}, new double[]{0.5, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_34_14));
                break;
            }
            case 211: {
                spaceGroup = new SpaceGroup(211, 48, 24, "I432", "PG432", "I 4 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12));
                break;
            }
            case 212: {
                spaceGroup = new SpaceGroup(212, 24, 24, "P4332", "PG432", "P 43 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_14_14));
                break;
            }
            case 213: {
                spaceGroup = new SpaceGroup(213, 24, 24, "P4132", "PG432", "P 41 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LTE}, new double[]{1.0, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_34_34));
                break;
            }
            case 214: {
                spaceGroup = new SpaceGroup(214, 48, 24, "I4132", "PG432", "I 41 3 2", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LT, ASULimit.LTE}, new double[]{0.5, 1.0, 0.125}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_14_14));
                break;
            }
            case 215: {
                spaceGroup = new SpaceGroup(215, 24, 24, "P-43m", "PG4bar3m", "P -4 3 m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0));
                break;
            }
        }
        return spaceGroup;
    }

    static SpaceGroup getSpaceGroup6(int num) {
        SpaceGroup spaceGroup = null;
        switch (num) {
            case 216: {
                spaceGroup = new SpaceGroup(216, 96, 24, "F-43m", "PG4bar3m", "F -4 3 m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_0));
                break;
            }
            case 217: {
                spaceGroup = new SpaceGroup(217, 48, 24, "I-43m", "PG4bar3m", "I -4 3 m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12));
                break;
            }
            case 218: {
                spaceGroup = new SpaceGroup(218, 24, 24, "P-43n", "PG4bar3m", "P -4 3 n", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12));
                break;
            }
            case 219: {
                spaceGroup = new SpaceGroup(219, 96, 24, "F-43c", "PG4bar3m", "F -4 3 c", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_12));
                break;
            }
            case 220: {
                spaceGroup = new SpaceGroup(220, 48, 24, "I-43d", "PG4bar3m", "I -4 3 d", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_34_14_14));
                break;
            }
            case 221: {
                spaceGroup = new SpaceGroup(221, 48, 48, "Pm-3m", "PGm3barm", "P 4/m -3 2/m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.5}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0));
                break;
            }
            case 222: {
                spaceGroup = new SpaceGroup(222, 48, 48, "Pn-3n", "PGm3barm", "P 4/n -3 2/n", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12));
                break;
            }
            case 223: {
                spaceGroup = new SpaceGroup(223, 48, 48, "Pm-3n", "PGm3barm", "P 42/m -3 2/n", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12));
                break;
            }
            case 224: {
                spaceGroup = new SpaceGroup(224, 48, 48, "Pn-3m", "PGm3barm", "P 42/n -3 2/m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0));
                break;
            }
            case 225: {
                spaceGroup = new SpaceGroup(225, 192, 48, "Fm-3m", "PGm3barm", "F 4/m -3 2/m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.25, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_0));
                break;
            }
            case 226: {
                spaceGroup = new SpaceGroup(226, 192, 48, "Fm-3c", "PGm3barm", "F 4/m -3 2/c", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_12));
                break;
            }
            case 227: {
                spaceGroup = new SpaceGroup(227, 192, 48, "Fd-3m", "PGm3barm", "F 41/d -3 2/m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_0));
                break;
            }
            case 228: {
                spaceGroup = new SpaceGroup(228, 192, 48, "Fd-3c", "PGm3barm", "F 41/d -3 2/c", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_12));
                break;
            }
            case 229: {
                spaceGroup = new SpaceGroup(229, 96, 48, "Im-3m", "PGm3barm", "I 4/m -3 2/m", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LTE, ASULimit.LTE, ASULimit.LTE}, new double[]{0.5, 0.5, 0.25}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12));
                break;
            }
            case 230: {
                spaceGroup = new SpaceGroup(230, 96, 48, "Ia-3d", "PGm3barm", "I 41/a -3 2/d", CrystalSystem.CUBIC, LatticeSystem.CUBIC_LATTICE, LaueSystem.LM3M, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_mX_mY, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_Y, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mZ_X_mY, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mY_Z_mX, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_Y_mZ_mX, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mY_mZ_X, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Y_X_mZ, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_Y_mX_Z, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mY_X_Z, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_X_Z_mY, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_mX_Z_Y, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_X_mZ_Y, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_Z_Y_mX, SymOp.Tr_14_34_34), new SymOp(SymOp.Rot_Z_mY_X, SymOp.Tr_34_34_14), new SymOp(SymOp.Rot_mZ_Y_X, SymOp.Tr_34_14_34), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_14_14_14), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_X_Y, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Z_X_mY, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_Z_mX_Y, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Y_mZ_X, SymOp.Tr_12_0_0), new SymOp(SymOp.Rot_mY_Z_X, SymOp.Tr_0_0_12), new SymOp(SymOp.Rot_Y_Z_mX, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_mY_mX_Z, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mY_X_mZ, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Y_mX_mZ, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_mX_mZ_Y, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_X_mZ_mY, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_34_34_34), new SymOp(SymOp.Rot_mX_Z_mY, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_mZ_mY_X, SymOp.Tr_34_14_14), new SymOp(SymOp.Rot_mZ_Y_mX, SymOp.Tr_14_14_34), new SymOp(SymOp.Rot_Z_mY_mX, SymOp.Tr_14_34_14), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_34_34_34));
                break;
            }
        }
        return spaceGroup;
    }

    static SpaceGroup getAlternativeSpaceGroup(String name) {
        SpaceGroup spaceGroup = null;
        if ((name = name.replaceAll(" +", "")).equalsIgnoreCase("P21/a") || name.equalsIgnoreCase("P121/a1")) {
            spaceGroup = new SpaceGroup(14, 4, 4, "P21/a", "PG2/m", "P 1 21/a 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0));
        } else if (name.equalsIgnoreCase("P21/n") || name.equalsIgnoreCase("P121/n1")) {
            spaceGroup = new SpaceGroup(14, 4, 4, "P21/n", "PG2/m", "P 1 21/n 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_12));
        } else if (name.equalsIgnoreCase("Pn") || name.equalsIgnoreCase("P1n1")) {
            spaceGroup = new SpaceGroup(7, 2, 2, "Pn", "PGm", "P 1 n 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_12));
        } else if (name.equalsIgnoreCase("Pa") || name.equalsIgnoreCase("P1a1")) {
            spaceGroup = new SpaceGroup(7, 2, 2, "Pa", "PGm", "P 1 a 1", CrystalSystem.MONOCLINIC, LatticeSystem.MONOCLINIC_LATTICE, LaueSystem.L121, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_0_0));
        } else if (name.equalsIgnoreCase("Pcab") || name.equalsIgnoreCase("P21/c21/a21/b")) {
            spaceGroup = new SpaceGroup(61, 8, 8, "Pcab", "PGmmm", "P 21/c 21/a 21/b", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_Y_Z, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_X_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_X_Y_mZ, SymOp.Tr_0_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_12), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_0_12_12));
        } else if (name.equalsIgnoreCase("P21212A")) {
            spaceGroup = new SpaceGroup(18, 4, 4, "P21212A", "PG222", "P 21 21 2 A", CrystalSystem.ORTHORHOMBIC, LatticeSystem.ORTHORHOMBIC_LATTICE, LaueSystem.L222, new ASULimit[]{ASULimit.LT, ASULimit.LTE, ASULimit.LT}, new double[]{1.0, 0.25, 1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_Z, SymOp.Tr_12_12_0), new SymOp(SymOp.Rot_mX_Y_mZ, SymOp.Tr_0_12_0), new SymOp(SymOp.Rot_X_mY_mZ, SymOp.Tr_12_0_0));
        } else if (name.equalsIgnoreCase("R3")) {
            spaceGroup = new SpaceGroup(146, 4, 4, "R3", "PG3", "R 3", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0));
        } else if (name.equalsIgnoreCase("R-3")) {
            spaceGroup = new SpaceGroup(148, 6, 6, "R-3", "PG3bar", "R -3", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L113, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0));
        } else if (name.equalsIgnoreCase("R32")) {
            spaceGroup = new SpaceGroup(155, 6, 6, "R32", "PG321", "R 3 2", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0));
        } else if (name.equalsIgnoreCase("R3m")) {
            spaceGroup = new SpaceGroup(160, 6, 6, "R3m", "PG3m", "R 3 m", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0));
        } else if (name.equalsIgnoreCase("R3c")) {
            spaceGroup = new SpaceGroup(161, 6, 6, "R3c", "PG3m", "R 3 c", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12));
        } else if (name.equalsIgnoreCase("R-3m") || name.equalsIgnoreCase("R-32/m")) {
            spaceGroup = new SpaceGroup(166, 12, 12, "R-3m", "PG3barm", "R -3 2/m", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_0_0_0));
        } else if (name.equalsIgnoreCase("R-3c") || name.equalsIgnoreCase("R-32/c")) {
            spaceGroup = new SpaceGroup(167, 12, 12, "R-3c", "PG3barm", "R -3 2/c", CrystalSystem.TRIGONAL, LatticeSystem.RHOMBOHEDRAL_LATTICE, LaueSystem.L32U, new ASULimit[]{ASULimit.LT, ASULimit.LT, ASULimit.LT}, new double[]{-1.0, -1.0, -1.0}, new SymOp(SymOp.Rot_X_Y_Z, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Z_X_Y, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_Z_X, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mX_mZ, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mZ_mY_mX, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mZ_mY, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_mX_mY_mZ, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mZ_mX_mY, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_mY_mZ_mX, SymOp.Tr_0_0_0), new SymOp(SymOp.Rot_Y_X_Z, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_Z_Y_X, SymOp.Tr_12_12_12), new SymOp(SymOp.Rot_X_Z_Y, SymOp.Tr_12_12_12));
        }
        return spaceGroup;
    }

    public static SpaceGroup spaceGroupFactory(int number) {
        if (number > 0 && number <= 50) {
            return SpaceGroupDefinitions.getSpaceGroup1(number);
        }
        if (number > 50 && number <= 100) {
            return SpaceGroupDefinitions.getSpaceGroup2(number);
        }
        if (number > 100 && number <= 150) {
            return SpaceGroupDefinitions.getSpaceGroup3(number);
        }
        if (number > 150 && number <= 200) {
            return SpaceGroupDefinitions.getSpaceGroup4(number);
        }
        if (number > 200 && number <= 215) {
            return SpaceGroupDefinitions.getSpaceGroup5(number);
        }
        if (number > 215 && number <= 230) {
            return SpaceGroupDefinitions.getSpaceGroup6(number);
        }
        return null;
    }

    public static SpaceGroup spaceGroupFactory(String name) {
        String n = name.trim();
        SpaceGroup spaceGroup = SpaceGroupDefinitions.spaceGroupFactory(SpaceGroupDefinitions.spaceGroupNumber(n = n.replaceAll("[()]", "")));
        if (spaceGroup == null) {
            spaceGroup = SpaceGroupDefinitions.getAlternativeSpaceGroup(n);
        }
        return spaceGroup;
    }

    public static int spaceGroupNumber(String name) {
        if (name == null) {
            return -1;
        }
        String n = name.trim();
        int num = SpaceGroupInfo.spaceGroupNames.length;
        for (int i = 0; i < num; ++i) {
            String s1 = SpaceGroupInfo.spaceGroupNames[i];
            String s2 = SpaceGroupInfo.pdbSpaceGroupNames[i];
            if (!s1.equalsIgnoreCase(n.replaceAll(" +", "")) && !s2.equalsIgnoreCase(n)) continue;
            return i + 1;
        }
        return -1;
    }
}

