/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import ffx.crystal.ASULimit;
import ffx.crystal.CrystalSystem;
import ffx.crystal.LatticeSystem;
import ffx.crystal.LaueSystem;
import ffx.crystal.SpaceGroupInfo;
import ffx.crystal.SymOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpaceGroup {
    public final int number;
    public final int numPrimitiveSymEquiv;
    public final String shortName;
    public final String pointGroupName;
    public final CrystalSystem crystalSystem;
    public final LaueSystem laueSystem;
    public final String pdbName;
    public final List<SymOp> symOps;
    public final boolean respectsChirality;
    public final ASULimit[] asuLimitOperators;
    public final LatticeSystem latticeSystem;
    private final int numSymEquiv;
    private final double[] asuLimits;

    protected SpaceGroup(int number, int numSymEquiv, int numPrimitiveSymEquiv, String shortName, String pointGroupName, String pdbName, CrystalSystem crystalSystem, LatticeSystem latticeSystem, LaueSystem laueSystem, ASULimit[] asuLimitOperators, double[] asuLimits, SymOp ... symOps) {
        this.number = number;
        this.numSymEquiv = numSymEquiv;
        this.numPrimitiveSymEquiv = numPrimitiveSymEquiv;
        this.shortName = shortName;
        this.pointGroupName = pointGroupName;
        this.crystalSystem = crystalSystem;
        this.latticeSystem = latticeSystem;
        this.laueSystem = laueSystem;
        this.asuLimitOperators = asuLimitOperators;
        this.asuLimits = asuLimits;
        this.pdbName = pdbName;
        this.respectsChirality = SpaceGroupInfo.isSohnckeGroup(number);
        this.symOps = new ArrayList<SymOp>(Arrays.asList(symOps));
    }

    public int getNumberOfSymOps() {
        return this.symOps.size();
    }

    public SymOp getSymOp(int i) {
        return this.symOps.get(i);
    }

    public boolean respectsChirality() {
        return this.respectsChirality;
    }
}

