/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import org.apache.commons.math3.util.FastMath;

public enum LatticeSystem {
    TRICLINIC_LATTICE,
    MONOCLINIC_LATTICE,
    ORTHORHOMBIC_LATTICE,
    TETRAGONAL_LATTICE,
    RHOMBOHEDRAL_LATTICE,
    HEXAGONAL_LATTICE,
    CUBIC_LATTICE;

    private static final double tolerance = 1.0E-15;

    public static boolean check(double x1, double x2) {
        return FastMath.abs((double)(x1 - x2)) < 1.0E-15;
    }

    public double[] resetUnitCellParams() {
        double alpha = 60.0 + FastMath.random() * 60.0;
        double beta = 60.0 + FastMath.random() * 60.0;
        double gamma = 60.0 + FastMath.random() * 60.0;
        double[] params = new double[]{0.25 + FastMath.random(), 0.25 + FastMath.random(), 0.25 + FastMath.random(), alpha, beta, gamma};
        double ab = 0.5 * (params[0] + params[1]);
        double abc = (params[0] + params[1] + params[2]) / 3.0;
        switch (this.ordinal()) {
            default: {
                break;
            }
            case 1: {
                params[3] = 90.0;
                params[5] = 90.0;
                break;
            }
            case 2: {
                params[3] = 90.0;
                params[4] = 90.0;
                params[5] = 90.0;
                break;
            }
            case 3: {
                params[0] = ab;
                params[1] = ab;
                params[3] = 90.0;
                params[4] = 90.0;
                params[5] = 90.0;
                break;
            }
            case 4: {
                double angles = (params[3] + params[4] + params[5]) / 3.0;
                params[0] = abc;
                params[1] = abc;
                params[2] = abc;
                params[3] = angles;
                params[4] = angles;
                params[5] = angles;
                break;
            }
            case 5: {
                params[0] = ab;
                params[1] = ab;
                params[3] = 90.0;
                params[4] = 90.0;
                params[5] = 120.0;
                break;
            }
            case 6: {
                params[0] = abc;
                params[1] = abc;
                params[2] = abc;
                params[3] = 90.0;
                params[4] = 90.0;
                params[5] = 90.0;
            }
        }
        return params;
    }

    public boolean validParameters(double a, double b, double c, double alpha, double beta, double gamma) {
        switch (this.ordinal()) {
            default: {
                return true;
            }
            case 1: {
                return LatticeSystem.check(alpha, 90.0) && LatticeSystem.check(gamma, 90.0);
            }
            case 2: {
                return LatticeSystem.check(alpha, 90.0) && LatticeSystem.check(beta, 90.0) && LatticeSystem.check(gamma, 90.0);
            }
            case 3: {
                return LatticeSystem.check(a, b) && LatticeSystem.check(alpha, 90.0) && LatticeSystem.check(beta, 90.0) && LatticeSystem.check(gamma, 90.0);
            }
            case 4: {
                return LatticeSystem.check(a, b) && LatticeSystem.check(b, c) && LatticeSystem.check(alpha, beta) && LatticeSystem.check(beta, gamma);
            }
            case 5: {
                return LatticeSystem.check(a, b) && LatticeSystem.check(alpha, 90.0) && LatticeSystem.check(beta, 90.0) && LatticeSystem.check(gamma, 120.0);
            }
            case 6: 
        }
        return LatticeSystem.check(a, b) && LatticeSystem.check(b, c) && LatticeSystem.check(alpha, 90.0) && LatticeSystem.check(beta, 90.0) && LatticeSystem.check(gamma, 90.0);
    }

    public double[] fixParameters(double a, double b, double c, double alpha, double beta, double gamma) {
        double[] parameters = new double[]{a, b, c, alpha, beta, gamma};
        double ab = (parameters[0] + parameters[1]) / 2.0;
        double abc = (parameters[0] + parameters[1] + parameters[2]) / 3.0;
        switch (this.ordinal()) {
            default: {
                return parameters;
            }
            case 1: {
                parameters[3] = 90.0;
                parameters[5] = 90.0;
                return parameters;
            }
            case 2: {
                parameters[3] = 90.0;
                parameters[4] = 90.0;
                parameters[5] = 90.0;
                return parameters;
            }
            case 3: {
                parameters[0] = ab;
                parameters[1] = ab;
                parameters[3] = 90.0;
                parameters[4] = 90.0;
                parameters[5] = 90.0;
                return parameters;
            }
            case 4: {
                double angles = (parameters[3] + parameters[4] + parameters[5]) / 3.0;
                parameters[0] = abc;
                parameters[1] = abc;
                parameters[2] = abc;
                parameters[3] = angles;
                parameters[4] = angles;
                parameters[5] = angles;
                return parameters;
            }
            case 5: {
                parameters[0] = ab;
                parameters[1] = ab;
                parameters[3] = 90.0;
                parameters[4] = 90.0;
                parameters[5] = 120.0;
                return parameters;
            }
            case 6: 
        }
        parameters[0] = abc;
        parameters[1] = abc;
        parameters[2] = abc;
        parameters[3] = 90.0;
        parameters[4] = 90.0;
        parameters[5] = 90.0;
        return parameters;
    }

    public double getDefaultBAxis(double aaxis) {
        return aaxis;
    }

    public double getDefaultCAxis(double aaxis, double baxis) {
        return (aaxis + baxis) / 2.0;
    }

    public double getDefaultAlpha() {
        return 90.0;
    }

    public double getDefaultBeta() {
        return 90.0;
    }

    public double getDefaultGamma() {
        double gamma = 90.0;
        if (this == HEXAGONAL_LATTICE) {
            gamma = 120.0;
        }
        return gamma;
    }
}

