/*
 * Decompiled with CFR 0.152.
 */
package ffx.crystal;

import java.util.Objects;

public class HKL {
    static final double ndiv = 12.0;
    protected int h;
    protected int k;
    protected int l;
    protected int epsilon;
    protected int allowed;
    protected int bin;
    protected int index;

    public HKL() {
    }

    public HKL(int h, int k, int l) {
        this.h = h;
        this.k = k;
        this.l = l;
        this.allowed = 255;
    }

    public HKL(int h, int k, int l, int eps, int allowed) {
        this.h = h;
        this.k = k;
        this.l = l;
        this.epsilon = eps;
        this.allowed = allowed;
    }

    public HKL neg() {
        return new HKL(-this.h, -this.k, -this.l);
    }

    public boolean sysAbs() {
        return this.epsilon == 0;
    }

    public double quadForm(double[][] mat) {
        return (double)this.h * ((double)this.h * mat[0][0] + 2.0 * ((double)this.k * mat[0][1] + (double)this.l * mat[0][2])) + (double)this.k * ((double)this.k * mat[1][1] + 2.0 * ((double)this.l * mat[1][2])) + (double)(this.l * this.l) * mat[2][2];
    }

    public double getAllowed() {
        return (double)this.allowed * 0.2617993877991494;
    }

    public void setAllowed(int allowed) {
        this.allowed = allowed;
    }

    public int getBin() {
        return this.bin;
    }

    public void setBin(int bin) {
        this.bin = bin;
    }

    public boolean centric() {
        return this.allowed != 255;
    }

    public int getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(int eps) {
        this.epsilon = eps;
    }

    public int epsilonc() {
        if (this.centric()) {
            return 2 * this.epsilon;
        }
        return this.epsilon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HKL hkl = (HKL)o;
        return this.h == hkl.getH() && this.k == hkl.getK() && this.l == hkl.getL();
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int hashCode() {
        return Objects.hash(this.h, this.k, this.l);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getL() {
        return this.l;
    }

    public void setL(int l) {
        this.l = l;
    }

    public String toString() {
        return this.h + " " + this.k + " " + this.l + "(allowed: " + this.allowed + " eps: " + this.epsilon + ") ";
    }
}

