/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.stereo.AbstractStereo;
import org.openscience.cdk.stereo.Octahedral;

public final class SquarePlanar
extends AbstractStereo<IAtom, IAtom> {
    private static final int[][] PERMUTATIONS = new int[][]{{0, 1, 2, 3, 0, 3, 2, 1, 1, 2, 3, 0, 1, 0, 3, 2, 2, 3, 0, 1, 2, 1, 0, 3, 3, 2, 1, 0, 3, 0, 1, 2}, {0, 2, 1, 3, 0, 3, 1, 2, 1, 3, 0, 2, 1, 2, 0, 3, 2, 0, 3, 1, 2, 1, 3, 0, 3, 1, 2, 0, 3, 0, 2, 1}, {0, 1, 3, 2, 0, 2, 3, 1, 1, 0, 2, 3, 1, 3, 2, 0, 2, 3, 1, 0, 2, 0, 1, 3, 3, 2, 0, 1, 3, 1, 0, 2}};

    public SquarePlanar(IAtom focus, IAtom[] carriers, int order) {
        super((IChemObject)focus, (IChemObject[])carriers, 0x4500 | order & 0xFF);
        if (this.getConfigOrder() < 0 || this.getConfigOrder() > 3) {
            throw new IllegalArgumentException("Invalid configuration order,should be between 1-3");
        }
    }

    public SquarePlanar normalize() {
        int cfg = this.getConfigOrder();
        if (cfg == 1) {
            return this;
        }
        IAtom[] carriers = SquarePlanar.invapply(this.getCarriers().toArray(new IAtom[4]), PERMUTATIONS[cfg - 1]);
        return new SquarePlanar((IAtom)this.getFocus(), carriers, 17665);
    }

    public Octahedral asOctahedral() {
        List carriers = this.getCarriers();
        int cfg = 24832;
        if (this.getConfigOrder() == 1) {
            cfg = 1;
        } else if (this.getConfigOrder() == 2) {
            cfg = 8;
        } else if (this.getConfigOrder() == 3) {
            cfg = 4;
        }
        return new Octahedral((IAtom)this.getFocus(), new IAtom[]{(IAtom)this.getFocus(), (IAtom)carriers.get(0), (IAtom)carriers.get(1), (IAtom)carriers.get(2), (IAtom)carriers.get(3), (IAtom)this.getFocus()}, cfg);
    }

    protected SquarePlanar create(IAtom focus, List<IAtom> carriers, int cfg) {
        return new SquarePlanar(focus, carriers.toArray(new IAtom[4]), cfg);
    }
}

