/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IStereoElement;

abstract class AbstractStereo<F extends IChemObject, C extends IChemObject>
implements IStereoElement<F, C> {
    private int value;
    private final F focus;
    private final List<C> carriers;
    private IChemObjectBuilder builder;
    protected static final int A = 0;
    protected static final int B = 1;
    protected static final int C = 2;
    protected static final int D = 3;
    protected static final int E = 4;
    protected static final int F = 5;

    protected static int numCarriers(int cfg) {
        return cfg >>> 12 & 0xF;
    }

    AbstractStereo(F focus, C[] carriers, int value) {
        if (focus == null) {
            throw new NullPointerException("Focus of stereochemistry can not be null!");
        }
        if (carriers == null) {
            throw new NullPointerException("Carriers of the configuration can not be null!");
        }
        if (carriers.length != AbstractStereo.numCarriers(value)) {
            throw new IllegalArgumentException("Unexpected number of stereo carriers! expected " + (value >>> 12 & 0xF) + " was " + carriers.length);
        }
        for (C carrier : carriers) {
            if (carrier != null) continue;
            throw new NullPointerException("A carrier was undefined!");
        }
        this.value = value;
        this.focus = focus;
        ArrayList tmp = new ArrayList();
        Collections.addAll(tmp, carriers);
        this.carriers = Collections.unmodifiableList(tmp);
    }

    public F getFocus() {
        return this.focus;
    }

    public List<C> getCarriers() {
        return this.carriers;
    }

    public int getConfigClass() {
        return this.value & 0xFF00;
    }

    public int getConfigOrder() {
        return this.value & 0xFF;
    }

    public int getConfig() {
        return this.value & 0xFFFF;
    }

    public void setConfigOrder(int cfg) {
        this.value = this.getConfigClass() | cfg;
    }

    public int getGroupInfo() {
        return this.value & 0xFF0000;
    }

    public void setGroupInfo(int grp) {
        this.value &= 0xFF00FFFF;
        this.value |= grp & 0xFF0000;
    }

    public boolean contains(IAtom atom) {
        if (this.focus.equals(atom) || this.focus instanceof IBond && ((IBond)this.focus).contains(atom)) {
            return true;
        }
        for (IChemObject carrier : this.carriers) {
            if (!carrier.equals(atom) && (!(carrier instanceof IBond) || !((IBond)carrier).contains(atom))) continue;
            return true;
        }
        return false;
    }

    public IStereoElement<F, C> map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        if (atoms == null) {
            throw new IllegalArgumentException("Atom map should be non-null");
        }
        if (bonds == null) {
            throw new IllegalArgumentException("Bond map should be non-null");
        }
        HashMap<IChemObject, IChemObject> map = new HashMap<IChemObject, IChemObject>(atoms.size() + bonds.size());
        map.putAll(atoms);
        map.putAll(bonds);
        return this.map(map);
    }

    public IStereoElement<F, C> map(Map<IChemObject, IChemObject> chemobjs) {
        if (chemobjs == null) {
            throw new NullPointerException("chemobj map was not provided!");
        }
        Object newfocus = chemobjs.get(this.focus);
        if (newfocus == null) {
            newfocus = this.focus;
        }
        List<C> newcarriers = this.carriers;
        for (int i = 0; i < newcarriers.size(); ++i) {
            IChemObject newcarrier = chemobjs.get(newcarriers.get(i));
            if (newcarrier == null) continue;
            if (newcarriers == this.carriers) {
                newcarriers = new ArrayList<C>(this.carriers);
            }
            newcarriers.set(i, newcarrier);
        }
        if (newfocus == this.focus && newcarriers == this.carriers) {
            return this;
        }
        IStereoElement<IChemObject, C> se = this.create(newfocus, newcarriers, this.value);
        se.setGroupInfo(this.getGroupInfo());
        return se;
    }

    private IStereoElement<F, C> updateCarriers(List<C> carriers) {
        IStereoElement<F, C> se = this.create(this.focus, carriers, this.value);
        se.setGroupInfo(this.getGroupInfo());
        return se;
    }

    public IStereoElement<F, C> updateCarriers(C remove, Iterable<C> adds) {
        Iterator<C> repIter = adds.iterator();
        List<C> carriers = this.getCarriers();
        ArrayList<IChemObject> newCarriers = new ArrayList<IChemObject>();
        for (IChemObject carrier : carriers) {
            if (remove.equals(carrier) && repIter.hasNext()) {
                newCarriers.add((IChemObject)repIter.next());
                continue;
            }
            newCarriers.add(carrier);
        }
        return this.updateCarriers(newCarriers);
    }

    public IStereoElement<F, C> updateCarriers(Set<C> remove, C rep) {
        List<C> carriers = this.getCarriers();
        ArrayList<Object> newCarriers = new ArrayList<Object>();
        for (IChemObject carrier : carriers) {
            if (remove.contains(carrier)) {
                newCarriers.add(rep);
                continue;
            }
            newCarriers.add(carrier);
        }
        return this.updateCarriers(newCarriers);
    }

    public final IStereoElement<F, C> mapStrict(Map<IChemObject, IChemObject> chemobjs) {
        if (chemobjs == null) {
            throw new NullPointerException("chemobj map was not provided!");
        }
        IChemObject newfocus = chemobjs.get(this.focus);
        if (newfocus == null) {
            return null;
        }
        List<C> newcarriers = this.carriers;
        for (int i = 0; i < newcarriers.size(); ++i) {
            IChemObject newcarrier = chemobjs.get(newcarriers.get(i));
            if (newcarrier != null) {
                if (newcarriers == this.carriers) {
                    newcarriers = new ArrayList<C>(this.carriers);
                }
            } else {
                return null;
            }
            newcarriers.set(i, newcarrier);
        }
        if (newfocus == this.focus && newcarriers == this.carriers) {
            return this;
        }
        IStereoElement<IChemObject, C> se = this.create(newfocus, newcarriers, this.value);
        se.setGroupInfo(this.getGroupInfo());
        return se;
    }

    protected abstract IStereoElement<F, C> create(F var1, List<C> var2, int var3);

    public IChemObjectBuilder getBuilder() {
        if (this.builder == null) {
            throw new UnsupportedOperationException("Non-domain object!");
        }
        return this.builder;
    }

    protected void setBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    protected static <T> T[] invapply(T[] src, int[] perm) {
        Object[] res = (Object[])src.clone();
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[perm[i]];
        }
        return res;
    }
}

