/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.ChemObjectIO;
import org.openscience.cdk.io.DefaultChemObjectReaderErrorHandler;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.IChemObjectReaderErrorHandler;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.IReaderListener;

public abstract class DefaultChemObjectReader
extends ChemObjectIO
implements ISimpleChemObjectReader {
    private ReaderEvent frameReadEvent = null;
    protected IChemObjectReader.Mode mode = IChemObjectReader.Mode.RELAXED;
    protected IChemObjectReaderErrorHandler errorHandler = new DefaultChemObjectReaderErrorHandler(this.getClass());

    protected void fireFrameRead() {
        for (IChemObjectIOListener listener : this.getListeners()) {
            if (!(listener instanceof IReaderListener)) continue;
            if (this.frameReadEvent == null) {
                this.frameReadEvent = new ReaderEvent((Object)this);
            }
            ((IReaderListener)listener).frameRead(this.frameReadEvent);
        }
    }

    public void setReaderMode(IChemObjectReader.Mode mode) {
        this.mode = mode;
    }

    public void setErrorHandler(IChemObjectReaderErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void handleError(String message) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message);
        }
    }

    public void handleError(String message, Exception exception) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, exception);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message, (Throwable)exception);
        }
    }

    public void handleError(String message, int row, int colStart, int colEnd) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, row, colStart, colEnd);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message);
        }
    }

    public void handleError(String message, int row, int colStart, int colEnd, Exception exception) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, row, colStart, colEnd, exception);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message, (Throwable)exception);
        }
    }
}

