/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.ISetting;
import org.openscience.cdk.io.IChemObjectIO;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.SettingManager;

public abstract class ChemObjectIO
implements IChemObjectIO {
    private final List<IChemObjectIOListener> listeners = new ArrayList<IChemObjectIOListener>(2);
    private final SettingManager<IOSetting> settings = new SettingManager();

    public List<IChemObjectIOListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addChemObjectIOListener(IChemObjectIOListener listener) {
        this.listeners.add(listener);
    }

    public void removeChemObjectIOListener(IChemObjectIOListener listener) {
        this.listeners.remove(listener);
    }

    public <S extends IOSetting> S addSetting(IOSetting setting) {
        if (this.hasSetting(setting.getName())) {
            try {
                S current = this.getSetting(setting.getName());
                current.setSetting(setting.getSetting());
                return current;
            }
            catch (CDKException cDKException) {
                // empty catch block
            }
        }
        return (S)this.settings.add(setting);
    }

    public void addSettings(Collection<IOSetting> settings) {
        for (IOSetting setting : settings) {
            this.addSetting(setting);
        }
    }

    public boolean hasSetting(String name) {
        return this.settings.has(name);
    }

    public <S extends IOSetting> S getSetting(String name) {
        return (S)((IOSetting)this.settings.get(name));
    }

    public <S extends IOSetting> S getSetting(String name, Class<S> c) {
        return (S)((IOSetting)this.settings.get(name, c));
    }

    public IOSetting[] getIOSettings() {
        return (IOSetting[])this.settings.toArray((ISetting[])new IOSetting[0]);
    }

    public Collection<IOSetting> getSettings() {
        return this.settings.getSettings();
    }

    protected void fireIOSettingQuestion(IOSetting setting) {
        for (IChemObjectIOListener listener : this.listeners) {
            listener.processIOSettingQuestion(setting);
        }
    }
}

