/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.config.IAtomTypeConfigurator;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

public class TXTBasedAtomTypeConfigurator
implements IAtomTypeConfigurator {
    private final String configFile = "org/openscience/cdk/config/data/jmol_atomtypes.txt";
    private InputStream ins = null;

    @Override
    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    @Override
    public List<IAtomType> readAtomTypes(IChemObjectBuilder builder) throws IOException {
        String string;
        ArrayList<IAtomType> atomTypes = new ArrayList<IAtomType>();
        if (this.ins == null) {
            this.ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/config/data/jmol_atomtypes.txt");
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting the default stream: org/openscience/cdk/config/data/jmol_atomtypes.txt");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.ins), 1024);
        while ((string = reader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            StringTokenizer tokenizer = new StringTokenizer(string, "\t ,;");
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 9) {
                int colorB;
                int colorG;
                int colorR;
                int atomicNumber;
                double covalent;
                double mass;
                String name = tokenizer.nextToken();
                String rootType = tokenizer.nextToken();
                String san = tokenizer.nextToken();
                String sam = tokenizer.nextToken();
                tokenizer.nextToken();
                String scovalent = tokenizer.nextToken();
                String sColorR = tokenizer.nextToken();
                String sColorG = tokenizer.nextToken();
                String sColorB = tokenizer.nextToken();
                try {
                    mass = Double.parseDouble(sam);
                    covalent = Double.parseDouble(scovalent);
                    atomicNumber = Integer.parseInt(san);
                    colorR = Integer.parseInt(sColorR);
                    colorG = Integer.parseInt(sColorG);
                    colorB = Integer.parseInt(sColorB);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("AtomTypeTable.ReadAtypes: Malformed Number");
                }
                IAtomType atomType = (IAtomType)builder.newInstance(IAtomType.class, new Object[]{name, rootType});
                atomType.setAtomicNumber(Integer.valueOf(atomicNumber));
                atomType.setExactMass(Double.valueOf(mass));
                atomType.setCovalentRadius(Double.valueOf(covalent));
                atomType.setProperty((Object)"org.openscience.cdk.renderer.color", (Object)(colorR << 16 & 0xFF0000 | colorG << 8 & 0xFF00 | colorB & 0xFF));
                atomTypes.add(atomType);
                continue;
            }
            throw new IOException("AtomTypeTable.ReadAtypes: Wrong Number of fields");
        }
        this.ins.close();
        return atomTypes;
    }
}

