/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TinkerUtils {
    private static final Logger logger = Logger.getLogger(TinkerUtils.class.getName());
    private static final Pattern atomSelectionStartPattern = Pattern.compile("-(\\d+)");
    private static final Pattern atomSingletonPattern = Pattern.compile("(\\d+)");

    private TinkerUtils() {
    }

    public static List<Integer> parseTinkerAtomList(List<String> tokens, int offset, int maxEntries) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int nParsed = 0;
        int n = tokens.size();
        for (int i = 0; i < n; ++i) {
            Matcher m = atomSelectionStartPattern.matcher(tokens.get(i));
            if (m.matches()) {
                start = Integer.parseInt(m.group(1));
                if (++i == n) {
                    logger.fine(String.format(" Attempted to parse -%d as a Tinker-style range, but it was ignored because it was the last token provided.", start));
                    continue;
                }
                int end = Integer.parseInt(tokens.get(i));
                if (end < start) {
                    logger.fine(String.format(" Attempted to parse -%d to %d as a Tinker-style range, which is ignored due to being invalid.", start, end));
                    continue;
                }
                for (int j = start; j <= end; ++j) {
                    list.add(j + offset);
                }
                ++nParsed;
            } else {
                m = atomSingletonPattern.matcher(tokens.get(i));
                if (m.matches()) {
                    start = Integer.parseInt(m.group(1));
                    list.add(start + offset);
                    ++nParsed;
                } else {
                    logger.fine(String.format(" Attempted to parse %s as a Tinker-style range, but it was not recognized and ignored.", tokens.get(i)));
                }
            }
            if (maxEntries > 0 && nParsed >= maxEntries) break;
        }
        return list;
    }

    public static File previousVersion(File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        int dot = file.getAbsolutePath().lastIndexOf(".");
        int under = file.getAbsolutePath().lastIndexOf("_");
        File newFile = file;
        if (under > dot) {
            String name = fileName.substring(0, under);
            newFile = new File(name);
        }
        File baseFile = newFile;
        File previousFile = null;
        int i = 1;
        while (newFile.exists()) {
            previousFile = newFile;
            newFile = TinkerUtils.tinkerFile(baseFile, ++i);
        }
        return previousFile;
    }

    public static File version(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return file;
        }
        String fileName = file.getAbsolutePath();
        int dot = file.getAbsolutePath().lastIndexOf(".");
        int under = file.getAbsolutePath().lastIndexOf("_");
        File newFile = file;
        if (under > dot) {
            String name = fileName.substring(0, under);
            newFile = new File(name);
        }
        File oldFile = newFile;
        int i = 1;
        while (newFile.exists()) {
            newFile = TinkerUtils.tinkerFile(oldFile, ++i);
        }
        return newFile;
    }

    private static File tinkerFile(File file, int i) {
        return new File(file.getAbsolutePath() + "_" + i);
    }
}

