/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import ffx.utilities.FFXProperties;
import ffx.utilities.FFXProperty;
import ffx.utilities.PropertyGroup;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"ffx.utilities.FFXProperty", "ffx.utilities.FFXProperties"})
@SupportedOptions(value={"propertyDir"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_25)
public class PropertyProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Object properties;
        if (annotations.isEmpty()) {
            return true;
        }
        String propertyDir = this.processingEnv.getOptions().get("propertyDir");
        Path propertyPath = Paths.get(propertyDir, new String[0]);
        if (!Files.exists(propertyPath, new LinkOption[0])) {
            try {
                Files.createDirectory(propertyPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                System.out.println(" Exception creating Property directory:\n " + String.valueOf(exception));
            }
        }
        ArrayList<FFXProperty> propertyList = new ArrayList<FFXProperty>();
        Set<? extends Element> annotatedProperties = roundEnv.getElementsAnnotatedWith(FFXProperty.class);
        for (Element element : annotatedProperties) {
            FFXProperty fFXProperty = element.getAnnotation(FFXProperty.class);
            propertyList.add(fFXProperty);
        }
        Set<? extends Element> propertyArrays = roundEnv.getElementsAnnotatedWith(FFXProperties.class);
        for (Element element : propertyArrays) {
            FFXProperties ffxProperties = element.getAnnotation(FFXProperties.class);
            properties = ffxProperties.value();
            Collections.addAll(propertyList, properties);
        }
        for (FFXProperty fFXProperty : propertyList) {
            StringBuilder sb = new StringBuilder(String.format("\n=== %s\n", fFXProperty.name()));
            sb.append("[%collapsible]\n====\n");
            try {
                properties = fFXProperty.clazz();
            }
            catch (MirroredTypeException e) {
                TypeMirror typeMirror = e.getTypeMirror();
                String type = typeMirror.toString();
                type = type.replace("java.lang.", "");
                sb.append(String.format("  Type:         %s\n", type));
            }
            String defaultValue = fFXProperty.defaultValue();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                sb.append(String.format("  Default:      %s\n", fFXProperty.defaultValue()));
            }
            sb.append(String.format("  Definition:   %s\n", fFXProperty.description()));
            sb.append("====\n");
            PropertyGroup group = fFXProperty.propertyGroup();
            Path groupPath = Paths.get(propertyPath.toString(), group.name());
            if (!Files.exists(groupPath, new LinkOption[0])) {
                try {
                    Files.createDirectory(groupPath, new FileAttribute[0]);
                }
                catch (IOException exception) {
                    System.out.println(" Exception creating property group sub-directory:\n " + String.valueOf(exception));
                }
            }
            Path adocPath = Paths.get(groupPath.toString(), fFXProperty.name() + ".adoc");
            try {
                Files.writeString(adocPath, (CharSequence)sb.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                System.out.println(" Exception writing property:\n " + String.valueOf(e));
            }
        }
        return true;
    }
}

