/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FilenameUtils;

public class Keyword {
    private static final Logger logger = Logger.getLogger(Keyword.class.getName());
    private final String keyword;
    private final Vector<String> data;

    public Keyword(String k) {
        this.keyword = k;
        this.data = new Vector();
    }

    public Keyword(String k, String entry) {
        this(k);
        this.data.add(entry);
    }

    public Keyword(String k, String[] entry) {
        this(k);
        this.data.addAll(Arrays.asList(entry));
    }

    public static CompositeConfiguration loadProperties(File file) {
        File systemPropFile;
        FileBasedConfigurationBuilder builder;
        FileBasedConfigurationBuilder builder2;
        CompositeConfiguration properties = new CompositeConfiguration();
        PropertiesConfiguration systemConfiguration = new PropertiesConfiguration();
        systemConfiguration.append((Configuration)new SystemConfiguration());
        systemConfiguration.setHeader("JVM system properties (i.e. command line -Dkey=value pairs).");
        properties.addConfiguration((Configuration)systemConfiguration);
        if (properties.containsKey("key")) {
            String keyString = properties.getString("key");
            File keyFile = new File(keyString);
            if (keyFile.exists() && keyFile.canRead()) {
                try {
                    builder2 = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(keyFile)).setThrowExceptionOnMissing(true)).setIncludesAllowed(false)});
                    PropertiesConfiguration propertyConfiguration = (PropertiesConfiguration)builder2.getConfiguration();
                    propertyConfiguration.setHeader("Structure properties from (" + keyString + ").");
                    properties.addConfiguration((Configuration)propertyConfiguration);
                    properties.addProperty("propertyFile", (Object)keyFile.getCanonicalPath());
                }
                catch (IOException | ConfigurationException e) {
                    logger.log(Level.INFO, " Error loading {0}.", keyFile);
                }
            } else {
                logger.severe(String.format(" Keyword file supplied at the command line does not exist: %s.", keyString));
            }
        } else if (file != null) {
            File structurePropFile;
            String propertyFilename;
            String structureBasename = FilenameUtils.removeExtension((String)file.getAbsolutePath());
            String string = new File(structureBasename + ".properties").exists() ? structureBasename + ".properties" : (new File(structureBasename + ".prop").exists() ? structureBasename + ".prop" : (propertyFilename = new File(structureBasename + ".key").exists() ? structureBasename + ".key" : null));
            if (propertyFilename != null && (structurePropFile = new File(propertyFilename)).canRead()) {
                try {
                    builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(structurePropFile)).setThrowExceptionOnMissing(true)).setIncludesAllowed(false)});
                    PropertiesConfiguration propertyConfiguration = (PropertiesConfiguration)builder.getConfiguration();
                    propertyConfiguration.setHeader("Structure properties from (" + propertyFilename + ").");
                    properties.addConfiguration((Configuration)propertyConfiguration);
                    properties.addProperty("propertyFile", (Object)structurePropFile.getCanonicalPath());
                }
                catch (IOException | ConfigurationException e) {
                    logger.log(Level.INFO, " Error loading {0}.", structureBasename);
                }
            }
        }
        Object filename = System.getProperty("user.home") + File.separator + ".ffx/ffx.properties";
        File userPropFile = new File((String)filename);
        if (userPropFile.exists() && userPropFile.canRead()) {
            try {
                builder2 = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(userPropFile)).setThrowExceptionOnMissing(true)).setIncludesAllowed(false)});
                PropertiesConfiguration ffxConfiguration = (PropertiesConfiguration)builder2.getConfiguration();
                ffxConfiguration.setHeader("FFX user property file (" + (String)filename + ").");
                properties.addConfiguration((Configuration)ffxConfiguration);
            }
            catch (ConfigurationException e) {
                logger.log(Level.INFO, " Error loading {0}.", filename);
            }
        }
        if ((filename = System.getenv("FFX_PROPERTIES")) != null && (systemPropFile = new File((String)filename)).exists() && systemPropFile.canRead()) {
            try {
                builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFile(systemPropFile)).setThrowExceptionOnMissing(true)).setIncludesAllowed(false)});
                PropertiesConfiguration envConfiguration = (PropertiesConfiguration)builder.getConfiguration();
                envConfiguration.setHeader("Environment variable FFX_PROPERTIES (" + (String)filename + ").");
                properties.addConfiguration((Configuration)envConfiguration);
            }
            catch (ConfigurationException e) {
                logger.log(Level.INFO, " Error loading {0}.", filename);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            Iterator i = properties.getKeys();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\n %-30s %s\n", "Property", "Value"));
            while (i.hasNext()) {
                String s = (String)i.next();
                sb.append(String.format(" %-30s %s\n", s, Arrays.toString(properties.getList(s).toArray())));
            }
            logger.fine(sb.toString());
        }
        return properties;
    }

    public void append(String entry) {
        this.data.add(entry);
    }

    public void append(String[] entry) {
        this.data.addAll(Arrays.asList(entry));
    }

    public void clear() {
        this.data.clear();
    }

    public Vector<String> getEntries() {
        return this.data;
    }

    public String getEntry(int i) {
        return this.data.get(i);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void print() {
        logger.info(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword + " ");
        for (String s : this.data) {
            sb.append(s);
        }
        return sb.toString();
    }
}

