/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.logging.Logger;

public class HistogramXmlAdapter
extends XmlAdapter<String, double[][]> {
    public static final Logger logger = Logger.getLogger(HistogramXmlAdapter.class.getName());

    public double[][] unmarshal(String value) {
        double[][] data;
        try {
            String[] lines = value.split(System.lineSeparator());
            int lambdaBins = lines.length;
            data = new double[lambdaBins][];
            for (int i = 0; i < lambdaBins; ++i) {
                String[] countToks = lines[i].split(" +");
                int dUdLBins = countToks.length;
                data[i] = new double[dUdLBins];
                double[] row = data[i];
                for (int j = 0; j < dUdLBins; ++j) {
                    row[j] = Double.parseDouble(countToks[j]);
                }
            }
        }
        catch (Exception e) {
            logger.warning(" Returning a null histogram due to an XML parsing exception:\n " + String.valueOf(e));
            data = null;
        }
        return data;
    }

    public String marshal(double[][] data) {
        StringBuilder sb = new StringBuilder();
        for (double[] row : data) {
            sb.append(String.format("%.16e", row[0]));
            int dUdLBins = row.length;
            for (int j = 1; j < dUdLBins; ++j) {
                sb.append(" ").append(String.format("%.16e", row[j]));
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

