/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.os.Clock;
import com.jogamp.opengl.FPSCounter;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class FPSCounterImpl
implements FPSCounter {
    private PrintStream fpsOutputStream;
    private long fpsStartTimeNS;
    private long fpsLastUpdateTimeNS;
    private long fpsLastPeriodMS;
    private long fpsTotalDurationMS;
    private int fpsUpdateFramesInterval;
    private int fpsTotalFrames;
    private float fpsLast;
    private float fpsTotal;

    public FPSCounterImpl() {
        this.setUpdateFPSFrames(0, null);
    }

    public final synchronized void tickFPS() {
        ++this.fpsTotalFrames;
        if (this.fpsUpdateFramesInterval > 0 && this.fpsTotalFrames % this.fpsUpdateFramesInterval == 0) {
            long l = Clock.currentNanos();
            this.fpsLastPeriodMS = TimeUnit.NANOSECONDS.toMillis(l - this.fpsLastUpdateTimeNS);
            this.fpsLastPeriodMS = Math.max(this.fpsLastPeriodMS, 1L);
            this.fpsLast = (float)this.fpsUpdateFramesInterval * 1000.0f / (float)this.fpsLastPeriodMS;
            this.fpsTotalDurationMS = TimeUnit.NANOSECONDS.toMillis(l - this.fpsStartTimeNS);
            this.fpsTotalDurationMS = Math.max(this.fpsTotalDurationMS, 1L);
            this.fpsTotal = (float)this.fpsTotalFrames * 1000.0f / (float)this.fpsTotalDurationMS;
            if (null != this.fpsOutputStream) {
                this.fpsOutputStream.println(this.toString());
            }
            this.fpsLastUpdateTimeNS = l;
        }
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string = String.valueOf(this.fpsLast);
        string = string.substring(0, string.indexOf(46) + 2);
        String string2 = String.valueOf(this.fpsTotal);
        string2 = string2.substring(0, string2.indexOf(46) + 2);
        stringBuilder.append(this.fpsTotalDurationMS / 1000L + " s: " + this.fpsUpdateFramesInterval + " f / " + this.fpsLastPeriodMS + " ms, " + string + " fps, " + this.fpsLastPeriodMS / (long)this.fpsUpdateFramesInterval + " ms/f; total: " + this.fpsTotalFrames + " f, " + string2 + " fps, " + this.fpsTotalDurationMS / (long)this.fpsTotalFrames + " ms/f");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    @Override
    public final synchronized void setUpdateFPSFrames(int n, PrintStream printStream) {
        this.fpsUpdateFramesInterval = n;
        this.fpsOutputStream = printStream;
        this.resetFPSCounter();
    }

    @Override
    public final synchronized void resetFPSCounter() {
        this.fpsLastUpdateTimeNS = this.fpsStartTimeNS = Clock.currentNanos();
        this.fpsLastPeriodMS = 0L;
        this.fpsTotalFrames = 0;
        this.fpsLast = 0.0f;
        this.fpsTotal = 0.0f;
        this.fpsLastPeriodMS = 0L;
        this.fpsTotalDurationMS = 0L;
    }

    @Override
    public final synchronized int getUpdateFPSFrames() {
        return this.fpsUpdateFramesInterval;
    }

    @Override
    public final synchronized long getFPSStartTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.fpsStartTimeNS);
    }

    @Override
    public final synchronized long getLastFPSUpdateTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.fpsLastUpdateTimeNS);
    }

    @Override
    public final synchronized long getLastFPSPeriod() {
        return this.fpsLastPeriodMS;
    }

    @Override
    public final synchronized float getLastFPS() {
        return this.fpsLast;
    }

    @Override
    public final synchronized int getTotalFPSFrames() {
        return this.fpsTotalFrames;
    }

    @Override
    public final synchronized long getTotalFPSDuration() {
        return this.fpsTotalDurationMS;
    }

    @Override
    public final synchronized float getTotalFPS() {
        return this.fpsTotal;
    }
}

