/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.util.Bitfield;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class XVisualInfo {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] XVisualInfo_size = new int[]{40, 40, 40, 40, 40, 40, 40, 64, 48, 64};
    private static final int[] visual_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] visualid_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 8, 8, 8};
    private static final int[] screen_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 16, 12, 16};
    private static final int[] depth_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 20, 16, 20};
    private static final int[] c_class_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 24, 20, 24};
    private static final int[] red_mask_offset = new int[]{20, 20, 20, 20, 20, 20, 20, 32, 24, 32};
    private static final int[] green_mask_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 40, 28, 40};
    private static final int[] blue_mask_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 48, 32, 48};
    private static final int[] colormap_size_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 56, 36, 56};
    private static final int[] bits_per_rgb_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 60, 40, 60};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return XVisualInfo_size[mdIdx];
    }

    public static XVisualInfo create() {
        return XVisualInfo.create(Buffers.newDirectByteBuffer(XVisualInfo.size()));
    }

    public static XVisualInfo create(ByteBuffer byteBuffer) {
        return new XVisualInfo(byteBuffer);
    }

    public static XVisualInfo derefPointer(long l) {
        return XVisualInfo.create(ElementBuffer.derefPointer(XVisualInfo.size(), l, 1).getByteBuffer());
    }

    XVisualInfo(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[XVisualInfo.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final XVisualInfo setVisual(long l) {
        PointerBuffer.wrap(this.getBuffer(), visual_offset[mdIdx], 1).put(0, l);
        return this;
    }

    public final long getVisual() {
        return PointerBuffer.wrap(this.getBuffer(), visual_offset[mdIdx], 1).get(0);
    }

    public final XVisualInfo setVisualid(long l) {
        this.accessor.setLongAt(visualid_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getVisualid() {
        return this.accessor.getLongAt(visualid_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final XVisualInfo setScreen(int n) {
        this.accessor.setIntAt(screen_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public final int getScreen() {
        return this.accessor.getIntAt(screen_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final XVisualInfo setDepth(int n) {
        this.accessor.setIntAt(depth_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public final int getDepth() {
        return this.accessor.getIntAt(depth_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final XVisualInfo setC_class(int n) {
        this.accessor.setIntAt(c_class_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public final int getC_class() {
        return this.accessor.getIntAt(c_class_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final XVisualInfo setRed_mask(long l) {
        this.accessor.setLongAt(red_mask_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getRed_mask() {
        return this.accessor.getLongAt(red_mask_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final XVisualInfo setGreen_mask(long l) {
        this.accessor.setLongAt(green_mask_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getGreen_mask() {
        return this.accessor.getLongAt(green_mask_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final XVisualInfo setBlue_mask(long l) {
        this.accessor.setLongAt(blue_mask_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public final long getBlue_mask() {
        return this.accessor.getLongAt(blue_mask_offset[mdIdx], this.md.longSizeInBytes());
    }

    public final XVisualInfo setColormap_size(int n) {
        this.accessor.setIntAt(colormap_size_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public final int getColormap_size() {
        return this.accessor.getIntAt(colormap_size_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final XVisualInfo setBits_per_rgb(int n) {
        this.accessor.setIntAt(bits_per_rgb_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public final int getBits_per_rgb() {
        return this.accessor.getIntAt(bits_per_rgb_offset[mdIdx], this.md.intSizeInBytes());
    }

    public static XVisualInfo create(XVisualInfo xVisualInfo) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(xVisualInfo.getBuffer().capacity());
        XVisualInfo xVisualInfo2 = XVisualInfo.create(byteBuffer);
        xVisualInfo2.getBuffer().put(xVisualInfo.getBuffer());
        xVisualInfo2.getBuffer().rewind();
        xVisualInfo.getBuffer().rewind();
        return xVisualInfo2;
    }

    public String toString() {
        return "XVisualInfo[size " + XVisualInfo.size() + "/" + this.getBuffer().capacity() + ", visual 0x" + Long.toHexString(this.getVisual()) + ", visual-id  0x" + Long.toHexString(this.getVisualid()) + ", c-class " + this.getC_class() + ", cmap-size " + this.getColormap_size() + ", depth " + this.getDepth() + ", rgb[" + Bitfield.Util.bitCount((int)this.getRed_mask()) + ", " + Bitfield.Util.bitCount((int)this.getRed_mask()) + ", " + Bitfield.Util.bitCount((int)this.getRed_mask()) + " - " + this.getBits_per_rgb() + "]]";
    }
}

