/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.av.TimeFrameI;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;

public interface TextureSequence {
    public static final String samplerExternalOES = "samplerExternalOES";
    public static final String sampler2D = "sampler2D";

    public int getTextureTarget();

    public int getTextureUnit();

    public int[] getTextureMinMagFilter();

    public int[] getTextureWrapST();

    public boolean useARatioAdjustment();

    public void setARatioAdjustment(boolean var1);

    public boolean useARatioLetterbox();

    public Vec4f getARatioLetterboxBackColor();

    public void setARatioLetterbox(boolean var1, Vec4f var2);

    public boolean isTextureAvailable();

    public TextureFrame getLastTexture() throws IllegalStateException;

    public TextureFrame getNextTexture(GL var1) throws IllegalStateException;

    public String getRequiredExtensionsShaderStub() throws IllegalStateException;

    public String getTextureSampler2DType() throws IllegalStateException;

    public String setTextureLookupFunctionName(String var1) throws IllegalStateException;

    public String getTextureLookupFunctionName() throws IllegalStateException;

    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException;

    public String getTextureFragmentShaderHashID();

    public int getTextureFragmentShaderHashCode();

    public static void setTexCoordBBoxSimple(Texture texture, AABBox aABBox, float[] fArray, boolean bl) {
        float f;
        TextureCoords textureCoords = texture.getImageTexCoords();
        float f2 = textureCoords.right() - textureCoords.left();
        fArray[0] = aABBox.getMinX() / f2;
        fArray[2] = aABBox.getMaxX() / f2;
        if (texture.getMustFlipVertically()) {
            f = textureCoords.bottom() - textureCoords.top();
            fArray[1] = aABBox.getMaxY() / f;
            fArray[3] = aABBox.getMinY() / f;
        } else {
            f = textureCoords.top() - textureCoords.bottom();
            fArray[1] = aABBox.getMinY() / f;
            fArray[3] = aABBox.getMaxY() / f;
        }
        fArray[4] = f2;
        fArray[5] = f;
        if (bl) {
            float f3 = fArray[2] - fArray[0];
            float f4 = fArray[3] - fArray[1];
            System.err.println("XXX setTexCoordBBoxSimple:");
            System.err.println("XXX ColorTex " + texture);
            System.err.println("XXX ColorTexBBox min " + fArray[0] + "/" + fArray[1] + ", max " + fArray[2] + "/" + fArray[3] + ", dim " + f3 + " x " + f4 + ", tc-dim " + f2 + " x " + f + ", tc " + textureCoords);
        }
    }

    public static void setTexCoordBBox(Texture texture, AABBox aABBox, boolean bl, float[] fArray, boolean bl2) {
        float f;
        float f2;
        float f3;
        float f4;
        TextureCoords textureCoords = texture.getImageTexCoords();
        float f5 = aABBox.getWidth() / aABBox.getHeight();
        float f6 = texture.getAspectRatio();
        float f7 = f5 / f6;
        float f8 = textureCoords.right() - textureCoords.left();
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        if (f7 >= 1.0f) {
            if (bl) {
                f9 = aABBox.getWidth() * (1.0f - 1.0f / f7);
                f4 = f8 * 0.5f;
                f3 = f9 * f4;
                f2 = f9 * (1.0f - f4);
                fArray[0] = (aABBox.getMinX() + f3) / f8;
                fArray[2] = (aABBox.getMaxX() - f2) / f8;
                if (texture.getMustFlipVertically()) {
                    f = textureCoords.bottom() - textureCoords.top();
                    fArray[1] = aABBox.getMaxY() / f;
                    fArray[3] = aABBox.getMinY() / f;
                } else {
                    f = textureCoords.top() - textureCoords.bottom();
                    fArray[1] = aABBox.getMinY() / f;
                    fArray[3] = aABBox.getMaxY() / f;
                }
            } else {
                fArray[0] = aABBox.getMinX() / f8;
                fArray[2] = aABBox.getMaxX() / f8;
                f12 = aABBox.getHeight() * (f7 - 1.0f);
                if (texture.getMustFlipVertically()) {
                    f = textureCoords.bottom() - textureCoords.top();
                    f4 = f * 0.5f;
                    f3 = f12 * f4;
                    f2 = f12 * (1.0f - f4);
                    fArray[1] = (aABBox.getMaxY() + f2) / f;
                    fArray[3] = (aABBox.getMinY() - f3) / f;
                } else {
                    f = textureCoords.top() - textureCoords.bottom();
                    f4 = f * 0.5f;
                    f3 = f12 * f4;
                    f2 = f12 * (1.0f - f4);
                    fArray[1] = (aABBox.getMinY() - f3) / f;
                    fArray[3] = (aABBox.getMaxY() + f2) / f;
                }
            }
        } else if (bl) {
            fArray[0] = aABBox.getMinX() / f8;
            fArray[2] = aABBox.getMaxX() / f8;
            f10 = aABBox.getHeight() * (1.0f - f7);
            if (texture.getMustFlipVertically()) {
                f = textureCoords.bottom() - textureCoords.top();
                f4 = f * 0.5f;
                f3 = f10 * f4;
                f2 = f10 * (1.0f - f4);
                fArray[1] = (aABBox.getMaxY() - f2) / f;
                fArray[3] = (aABBox.getMinY() + f3) / f;
            } else {
                f = textureCoords.top() - textureCoords.bottom();
                f4 = f * 0.5f;
                f3 = f10 * f4;
                f2 = f10 * (1.0f - f4);
                fArray[1] = (aABBox.getMinY() + f3) / f;
                fArray[3] = (aABBox.getMaxY() - f2) / f;
            }
        } else {
            f11 = aABBox.getWidth() * (1.0f / f7 - 1.0f);
            f4 = f8 * 0.5f;
            f3 = f11 * f4;
            f2 = f11 * (1.0f - f4);
            fArray[0] = (aABBox.getMinX() - f3) / f8;
            fArray[2] = (aABBox.getMaxX() + f2) / f8;
            if (texture.getMustFlipVertically()) {
                f = textureCoords.bottom() - textureCoords.top();
                fArray[1] = aABBox.getMaxY() / f;
                fArray[3] = aABBox.getMinY() / f;
            } else {
                f = textureCoords.top() - textureCoords.bottom();
                fArray[1] = aABBox.getMinY() / f;
                fArray[3] = aABBox.getMaxY() / f;
            }
        }
        fArray[4] = f8;
        fArray[5] = f;
        if (bl2) {
            f4 = (float)texture.getImageWidth() / (float)texture.getWidth();
            f3 = (float)texture.getImageHeight() / (float)texture.getHeight();
            f2 = (textureCoords.right() - textureCoords.left()) / (textureCoords.bottom() - textureCoords.top());
            float f13 = f5 / f2;
            float f14 = fArray[2] - fArray[0];
            float f15 = fArray[3] - fArray[1];
            System.err.println("XXX setTexCoordBBox:");
            System.err.println("XXX ColorTex imgRatio " + f6 + ", texRatio " + f2 + ", texPixelRatio[w " + f4 + ", h " + f3 + "], " + texture);
            System.err.println("XXX ColorTexBBox lbox " + bl + ", cut " + f9 + "/" + f10 + ", ext " + f11 + "/" + f12);
            System.err.println("XXX ColorTexBBox min " + fArray[0] + "/" + fArray[1] + ", max " + fArray[2] + "/" + fArray[3] + ", dim " + f14 + " x " + f15 + ", tc-dim " + f8 + " x " + f + ", tc " + textureCoords + ", box2ImgRatio " + f7 + ", box2TexRatio " + f13);
            System.err.println("XXX Box ratio " + f5 + ", " + aABBox);
        }
    }

    public static interface TexSeqEventListener<T extends TextureSequence> {
        public void newFrameAvailable(T var1, TextureFrame var2, long var3);
    }

    public static class TextureFrame
    extends TimeFrameI {
        protected final Texture texture;

        public TextureFrame(Texture texture, int n, int n2) {
            super(n, n2);
            this.texture = texture;
        }

        public TextureFrame(Texture texture) {
            this.texture = texture;
        }

        public final Texture getTexture() {
            return this.texture;
        }

        @Override
        public String toString() {
            return "TextureFrame[pts " + this.pts + " ms, l " + this.duration + " ms, texID " + (null != this.texture ? this.texture.getTextureObject() : 0) + "]";
        }
    }
}

