/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLSubBuffer;
import com.jogamp.opencl.llb.CL;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CLBuffer<B extends Buffer>
extends CLMemory<B> {
    private List<CLSubBuffer<B>> childs;

    protected CLBuffer(CLContext cLContext, long l, long l2, int n) {
        this(cLContext, null, l, l2, n);
    }

    protected CLBuffer(CLContext cLContext, B b, long l, long l2, int n) {
        super(cLContext, b, l, l2, n);
    }

    static CLBuffer<?> create(CLContext cLContext, int n, int n2) {
        if (CLBuffer.isHostPointerFlag(n2)) {
            throw new IllegalArgumentException("no host pointer defined");
        }
        CL cL = cLContext.getPlatform().getCLBinding();
        int[] nArray = new int[1];
        long l = cL.clCreateBuffer(cLContext.ID, n2, n, null, nArray, 0);
        CLException.checkForError(nArray[0], "can not create cl buffer");
        return new CLBuffer(cLContext, n, l, n2);
    }

    static <B extends Buffer> CLBuffer<B> create(CLContext cLContext, B b, int n) {
        if (!b.isDirect()) {
            throw new IllegalArgumentException("buffer is not direct");
        }
        Buffer buffer = null;
        if (CLBuffer.isHostPointerFlag(n)) {
            buffer = b;
        }
        CL cL = cLContext.getPlatform().getCLBinding();
        int[] nArray = new int[1];
        int n2 = Buffers.sizeOfBufferElem(b) * b.limit();
        long l = cL.clCreateBuffer(cLContext.ID, n, n2, buffer, nArray, 0);
        CLException.checkForError(nArray[0], "can not create cl buffer");
        return new CLBuffer<B>(cLContext, b, n2, l, n);
    }

    public CLSubBuffer<B> createSubBuffer(int n, int n2, CLMemory.Mem ... memArray) {
        Buffer buffer;
        if (this.buffer != null) {
            buffer = Buffers.slice(this.buffer, n, n2);
            int n3 = Buffers.sizeOfBufferElem(this.buffer);
            n *= n3;
            n2 *= n3;
        } else {
            buffer = null;
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(2);
        pointerBuffer.put(0, n);
        pointerBuffer.put(1, n2);
        int n4 = CLMemory.Mem.flagsToInt(memArray);
        CL cL = this.getPlatform().getCLBinding();
        int[] nArray = new int[1];
        long l = cL.clCreateSubBuffer(this.ID, n4, 4640, pointerBuffer.getBuffer(), nArray, 0);
        CLException.checkForError(nArray[0], "can not create sub buffer");
        CLSubBuffer<Buffer> cLSubBuffer = new CLSubBuffer<Buffer>(this, n, n2, buffer, l, n4);
        if (this.childs == null) {
            this.childs = new ArrayList<CLSubBuffer<B>>();
        }
        this.childs.add(cLSubBuffer);
        return cLSubBuffer;
    }

    @Override
    public void release() {
        if (this.childs != null) {
            while (!this.childs.isEmpty()) {
                this.childs.get(0).release();
            }
        }
        super.release();
    }

    void onReleaseSubBuffer(CLSubBuffer<?> cLSubBuffer) {
        this.childs.remove(cLSubBuffer);
    }

    public List<CLSubBuffer<B>> getSubBuffers() {
        if (this.childs == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.childs);
    }

    public boolean isSubBuffer() {
        return false;
    }

    @Override
    public <T extends Buffer> CLBuffer<T> cloneWith(T t) {
        return new CLBuffer<T>(this.context, t, this.size, this.ID, this.FLAGS);
    }
}

