/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.AudioSink;
import com.jogamp.common.av.PTS;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.LFRingbuffer;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.Ringbuffer;
import com.jogamp.common.util.TSPrinter;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.ALHelpers;
import java.nio.ByteBuffer;
import jogamp.openal.Debug;

public final class ALAudioSink
implements AudioSink {
    private static final boolean DEBUG_TRACE;
    private static final TSPrinter logout;
    private static final ALC alc;
    private static final AL al;
    private static final ALExt alExt;
    private static final boolean staticsInitialized;
    private final Device device;
    private boolean hasSOFTBufferSamples;
    private boolean hasEXTMcFormats;
    private boolean hasEXTFloat32;
    private boolean hasEXTDouble;
    private boolean hasALC_thread_local_context;
    private boolean hasAL_SOFT_events;
    private boolean useAL_SOFT_events;
    private int sourceCount;
    private float defaultLatency;
    private float latency;
    private final AudioFormat nativeFormat;
    private int userMaxChannels = 8;
    private AudioFormat preferredFormat;
    private final Context context;
    private float playSpeed = 1.0f;
    private float volume = 1.0f;
    private int[] alBufferNames = null;
    private int queueSize = 0;
    private float avgFrameDuration = 0.0f;
    private Ringbuffer<ALAudioFrame> alFramesFree = null;
    private Ringbuffer<ALAudioFrame> alFramesPlaying = null;
    private volatile int alBufferBytesQueued = 0;
    private volatile int last_buffered_pts = Integer.MIN_VALUE;
    private volatile boolean playRequested = false;
    private final PTS pts = new PTS(() -> this.playRequested ? this.playSpeed : 0.0f);
    private volatile int enqueuedFrameCount;
    private final Source alSource = new Source();
    private AudioFormat chosenFormat = null;
    private int alChannelLayout;
    private int alSampleType;
    private int alFormat;
    private volatile boolean available = false;
    final ALExt.ALEVENTPROCSOFT alEventCallback = new ALExt.ALEVENTPROCSOFT(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(int n, int n2, int n3, String string, ALCcontext aLCcontext) {
            if (6564 == n && ALAudioSink.this.alSource.getID() == n2) {
                Object object = ALAudioSink.this.eventReleasedBuffersLock;
                synchronized (object) {
                    ALAudioSink.this.eventReleasedBuffers += n3;
                    ALAudioSink.this.eventReleasedBuffersLock.notifyAll();
                }
            }
        }
    };
    private final Object eventReleasedBuffersLock = new Object();
    private volatile int eventReleasedBuffers = 0;

    public static boolean isInitialized() {
        return staticsInitialized;
    }

    private static Device createDevice(String string) {
        Device device = new Device(string);
        if (!device.isValid()) {
            throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Error opening OpenAL device '" + string + "'");
        }
        return device;
    }

    public ALAudioSink() throws ALException {
        this((Device)null);
    }

    public ALAudioSink(String string) throws ALException {
        this(ALAudioSink.createDevice(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ALAudioSink(Device device) throws ALException {
        if (!staticsInitialized) {
            this.device = null;
            this.context = null;
            this.nativeFormat = DefaultFormat;
            return;
        }
        if (null == device) {
            this.device = ALAudioSink.createDevice(null);
            if (!this.device.isValid()) {
                throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Couldn't open default device: " + this.device);
            }
        } else {
            this.device = device;
            if (!this.device.open()) {
                throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Error device not open or couldn't be opened " + this.device);
            }
        }
        this.context = new Context(this.device, null);
        if (!this.context.isValid()) {
            throw new ALException(ALAudioSink.getThreadName() + ": ALAudioSink: Error creating OpenAL context " + this.context);
        }
        this.makeCurrent(true);
        try {
            this.hasSOFTBufferSamples = al.alIsExtensionPresent("AL_SOFT_buffer_samples");
            this.hasEXTMcFormats = al.alIsExtensionPresent("AL_EXT_MCFORMATS");
            this.hasEXTFloat32 = al.alIsExtensionPresent("AL_EXT_FLOAT32");
            this.hasEXTDouble = al.alIsExtensionPresent("AL_EXT_DOUBLE");
            this.hasALC_thread_local_context = this.context.hasALC_thread_local_context;
            this.useAL_SOFT_events = this.hasAL_SOFT_events = al.alIsExtensionPresent("AL_SOFT_events");
            int n = 1;
            AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
            int n2 = ALAudioSink.DefaultFormat.sampleRate;
            int[] nArray = new int[]{0};
            alc.alcGetIntegerv(this.device.getALDevice(), 4103, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_FREQUENCY", DEBUG, false) || 0 == nArray[0]) {
                if (DEBUG) {
                    logout.println("ALAudioSink.queryDefaultSampleRate: failed, using default " + n2);
                }
            } else {
                n2 = nArray[0];
                if (DEBUG) {
                    logout.println("ALAudioSink.queryDefaultSampleRate: OK " + n2);
                }
            }
            nArray[0] = 0;
            alc.alcGetIntegerv(this.device.getALDevice(), 4112, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_MONO_SOURCES", DEBUG, false)) {
                this.sourceCount = -1;
                if (DEBUG) {
                    logout.println("ALAudioSink.queryMonoSourceCount: failed");
                }
            } else {
                this.sourceCount = nArray[0];
            }
            nArray[0] = 0;
            alc.alcGetIntegerv(this.device.getALDevice(), 4104, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_FREQUENCY", DEBUG, false) || 0 == nArray[0]) {
                this.defaultLatency = 0.02f;
                if (DEBUG) {
                    logout.println("ALAudioSink.queryDefaultRefreshRate: failed");
                }
            } else {
                this.defaultLatency = 1.0f / (float)nArray[0];
                if (DEBUG) {
                    logout.println("ALAudioSink.queryDefaultRefreshRate: OK " + nArray[0] + " Hz = " + 1000.0f * this.defaultLatency + " ms");
                }
            }
            this.preferredFormat = this.nativeFormat = new AudioFormat(n2, ALAudioSink.DefaultFormat.sampleSize, this.getMaxSupportedChannels(false), ALAudioSink.DefaultFormat.signed, ALAudioSink.DefaultFormat.fixedP, ALAudioSink.DefaultFormat.planar, ALAudioSink.DefaultFormat.littleEndian);
            if (DEBUG) {
                nArray = new int[]{0, 0};
                System.out.println("ALAudioSink: OpenAL Version: " + al.alGetString(45058));
                System.out.println("ALAudioSink: OpenAL Extensions: " + al.alGetString(45060));
                AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
                System.out.println("ALAudioSink: Null device OpenALC:");
                alc.alcGetIntegerv(null, 4096, 1, nArray, 0);
                alc.alcGetIntegerv(null, 4097, 1, nArray, 1);
                System.out.println("  Version: " + nArray[0] + "." + nArray[1]);
                System.out.println("  Extensions: " + alc.alcGetString(null, 4102));
                AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
                System.out.println("ALAudioSink: Device " + this.device + " OpenALC:");
                alc.alcGetIntegerv(this.device.getALDevice(), 4096, 1, nArray, 0);
                alc.alcGetIntegerv(this.device.getALDevice(), 4097, 1, nArray, 1);
                System.out.println("  Version: " + nArray[0] + "." + nArray[1]);
                System.out.println("  Extensions: " + alc.alcGetString(this.device.getALDevice(), 4102));
                System.out.println("ALAudioSink: hasSOFTBufferSamples " + this.hasSOFTBufferSamples);
                System.out.println("ALAudioSink: hasEXTMcFormats " + this.hasEXTMcFormats);
                System.out.println("ALAudioSink: hasEXTFloat32 " + this.hasEXTFloat32);
                System.out.println("ALAudioSink: hasEXTDouble " + this.hasEXTDouble);
                System.out.println("ALAudioSink: hasALC_thread_local_context " + this.hasALC_thread_local_context);
                System.out.println("ALAudioSink: hasAL_SOFT_events " + this.hasAL_SOFT_events);
                System.out.println("ALAudioSink: maxSupportedChannels " + this.getMaxSupportedChannels(false));
                System.out.println("ALAudioSink: nativeAudioFormat " + this.nativeFormat);
                System.out.println("ALAudioSink: defaultMixerRefreshRate " + 1000.0f * this.defaultLatency + " ms, " + 1.0f / this.defaultLatency + " Hz");
                AudioSystem3D.checkError(this.device, "init." + n++, DEBUG, false);
            }
            if (DEBUG) {
                logout.println("ALAudioSink: Using device: " + this.device);
            }
            this.available = true;
        }
        finally {
            this.release(true);
        }
    }

    public static final AL getAL() {
        return al;
    }

    public static final ALC getALC() {
        return alc;
    }

    public static final ALExt getALExt() {
        return alExt;
    }

    public final Device getDevice() {
        return this.device;
    }

    public final Context getContext() {
        return this.context;
    }

    public final Source getSource() {
        return this.alSource;
    }

    public final boolean hasSOFTBufferSamples() {
        return this.hasSOFTBufferSamples;
    }

    public final boolean hasEXTMcFormats() {
        return this.hasEXTMcFormats;
    }

    public final boolean hasEXTFloat32() {
        return this.hasEXTFloat32;
    }

    public final boolean hasEXTDouble() {
        return this.hasEXTDouble;
    }

    public final boolean hasALCThreadLocalContext() {
        return this.hasALC_thread_local_context;
    }

    public final boolean hasSOFTEvents() {
        return this.hasAL_SOFT_events;
    }

    public final void setUseSOFTEvents(boolean bl) {
        this.useAL_SOFT_events = bl;
    }

    public final boolean getUseSOFTEvents(boolean bl) {
        return this.useAL_SOFT_events;
    }

    public final int getALChannelLayout() {
        return this.alChannelLayout;
    }

    public final int getALSampleType() {
        return this.alSampleType;
    }

    public final int getALFormat() {
        return this.alFormat;
    }

    @Override
    public final boolean makeCurrent(boolean bl) {
        return this.context.makeCurrent(bl);
    }

    @Override
    public final boolean release(boolean bl) {
        return this.context.release(bl);
    }

    private final void destroyContext() {
        this.context.destroy();
    }

    public final String toString() {
        int n = this.context != null ? this.context.hashCode() : 0;
        int n2 = this.alFramesPlaying != null ? this.alFramesPlaying.size() : 0;
        int n3 = this.alFramesFree != null ? this.alFramesFree.size() : 0;
        return String.format("ALAudioSink[playReq %b, device '%s', ctx 0x%x, alSource %d, chosen %s, al[chan %s, type %s, fmt 0x%x, tlc %b, soft[buffer %b, events %b/%b], latency %.2f/%.2f ms, sources %d], playSpeed %.2f, play[used %d, apts %d], queued[free %d, apts %d, %.1f ms, %d bytes, avg %.2f ms/frame, max %d ms]]", this.playRequested, this.device.getName(), n, this.alSource.getID(), this.chosenFormat, ALHelpers.alChannelLayoutName(this.alChannelLayout), ALHelpers.alSampleTypeName(this.alSampleType), this.alFormat, this.hasALC_thread_local_context, this.hasSOFTBufferSamples, this.useAL_SOFT_events, this.hasAL_SOFT_events, Float.valueOf(1000.0f * this.latency), Float.valueOf(1000.0f * this.defaultLatency), this.sourceCount, Float.valueOf(this.playSpeed), n2, this.getPTS().getLast(), n3, this.getLastBufferedPTS(), Float.valueOf(1000.0f * this.getQueuedDuration()), this.alBufferBytesQueued, Float.valueOf(1000.0f * this.avgFrameDuration), this.queueSize);
    }

    public final String getPerfString() {
        int n = this.alFramesPlaying != null ? this.alFramesPlaying.size() : 0;
        int n2 = this.alFramesFree != null ? this.alFramesFree.size() : 0;
        return String.format("play[used %d, apts %d], queued[free %d, apts %d, %.1f ms, %d bytes, avg %.2f ms/frame, max %d ms]", n, this.getPTS().getLast(), n2, this.getLastBufferedPTS(), Float.valueOf(1000.0f * this.getQueuedDuration()), this.alBufferBytesQueued, Float.valueOf(1000.0f * this.avgFrameDuration), this.queueSize);
    }

    @Override
    public int getSourceCount() {
        return this.sourceCount;
    }

    @Override
    public float getDefaultLatency() {
        return this.defaultLatency;
    }

    @Override
    public float getLatency() {
        return this.latency;
    }

    @Override
    public final AudioFormat getNativeFormat() {
        if (!staticsInitialized) {
            return null;
        }
        return this.nativeFormat;
    }

    @Override
    public final AudioFormat getPreferredFormat() {
        if (!staticsInitialized) {
            return null;
        }
        return this.preferredFormat;
    }

    @Override
    public final void setChannelLimit(int n) {
        this.userMaxChannels = Math.min(8, Math.max(1, n));
        this.preferredFormat = new AudioFormat(this.nativeFormat.sampleRate, this.nativeFormat.sampleSize, this.getMaxSupportedChannels(true), this.nativeFormat.signed, this.nativeFormat.fixedP, this.nativeFormat.planar, this.nativeFormat.littleEndian);
        if (DEBUG) {
            System.out.println("ALAudioSink: channelLimit " + this.userMaxChannels + ", preferredFormat " + this.preferredFormat);
        }
    }

    private final int getMaxSupportedChannels(boolean bl) {
        if (!staticsInitialized) {
            return 0;
        }
        int n = this.hasEXTMcFormats || this.hasSOFTBufferSamples ? 8 : 2;
        return bl ? Math.min(this.userMaxChannels, n) : n;
    }

    @Override
    public final boolean isSupported(AudioFormat audioFormat) {
        if (!staticsInitialized) {
            return false;
        }
        if (audioFormat.planar != this.preferredFormat.planar || audioFormat.littleEndian != this.preferredFormat.littleEndian || audioFormat.sampleRate > this.preferredFormat.sampleRate || audioFormat.channelCount > this.preferredFormat.channelCount) {
            if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.isSupported: NO.0 " + audioFormat);
            }
            return false;
        }
        int n = ALHelpers.getALFormat(audioFormat, al, alExt, this.hasSOFTBufferSamples, this.hasEXTMcFormats, this.hasEXTFloat32, this.hasEXTDouble);
        if (0 != n) {
            if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.isSupported: OK " + audioFormat + ", alFormat " + ALAudioSink.toHexString(n));
            }
            return true;
        }
        if (DEBUG) {
            logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.isSupported: NO.1 " + audioFormat);
        }
        return false;
    }

    @Override
    public final boolean init(AudioFormat audioFormat, int n, int n2) {
        if (!staticsInitialized) {
            return false;
        }
        int n3 = ALHelpers.getDefaultALChannelLayout(audioFormat.channelCount);
        int n4 = ALHelpers.getALSampleType(audioFormat.sampleSize, audioFormat.signed, audioFormat.fixedP);
        int n5 = 0 != n3 && 0 != n4 ? ALHelpers.getALFormat(n3, n4, al, alExt, this.hasSOFTBufferSamples, this.hasEXTMcFormats, this.hasEXTFloat32, this.hasEXTDouble) : 0;
        if (0 == n5) {
            if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.init1: Not supported: " + audioFormat + ", " + this.toString());
            }
            return false;
        }
        return this.initImpl(audioFormat, n3, n4, n5, (float)n / 1000.0f, n2);
    }

    public final boolean init(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        AudioFormat audioFormat = ALHelpers.getAudioFormat(n, n2, n3, n4, n5);
        if (null == audioFormat) {
            if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.init2: Invalid AL channelLayout " + ALAudioSink.toHexString(n) + ", sampleType " + ALAudioSink.toHexString(n2) + ", format " + ALAudioSink.toHexString(n3) + " or sample[rate " + n4 + ", size " + n5 + "]; " + this.toString());
            }
            return false;
        }
        return this.initImpl(audioFormat, n, n2, n3, (float)n6 / 1000.0f, n7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean initImpl(AudioFormat audioFormat, int n, int n2, int n3, float f, int n4) {
        this.alChannelLayout = n;
        this.alSampleType = n2;
        this.alFormat = n3;
        this.makeCurrent(true);
        if (this.context.getLockCount() != 1) {
            this.release(false);
            throw new ALException("init() must be called w/o makeCurrent: lockCount " + this.context + ", " + this);
        }
        boolean bl = true;
        try {
            this.stopImpl(true);
            this.destroySource();
            this.destroyBuffers();
            f = f >= 0.001f ? f : 0.032f;
            int n5 = Math.round(1.0f / this.defaultLatency);
            int n6 = Math.round(1.0f / f);
            if (f < this.defaultLatency) {
                if (DEBUG) {
                    logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.init: Re-create context as latency exp " + 1000.0f * f + " ms (" + n6 + " Hz) < default " + 1000.0f * this.defaultLatency + " ms (" + n5 + " Hz)");
                }
                if (!this.context.recreate(new int[]{4104, n6})) {
                    logout.println(ALAudioSink.getThreadName() + ": ALAudioSink: Error creating OpenAL context " + this.context);
                    boolean bl2 = false;
                    return bl2;
                }
            } else if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.init: Keep context, latency exp " + 1000.0f * f + " ms (" + n6 + " Hz) >= default " + 1000.0f * this.defaultLatency + " ms (" + n5 + " Hz)");
            }
            int[] nArray = new int[]{0};
            alc.alcGetIntegerv(this.device.getALDevice(), 4104, 1, nArray, 0);
            if (AudioSystem3D.checkError(this.device, "read ALC_FREQUENCY", DEBUG, false) || 0 == nArray[0]) {
                this.latency = this.defaultLatency;
                if (DEBUG) {
                    logout.println("ALAudioSink.queryRefreshRate: failed, claiming default " + 1000.0f * this.latency + " ms");
                }
            } else {
                this.latency = 1.0f / (float)nArray[0];
                if (DEBUG) {
                    logout.println("ALAudioSink.queryRefreshRate: OK " + nArray[0] + " Hz = " + 1000.0f * this.latency + " ms");
                }
            }
            if (!this.createSource()) {
                this.destroyContext();
                bl = false;
                boolean bl3 = false;
                return bl3;
            }
            int n7 = audioFormat.getFrameCount(n4 > 0 ? (float)n4 / 1000.0f : 0.512f, f);
            this.alBufferNames = new int[n7];
            al.alGenBuffers(n7, this.alBufferNames, 0);
            if (AudioSystem3D.checkALError("alGenBuffers", true, false)) {
                this.alBufferNames = null;
                this.destroySource();
                this.destroyContext();
                bl = false;
                n6 = 0;
                return n6 != 0;
            }
            ALAudioFrame[] aLAudioFrameArray = new ALAudioFrame[n7];
            for (int i = 0; i < n7; ++i) {
                aLAudioFrameArray[i] = new ALAudioFrame(this.alBufferNames[i]);
            }
            this.alFramesFree = new LFRingbuffer<ALAudioFrame>(aLAudioFrameArray);
            this.alFramesPlaying = new LFRingbuffer<ALAudioFrame>(ALAudioFrame[].class, n7);
            int n8 = this.queueSize = n4 > 0 ? n4 : 512;
            if (DEBUG_TRACE) {
                this.alFramesFree.dump(System.err, "Avail-init");
                this.alFramesPlaying.dump(System.err, "Playi-init");
            }
            if (this.hasAL_SOFT_events && this.useAL_SOFT_events) {
                alExt.alEventCallbackSOFT(this.alEventCallback, this.context.getALContext());
                alExt.alEventControlSOFT(1, new int[]{6564}, 0, true);
            }
        }
        finally {
            if (bl) {
                this.release(false);
            }
        }
        this.chosenFormat = audioFormat;
        this.avgFrameDuration = this.latency;
        if (DEBUG) {
            logout.println(ALAudioSink.getThreadName() + ": ALAudioSink.init: OK " + audioFormat + ", " + this.toString());
        }
        return true;
    }

    @Override
    public final AudioFormat getChosenFormat() {
        return this.chosenFormat;
    }

    private void destroyBuffers() {
        if (!staticsInitialized) {
            return;
        }
        if (null != this.alBufferNames) {
            block4: {
                try {
                    al.alDeleteBuffers(this.alBufferNames.length, this.alBufferNames, 0);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    logout.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.alFramesFree.clear();
            this.alFramesFree = null;
            this.alFramesPlaying.clear();
            this.alFramesPlaying = null;
            this.alBufferBytesQueued = 0;
            this.alBufferNames = null;
        }
    }

    private void destroySource() {
        if (!this.alSource.isValid()) {
            return;
        }
        this.alSource.delete();
    }

    private boolean createSource() {
        if (this.alSource.isValid()) {
            return true;
        }
        return this.alSource.create();
    }

    @Override
    public final void destroy() {
        if (!this.available) {
            return;
        }
        this.available = false;
        if (null != this.context) {
            this.makeCurrent(true);
            if (this.hasAL_SOFT_events) {
                alExt.alEventControlSOFT(3, new int[]{6564, 6565, 6566}, 0, false);
                alExt.alEventCallbackSOFT(null, this.context.getALContext());
            }
        }
        try {
            this.stopImpl(true);
            this.destroySource();
            this.destroyBuffers();
        }
        finally {
            this.destroyContext();
        }
        this.device.close();
        this.chosenFormat = null;
    }

    @Override
    public final boolean isAvailable() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int waitForReleasedEvent(long l, boolean bl, int n) {
        if (this.alBufferBytesQueued == 0) {
            return 0;
        }
        int n2 = this.alFramesPlaying.size();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            Object object = this.eventReleasedBuffersLock;
            synchronized (object) {
                while (bl && this.alBufferBytesQueued > 0 && this.eventReleasedBuffers < n) {
                    ++n3;
                    try {
                        this.eventReleasedBuffersLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                int n6 = this.eventReleasedBuffers;
                int n7 = this.alSource.getBuffersProcessed();
                n5 = Math.min(n6, n7);
                this.eventReleasedBuffers = 0;
                if (DEBUG) {
                    n4 = (int)((long)n4 + (Clock.currentMillis() - l));
                    if (bl || n5 > 0) {
                        String string = n5 != n6 ? " ** Warning ** " : "";
                        logout.println("ALAudioSink.DeqEvent[" + n3 + "]: released " + n5 + string + " [enqeueud " + n2 + ", event " + n6 + ", query " + n7 + "], req " + n + ", slept " + n4 + " ms, free total " + this.alFramesFree.size());
                    }
                }
            }
        } while (bl && this.alBufferBytesQueued > 0 && n5 < n);
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int waitForReleasedPoll(boolean bl, int n) {
        if (this.alBufferBytesQueued == 0) {
            return 0;
        }
        long l = Math.round((double)n * 1000.0 * (double)this.avgFrameDuration);
        int n2 = 0;
        long l2 = 0L;
        boolean bl2 = true;
        int n3 = 0;
        do {
            n3 = this.alSource.getBuffersProcessed();
            if (!bl || n3 >= n) continue;
            ++n2;
            int n4 = Math.max(2, Math.min(300, Math.round((float)(n - n3) * 1000.0f * this.avgFrameDuration))) - 1;
            if (l2 + (long)n4 + 1L <= l) {
                if (DEBUG) {
                    logout.println("ALAudioSink: DeqPoll[" + n2 + "].1:released " + n3 + "/" + n + ", sleep " + n4 + "/" + l2 + "/" + l + " ms, " + this.getPerfString() + ", state " + ALHelpers.alSourceStateString(this.getSourceState(false)));
                }
                this.release(true);
                try {
                    Thread.sleep(n4);
                    l2 += (long)n4;
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.makeCurrent(true);
                }
            } else {
                if (DEBUG && bl2) {
                    logout.println("ALAudioSink: DeqPoll[" + n2 + "].2:released " + n3 + "/" + n + ", sleep " + n4 + "->1/" + l2 + "/" + l + " ms, " + this.getPerfString() + ", state " + ALHelpers.alSourceStateString(this.getSourceState(false)));
                    bl2 = false;
                }
                this.release(true);
                try {
                    Thread.sleep(1L);
                    ++l2;
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.makeCurrent(true);
                }
            }
        } while (bl && this.alBufferBytesQueued > 0 && n3 < n);
        return n3;
    }

    private final int dequeueBuffer(boolean bl, int n) {
        long l = Clock.currentMillis();
        int n2 = this.hasAL_SOFT_events && this.useAL_SOFT_events ? this.waitForReleasedEvent(l, bl, n) : this.waitForReleasedPoll(bl, n);
        long l2 = Clock.currentMillis();
        if (n2 > 0) {
            int[] nArray = new int[n2];
            this.alSource.unqueueBuffers(nArray);
            for (int i = 0; i < n2; ++i) {
                ALAudioFrame aLAudioFrame = this.alFramesPlaying.get();
                if (null == aLAudioFrame) {
                    throw new InternalError("Internal Error: " + this);
                }
                if (aLAudioFrame.alBuffer != nArray[i]) {
                    this.alFramesFree.dump(System.err, "Avail-deq02-post");
                    this.alFramesPlaying.dump(System.err, "Playi-deq02-post");
                    throw new InternalError("Buffer name mismatch: dequeued: " + nArray[i] + ", released " + aLAudioFrame + ", " + this);
                }
                this.alBufferBytesQueued -= aLAudioFrame.getByteSize();
                this.pts.set(l2, aLAudioFrame.getPTS());
                if (!this.alFramesFree.put(aLAudioFrame)) {
                    throw new InternalError("Internal Error: " + this);
                }
                if (!DEBUG_TRACE) continue;
                logout.println("<< [al " + nArray[i] + ", q " + aLAudioFrame.alBuffer + "] <- " + this.getPerfString() + " @ " + ALAudioSink.getThreadName());
            }
            if (DEBUG) {
                logout.println("ALAudioSink.Dequeued: " + (l2 - l) + "ms , released " + n2 + "/" + n + ", " + this.getPerfString() + ", state " + ALHelpers.alSourceStateString(this.getSourceState(false)));
            }
        }
        return n2;
    }

    private final void dequeueForceAll() {
        if (DEBUG_TRACE) {
            logout.println("<   _FLUSH_  <- " + this.getPerfString() + " @ " + ALAudioSink.getThreadName());
        }
        int n = 0;
        al.alSourcei(this.alSource.getID(), 4105, 0);
        if (DEBUG_TRACE) {
            n = this.alSource.getBuffersProcessed();
        }
        int n2 = al.alGetError();
        while (!this.alFramesPlaying.isEmpty()) {
            ALAudioFrame aLAudioFrame = this.alFramesPlaying.get();
            if (null == aLAudioFrame) {
                throw new InternalError("Internal Error: " + this);
            }
            this.alBufferBytesQueued -= aLAudioFrame.getByteSize();
            if (this.alFramesFree.put(aLAudioFrame)) continue;
            throw new InternalError("Internal Error: " + this);
        }
        this.alBufferBytesQueued = 0;
        this.last_buffered_pts = Integer.MIN_VALUE;
        this.pts.set(0L, Integer.MIN_VALUE);
        if (DEBUG_TRACE) {
            logout.println("<<  _FLUSH_  [al " + n + ", err " + ALAudioSink.toHexString(n2) + "] <- " + this.getPerfString() + " @ " + ALAudioSink.getThreadName());
            ExceptionUtils.dumpStack(System.err);
        }
    }

    @Override
    public final PTS updateQueue() {
        if (!this.available || null == this.chosenFormat) {
            return this.pts;
        }
        this.makeCurrent(true);
        try {
            this.dequeueBuffer(false, 1);
        }
        finally {
            this.release(true);
        }
        return this.pts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AudioSink.AudioFrame enqueueData(int n, ByteBuffer byteBuffer, int n2) {
        ALAudioFrame aLAudioFrame;
        if (!this.available || null == this.chosenFormat) {
            return null;
        }
        this.makeCurrent(true);
        try {
            int n3;
            char c;
            int n4 = DEBUG ? this.getSourceState(false) : 0;
            float f = this.chosenFormat.getBytesDuration(n2);
            int n5 = this.alFramesPlaying.size();
            if (n5 > 2) {
                float f2 = this.chosenFormat.getBytesDuration(this.alBufferBytesQueued);
                this.avgFrameDuration = f2 / (float)n5;
                c = '*';
            } else {
                c = '_';
            }
            if (this.alFramesFree.isEmpty() || n5 > 2) {
                if (DEBUG) {
                    logout.printf("ALAudioSink.DequeuSoft" + c + ": %.2f ms, queued %d, %s%n", Float.valueOf(1000.0f * f), n5, this.getPerfString());
                }
                this.dequeueBuffer(false, 1);
            }
            n5 = this.alFramesPlaying.size();
            if (this.alFramesFree.isEmpty() && this.isPlayingImpl()) {
                int n6 = Math.max(1, n5 / 3);
                if (DEBUG) {
                    logout.printf("ALAudioSink.DequeuHard" + c + ": %.2f ms, req %d, queued %d, %s%n", Float.valueOf(1000.0f * f), n6, n5, this.getPerfString());
                }
                this.dequeueBuffer(true, n6);
            }
            if (null == (aLAudioFrame = this.alFramesFree.get())) {
                this.alFramesFree.dump(System.err, "Avail");
                throw new InternalError("Internal Error: avail.get null " + this.alFramesFree + ", " + this);
            }
            aLAudioFrame.setPTS(n);
            aLAudioFrame.setDuration(Math.round(1000.0f * f));
            aLAudioFrame.setByteSize(n2);
            if (!this.alFramesPlaying.put(aLAudioFrame)) {
                throw new InternalError("Internal Error: " + this);
            }
            this.last_buffered_pts = n;
            int[] nArray = new int[]{aLAudioFrame.alBuffer};
            if (this.hasSOFTBufferSamples) {
                n3 = this.chosenFormat.getBytesSampleCount(n2) / this.chosenFormat.channelCount;
                alExt.alBufferSamplesSOFT(aLAudioFrame.alBuffer, this.chosenFormat.sampleRate, this.alFormat, n3, this.alChannelLayout, this.alSampleType, byteBuffer);
            } else {
                al.alBufferData(aLAudioFrame.alBuffer, this.alFormat, byteBuffer, n2, this.chosenFormat.sampleRate);
            }
            this.alSource.queueBuffers(nArray);
            this.alBufferBytesQueued += n2;
            ++this.enqueuedFrameCount;
            if (DEBUG_TRACE) {
                logout.println(">> " + aLAudioFrame.alBuffer + " -> " + this.getPerfString() + " @ " + ALAudioSink.getThreadName());
            }
            if (DEBUG) {
                n3 = this.getSourceState(false);
                this.playImpl();
                int n7 = this.getSourceState(false);
                if (n4 != n3 || n4 != n7 || n3 != n7) {
                    logout.printf("ALAudioSink.Enqueued   : %.2f ms, %s, state* %s -> %s -> %s; %s bytes%n", Float.valueOf(1000.0f * f), this.getPerfString(), ALHelpers.alSourceStateString(n4), ALHelpers.alSourceStateString(n3), ALHelpers.alSourceStateString(n7), n2);
                } else {
                    logout.printf("ALAudioSink.Enqueued   : %.2f ms, %s, state %s; %d bytes%n", Float.valueOf(1000.0f * f), this.getPerfString(), ALHelpers.alSourceStateString(n7), n2);
                }
            } else {
                this.playImpl();
            }
        }
        finally {
            this.release(true);
        }
        return aLAudioFrame;
    }

    @Override
    public final boolean isPlaying() {
        if (!this.available || null == this.chosenFormat) {
            return false;
        }
        if (this.playRequested) {
            this.makeCurrent(true);
            try {
                boolean bl = this.isPlayingImpl();
                return bl;
            }
            finally {
                this.release(true);
            }
        }
        return false;
    }

    private final boolean isPlayingImpl() {
        if (this.playRequested) {
            return 4114 == this.getSourceState(false);
        }
        return false;
    }

    private final int getSourceState(boolean bl) {
        if (!this.alSource.isValid()) {
            String string = ALAudioSink.getThreadName() + ": getSourceState: invalid " + this.alSource;
            if (bl) {
                if (DEBUG) {
                    logout.println(string);
                }
                return 0;
            }
            throw new ALException(string);
        }
        int[] nArray = new int[]{0};
        al.alGetSourcei(this.alSource.getID(), 4112, nArray, 0);
        if (AudioSystem3D.checkALError("alGetSourcei", true, false)) {
            String string = ALAudioSink.getThreadName() + ": Error while querying SOURCE_STATE. " + this;
            if (bl) {
                if (DEBUG) {
                    logout.println(string);
                }
                return 0;
            }
            throw new ALException(string);
        }
        return nArray[0];
    }

    @Override
    public final void play() {
        if (!this.available || null == this.chosenFormat) {
            return;
        }
        this.playRequested = true;
        this.makeCurrent(true);
        try {
            this.playImpl();
            if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink: play, state " + ALHelpers.alSourceStateString(this.getSourceState(false)) + ", " + this);
            }
        }
        finally {
            this.release(true);
        }
    }

    private final void playImpl() {
        if (this.playRequested && 4114 != this.getSourceState(false)) {
            this.alSource.play();
            AudioSystem3D.checkALError("alSourcePlay", true, true);
        }
    }

    @Override
    public final void pause() {
        if (!this.available || null == this.chosenFormat) {
            return;
        }
        if (this.playRequested) {
            this.makeCurrent(true);
            try {
                this.pauseImpl();
                if (DEBUG) {
                    logout.println(ALAudioSink.getThreadName() + ": ALAudioSink: pause, state " + ALHelpers.alSourceStateString(this.getSourceState(false)) + ", " + this);
                }
            }
            finally {
                this.release(true);
            }
        }
    }

    private final void pauseImpl() {
        if (this.isPlayingImpl()) {
            this.playRequested = false;
            this.alSource.pause();
            AudioSystem3D.checkALError("alSourcePause", true, true);
        }
    }

    private final void stopImpl(boolean bl) {
        if (!this.alSource.isValid()) {
            return;
        }
        if (4116 != this.getSourceState(bl)) {
            this.playRequested = false;
            this.alSource.stop();
            if (AudioSystem3D.checkALError("alSourcePause", true, false)) {
                String string = "Error while stopping. " + this;
                if (bl) {
                    if (DEBUG) {
                        logout.println(ALAudioSink.getThreadName() + ": " + string);
                    }
                } else {
                    throw new ALException(ALAudioSink.getThreadName() + ": Error while stopping. " + this);
                }
            }
        }
    }

    @Override
    public final float getPlaySpeed() {
        return this.playSpeed;
    }

    @Override
    public final boolean setPlaySpeed(float f) {
        if (!this.available || null == this.chosenFormat) {
            return false;
        }
        this.makeCurrent(true);
        try {
            if (Math.abs(1.0f - f) < 0.01f) {
                f = 1.0f;
            }
            if (0.5f <= f && f <= 2.0f) {
                this.playSpeed = f;
                this.alSource.setPitch(this.playSpeed);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.release(true);
        }
        return false;
    }

    @Override
    public final float getVolume() {
        return this.volume;
    }

    private static final float clipAudioVolume(float f) {
        if (f < 0.01f) {
            return 0.0f;
        }
        if (Math.abs(1.0f - f) < 0.01f) {
            return 1.0f;
        }
        return f;
    }

    @Override
    public final boolean setVolume(float f) {
        if (!this.available || null == this.chosenFormat) {
            return false;
        }
        this.makeCurrent(true);
        try {
            f = ALAudioSink.clipAudioVolume(f);
            if (0.0f <= f && f <= 1.0f) {
                this.volume = f;
                this.alSource.setGain(f);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.release(true);
        }
        return false;
    }

    @Override
    public final void flush() {
        if (!this.available || null == this.chosenFormat) {
            return;
        }
        this.makeCurrent(true);
        try {
            this.stopImpl(false);
            this.dequeueForceAll();
            if (this.alBufferNames.length != this.alFramesFree.size() || this.alFramesPlaying.size() != 0) {
                throw new InternalError("XXX: " + this);
            }
            if (DEBUG) {
                logout.println(ALAudioSink.getThreadName() + ": ALAudioSink: flush, state " + ALHelpers.alSourceStateString(this.getSourceState(false)) + ", " + this);
            }
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public final int getEnqueuedFrameCount() {
        return this.enqueuedFrameCount;
    }

    @Override
    public final int getFrameCount() {
        return null != this.alBufferNames ? this.alBufferNames.length : 0;
    }

    @Override
    public final int getQueuedFrameCount() {
        if (!this.available || null == this.chosenFormat) {
            return 0;
        }
        return this.alFramesPlaying.size();
    }

    @Override
    public final int getFreeFrameCount() {
        if (!this.available || null == this.chosenFormat) {
            return 0;
        }
        return this.alFramesFree.size();
    }

    @Override
    public final int getQueuedByteCount() {
        if (!this.available || null == this.chosenFormat) {
            return 0;
        }
        return this.alBufferBytesQueued;
    }

    @Override
    public final float getQueuedDuration() {
        if (!this.available || null == this.chosenFormat) {
            return 0.0f;
        }
        return this.chosenFormat.getBytesDuration(this.alBufferBytesQueued);
    }

    @Override
    public float getAvgFrameDuration() {
        return this.avgFrameDuration;
    }

    @Override
    public final PTS getPTS() {
        return this.pts;
    }

    @Override
    public final int getLastBufferedPTS() {
        return this.last_buffered_pts;
    }

    private static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private static final String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        Debug.initSingleton();
        DEBUG_TRACE = PropertyAccess.isPropertyDefined("joal.debug.AudioSink.trace", true);
        logout = DEBUG || DEBUG_TRACE ? TSPrinter.stderr() : null;
        alc = AudioSystem3D.getALC();
        al = AudioSystem3D.getAL();
        alExt = AudioSystem3D.getALExt();
        staticsInitialized = AudioSystem3D.isAvailable();
    }

    static class ALAudioFrame
    extends AudioSink.AudioFrame {
        private final int alBuffer;

        ALAudioFrame(int n) {
            this.alBuffer = n;
        }

        public ALAudioFrame(int n, int n2, int n3, int n4) {
            super(n2, n3, n4);
            this.alBuffer = n;
        }

        public final int getALBuffer() {
            return this.alBuffer;
        }

        @Override
        public String toString() {
            return "ALAudioFrame[pts " + this.pts + " ms, l " + this.duration + " ms, " + this.byteSize + " bytes, buffer " + this.alBuffer + "]";
        }
    }
}

