/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.aromaticity.AromaticType;
import org.openscience.cdk.aromaticity.AromaticTypeMatcher;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

final class AromaticTypeModel
extends ElectronDonation {
    static final List<Map.Entry<AromaticType, Integer>> MDL = Arrays.asList(AromaticTypeModel.entry(AromaticType.C2_MINUS, 1), AromaticTypeModel.entry(AromaticType.C2_PLUS, 1), AromaticTypeModel.entry(AromaticType.C3, 1), AromaticTypeModel.entry(AromaticType.N2, 1), AromaticTypeModel.entry(AromaticType.N3_OXIDE, 1), AromaticTypeModel.entry(AromaticType.N3_PLUS, 1));
    static final List<Map.Entry<AromaticType, Integer>> CDK_1x = Arrays.asList(AromaticTypeModel.entry(AromaticType.C2_MINUS, 1), AromaticTypeModel.entry(AromaticType.C2_PLUS, 1), AromaticTypeModel.entry(AromaticType.C3, 1), AromaticTypeModel.entry(AromaticType.C3_MINUS, 2), AromaticTypeModel.entry(AromaticType.C3_PLUS, 0), AromaticTypeModel.entry(AromaticType.N2, 1), AromaticTypeModel.entry(AromaticType.N2_MINUS, 2), AromaticTypeModel.entry(AromaticType.N3, 2), AromaticTypeModel.entry(AromaticType.N3_OXIDE, 1), AromaticTypeModel.entry(AromaticType.N3_OXIDE_PLUS, 1), AromaticTypeModel.entry(AromaticType.N3_PLUS, 1), AromaticTypeModel.entry(AromaticType.O2, 2), AromaticTypeModel.entry(AromaticType.O2_PLUS, 1), AromaticTypeModel.entry(AromaticType.P2, 1), AromaticTypeModel.entry(AromaticType.P2_MINUS, 2), AromaticTypeModel.entry(AromaticType.P3, 2), AromaticTypeModel.entry(AromaticType.P4, 1), AromaticTypeModel.entry(AromaticType.P3_OXIDE, 1), AromaticTypeModel.entry(AromaticType.P3_OXIDE_PLUS, 1), AromaticTypeModel.entry(AromaticType.P3_PLUS, 1), AromaticTypeModel.entry(AromaticType.S2, 2), AromaticTypeModel.entry(AromaticType.S2_CUML, 2), AromaticTypeModel.entry(AromaticType.S3, 1), AromaticTypeModel.entry(AromaticType.S3_PLUS, 0), AromaticTypeModel.entry(AromaticType.S2_PLUS, 1), AromaticTypeModel.entry(AromaticType.S3_OXIDE_PLUS, 0), AromaticTypeModel.entry(AromaticType.Se3, 1), AromaticTypeModel.entry(AromaticType.As3, 2));
    static final List<Map.Entry<AromaticType, Integer>> DAYLIGHT = Arrays.asList(AromaticTypeModel.entry(AromaticType.C2_MINUS, 1), AromaticTypeModel.entry(AromaticType.C2_PLUS, 1), AromaticTypeModel.entry(AromaticType.C3, 1), AromaticTypeModel.entry(AromaticType.C3_EXO, 1), AromaticTypeModel.entry(AromaticType.C3_ENEG_EXO, 0), AromaticTypeModel.entry(AromaticType.C3_MINUS, 2), AromaticTypeModel.entry(AromaticType.C3_PLUS, 0), AromaticTypeModel.entry(AromaticType.N2, 1), AromaticTypeModel.entry(AromaticType.N2_MINUS, 2), AromaticTypeModel.entry(AromaticType.N3, 2), AromaticTypeModel.entry(AromaticType.N3_OXIDE, 1), AromaticTypeModel.entry(AromaticType.N3_OXIDE_PLUS, 1), AromaticTypeModel.entry(AromaticType.N3_PLUS, 1), AromaticTypeModel.entry(AromaticType.O2, 2), AromaticTypeModel.entry(AromaticType.O2_PLUS, 1), AromaticTypeModel.entry(AromaticType.P2, 1), AromaticTypeModel.entry(AromaticType.P2_MINUS, 2), AromaticTypeModel.entry(AromaticType.P3, 2), AromaticTypeModel.entry(AromaticType.P3_OXIDE, 1), AromaticTypeModel.entry(AromaticType.P3_OXIDE_PLUS, 1), AromaticTypeModel.entry(AromaticType.P3_PLUS, 1), AromaticTypeModel.entry(AromaticType.S2, 2), AromaticTypeModel.entry(AromaticType.S2_PLUS, 1), AromaticTypeModel.entry(AromaticType.S3_OXIDE, 2), AromaticTypeModel.entry(AromaticType.Se2, 2), AromaticTypeModel.entry(AromaticType.Se2_PLUS, 1), AromaticTypeModel.entry(AromaticType.Se3_OXIDE, 2), AromaticTypeModel.entry(AromaticType.As3, 2));
    static final List<Map.Entry<AromaticType, Integer>> OPEN_SMILES = AromaticTypeModel.extend(DAYLIGHT, AromaticTypeModel.entry(AromaticType.B2, 1), AromaticTypeModel.entry(AromaticType.B3, 0), AromaticTypeModel.entry(AromaticType.S3_OXIDE_PLUS, 2), AromaticTypeModel.entry(AromaticType.Se3_OXIDE_PLUS, 2), AromaticTypeModel.entry(AromaticType.As2, 1), AromaticTypeModel.entry(AromaticType.As3_PLUS, 1));
    static final List<Map.Entry<AromaticType, Integer>> CDK_2x = AromaticTypeModel.extend(OPEN_SMILES, AromaticTypeModel.entry(AromaticType.Te2, 2), AromaticTypeModel.entry(AromaticType.Te2_PLUS, 1));
    private static final AromaticType[] types = AromaticType.values();
    private final int[] map = new int[types.length];

    AromaticTypeModel(List<Map.Entry<AromaticType, Integer>> vals) {
        Arrays.fill(this.map, -1);
        for (Map.Entry<AromaticType, Integer> e : vals) {
            this.map[e.getKey().ordinal()] = e.getValue();
        }
    }

    @Override
    int[] contribution(IAtomContainer mol) {
        int[] contrib = new int[mol.getAtomCount()];
        for (IAtom atom : mol.atoms()) {
            AromaticType type = AromaticTypeMatcher.getType(atom);
            contrib[atom.getIndex()] = this.map[type.ordinal()];
        }
        return contrib;
    }

    private static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }

    private static List<Map.Entry<AromaticType, Integer>> extend(List<Map.Entry<AromaticType, Integer>> vals, Map.Entry<AromaticType, Integer> ... extra) {
        ArrayList<Map.Entry<AromaticType, Integer>> ret = new ArrayList<Map.Entry<AromaticType, Integer>>(vals);
        Collections.addAll(ret, extra);
        return ret;
    }
}

