/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import org.biojava.nbio.core.sequence.io.template.GenbankHeaderFormatInterface;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.util.StringManipulationHelper;

public class GenbankWriter<S extends Sequence<?>, C extends Compound> {
    int SEQUENCE_INDENT = 9;
    OutputStream os;
    Collection<S> sequences;
    GenbankHeaderFormatInterface<S, C> headerFormat;
    private int lineLength = 60;

    public GenbankWriter(OutputStream os, Collection<S> sequences, GenbankHeaderFormatInterface<S, C> headerFormat) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
    }

    public GenbankWriter(OutputStream os, Collection<S> sequences, GenbankHeaderFormatInterface<S, C> headerFormat, int lineLength) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
        this.lineLength = lineLength;
    }

    public void process() throws Exception {
        PrintWriter writer = new PrintWriter(this.os);
        for (Sequence sequence : this.sequences) {
            String header = this.headerFormat.getHeader(sequence);
            writer.print(header);
            writer.println();
            String data = sequence.getSequenceAsString().toLowerCase();
            int seq_len = data.length();
            writer.println("ORIGIN");
            for (int line_number = 0; line_number < seq_len; line_number += this.lineLength) {
                writer.print(StringManipulationHelper.padLeft(Integer.toString(line_number + 1), this.SEQUENCE_INDENT));
                for (int words = line_number; words < Math.min(line_number + this.lineLength, seq_len); words += 10) {
                    if (words + 10 > data.length()) {
                        writer.print(" " + data.substring(words));
                        continue;
                    }
                    writer.print(" " + data.substring(words, words + 10));
                }
                writer.println();
            }
            writer.println("//");
        }
        writer.flush();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }
}

