/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import ffx.utilities.TinkerUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.math3.util.FastMath;

public class StringUtils {
    public static final String STANDARD_WATER_NAME = "HOH";
    private static final Logger logger = Logger.getLogger(StringUtils.class.getName());
    private static final Set<String> waterNames = Set.of("HOH", "DOD", "WAT", "TIP", "TIP3", "TIP4", "MOL");
    private static final Map<String, String> ionNames;
    private static final Pattern intRangePattern;

    private StringUtils() {
    }

    public static String cifForID(String id) {
        if (id.length() != 4) {
            return null;
        }
        return "http://www.rcsb.org/pdb/files/" + id.toLowerCase() + ".cif";
    }

    public static List<int[]> consecutiveInts(int[] set) {
        int rangeStart;
        if (set == null || set.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<int[]> allRanges = new ArrayList<int[]>();
        int rangeEnd = rangeStart = set[0];
        for (int i = 1; i < set.length; ++i) {
            if (set[i] == rangeEnd + 1) {
                rangeEnd = set[i];
                continue;
            }
            allRanges.add(new int[]{rangeStart, rangeEnd});
            rangeEnd = rangeStart = set[i];
        }
        allRanges.add(new int[]{rangeStart, rangeEnd});
        return allRanges;
    }

    public static Reader createGzipReader(File file) throws IOException {
        return StringUtils.createGzipReader(file, Charset.defaultCharset());
    }

    public static Reader createGzipReader(File file, Charset cs) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), cs));
    }

    public static Writer createGzipWriter(File file) throws IOException {
        return StringUtils.createGzipWriter(file, Charset.defaultCharset());
    }

    public static Writer createGzipWriter(File file, Charset cs) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), cs));
    }

    public static String fwDec(double val, int width, int prec) throws IllegalArgumentException {
        if (width < 1 || prec < 0) {
            throw new IllegalArgumentException(" Must have width >= 1 and precision >= 0");
        }
        int w1 = width - 1;
        double maxVal = FastMath.pow((double)10.0, (int)width);
        double minVal = maxVal / -10.0;
        if (val >= maxVal) {
            throw new IllegalArgumentException(String.format(" Value %f exceeded the maximum of %f enforced by width %d", val, maxVal, width));
        }
        if (val <= minVal) {
            throw new IllegalArgumentException(String.format(" Value %f is less than the minimum of %f enforced by width %d", val, minVal, width));
        }
        String str = String.format("%" + width + "." + prec + "f", val);
        if (str.charAt(w1) == '.') {
            return " " + str.substring(0, w1);
        }
        return str.substring(0, width);
    }

    public static String fwFpDec(double val, int width, int prec) throws IllegalArgumentException {
        String str = String.format("%" + width + "." + prec + "f", val);
        if (str.length() > width) {
            throw new IllegalArgumentException(String.format(" Value %f cannot fit in width %d with precision %d", val, width, prec));
        }
        return str;
    }

    public static String fwFpTrunc(double val, int width, int prec) {
        String str = String.format("%" + width + "." + prec + "f", val);
        if (str.length() > width) {
            StringBuilder sb = val < 0.0 ? new StringBuilder("-") : new StringBuilder("9");
            sb.append(org.apache.commons.lang3.StringUtils.repeat((String)"9", (int)FastMath.max((int)0, (int)(width - prec - 2))));
            sb.append(".");
            sb.append(org.apache.commons.lang3.StringUtils.repeat((String)"9", (int)FastMath.max((int)0, (int)prec)));
            str = sb.toString();
        }
        return str;
    }

    public static Map<String, String> getIonNames() {
        return new HashMap<String, String>(ionNames);
    }

    public static List<String> getWaterNames() {
        return new ArrayList<String>(waterNames);
    }

    public static boolean looksLikeIon(String name) {
        return ionNames.containsKey(name.toUpperCase());
    }

    public static boolean looksLikeWater(String name) {
        return waterNames.contains(name.toUpperCase());
    }

    public static String padLeft(String s, int n) {
        return String.format("%" + n + "s", s);
    }

    public static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    public static List<Integer> parseAtomRange(String keyType, String atomRange, int nAtoms) throws IllegalArgumentException {
        Matcher m = intRangePattern.matcher(atomRange);
        if (m.matches()) {
            int end;
            int start = Integer.parseInt(m.group(1)) - 1;
            if (start > (end = Integer.parseInt(m.group(2)) - 1)) {
                throw new IllegalArgumentException(String.format(" %s input %s not valid: start > end.", keyType, atomRange));
            }
            if (start < 0) {
                throw new IllegalArgumentException(String.format(" %s input %s not valid: atoms should be indexed starting from 1.", keyType, atomRange));
            }
            if (start >= nAtoms) {
                throw new IllegalArgumentException(String.format(" %s input %s not valid: atom range is out of bounds for assembly of length %d.", keyType, atomRange, nAtoms));
            }
            if (end >= nAtoms) {
                logger.log(Level.INFO, String.format(" Truncating range %s to end of valid range %d.", atomRange, nAtoms));
                end = nAtoms - 1;
            }
            ArrayList<Integer> selectedAtoms = new ArrayList<Integer>();
            for (int i = start; i <= end; ++i) {
                selectedAtoms.add(i);
            }
            return selectedAtoms;
        }
        try {
            int atNum = Integer.parseUnsignedInt(atomRange) - 1;
            if (atNum < 0 || atNum >= nAtoms) {
                throw new IllegalArgumentException(String.format(" %s numerical argument %s out-of-bounds for range 1 to %d", keyType, atomRange, nAtoms));
            }
            ArrayList<Integer> selectedAtoms = new ArrayList<Integer>();
            selectedAtoms.add(atNum);
            return selectedAtoms;
        }
        catch (NumberFormatException ex) {
            List<String> tokens = Arrays.asList(atomRange.split("\\s+"));
            return TinkerUtils.parseTinkerAtomList(tokens, -1, -1);
        }
    }

    public static List<Integer> parseAtomRanges(String keyType, String atomRanges, int nAtoms) throws IllegalArgumentException {
        String[] ranges;
        ArrayList<Integer> atomList = new ArrayList<Integer>();
        String n = Integer.toString(nAtoms);
        atomRanges = atomRanges.toUpperCase().replace("N", n);
        for (String range : ranges = (String[])Arrays.stream(atomRanges.split("\\.|,|;")).map(String::trim).toArray(String[]::new)) {
            List<Integer> list = StringUtils.parseAtomRange(keyType, range, nAtoms);
            for (int i : list) {
                if (atomList.contains(i)) continue;
                atomList.add(i);
            }
        }
        return atomList;
    }

    public static List<String> parseResidueString(String keyType, String resString, int nResidues) throws IllegalArgumentException {
        String[] residues = (String[])Arrays.stream(resString.split("\\.|,|;")).map(String::trim).toArray(String[]::new);
        String regex = "([A-Za-z])(\\d+)";
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> resList = new ArrayList<String>();
        for (String res : residues) {
            Matcher matcher = pattern.matcher(res);
            if (matcher.matches()) {
                if (matcher.groupCount() != 2) {
                    throw new IllegalArgumentException(String.format(" %s residue input %s should be ChainResid (e.g. A28)", keyType, res));
                }
                int resid = Integer.parseInt(matcher.group(2));
                if (resid <= 0 || resid > nResidues) {
                    throw new IllegalArgumentException(String.format(" %s residue input %s should be have a residue number between 1 and the number of residues", keyType, res));
                }
            } else {
                throw new IllegalArgumentException(String.format(" %s residue input %s not valid.", keyType, res));
            }
            resList.add(matcher.group(1).toUpperCase());
            resList.add(matcher.group(2));
        }
        return resList;
    }

    public static String pdbForID(String id) {
        if (id.length() != 4) {
            return null;
        }
        return "http://www.rcsb.org/pdb/files/" + id.toLowerCase() + ".pdb";
    }

    public static String tryParseIon(String name) {
        return ionNames.getOrDefault(name.toUpperCase(), null);
    }

    public static String tryParseWater(String name) {
        return waterNames.contains(name.toUpperCase()) ? STANDARD_WATER_NAME : null;
    }

    public static String writeAtomRanges(int[] atoms) {
        Arrays.sort(atoms);
        int nAtoms = atoms.length;
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < nAtoms; ++i) {
            int index = 0;
            int current = atoms[i] + 1;
            output.append(current);
            while (i + index + 1 < nAtoms && atoms[i + index + 1] + 1 == current + index + 1) {
                ++index;
            }
            if (index >= 2) {
                output.append("-").append(atoms[i + index] + 1);
            } else if (index == 1) {
                output.append(",").append(atoms[i + index] + 1);
            }
            if ((i += index) + 1 >= nAtoms) continue;
            output.append(",");
        }
        String string = output.toString();
        if (string.endsWith(",")) {
            return string.substring(0, string.length() - 1);
        }
        return output.toString();
    }

    static {
        intRangePattern = Pattern.compile("(\\d+)-(\\d+)");
        HashMap<Object, String> ions = new HashMap<Object, String>();
        List<String> monoCats = Arrays.asList("NA", "K", "LI", "RB", "CS", "FR", "AG", "AU");
        for (String string : monoCats) {
            ions.put(string, string);
            ions.put(string + "+", string);
            ions.put(string + "1", string);
            ions.put(string + "1+", string);
            ions.put(string + "+1", string);
        }
        List<String> diCats = Arrays.asList("BE", "MG", "CA", "SR", "BA", "RA", "MN", "ZN");
        for (String diCat : diCats) {
            ions.put(diCat, diCat);
            ions.put(diCat + "+", diCat);
            ions.put(diCat + "2", diCat);
            ions.put(diCat + "2+", diCat);
            ions.put(diCat + "+2", diCat);
            ions.put(diCat + "++", diCat);
        }
        List<String> list = Arrays.asList("F", "CL", "BR", "I", "AT");
        for (String monoAn : list) {
            ions.put(monoAn, monoAn);
            ions.put(monoAn + "-", monoAn);
            ions.put(monoAn + "1", monoAn);
            ions.put(monoAn + "1-", monoAn);
            ions.put(monoAn + "-1", monoAn);
        }
        ionNames = Collections.unmodifiableMap(ions);
    }
}

