/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resources {
    private static final Logger logger = Logger.getLogger(Resources.class.getName());

    private Resources() {
    }

    public static void logResources() {
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder("\n System Resources\n");
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            long MB = 0x100000L;
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unixOS = (UnixOperatingSystemMXBean)operatingSystemMXBean;
                long time = unixOS.getProcessCpuTime();
                sb.append(String.format("  Total CPU time:         %6.2f (sec)\n", (double)time * 1.0E-9));
                double systemLoadAve = unixOS.getSystemLoadAverage();
                if (systemLoadAve >= 0.0) {
                    sb.append(String.format("  System load average:    %6.2f\n", systemLoadAve));
                }
                long open = unixOS.getOpenFileDescriptorCount();
                long allowed = unixOS.getMaxFileDescriptorCount();
                sb.append(String.format("  Open file handles:      %6d of %6d allowed\n", open, allowed));
                long freePhysical = unixOS.getFreeMemorySize() / MB;
                long totalPhysical = unixOS.getTotalMemorySize() / MB;
                long freeSwap = unixOS.getFreeSwapSpaceSize() / MB;
                long totalSwap = unixOS.getTotalSwapSpaceSize() / MB;
                sb.append(String.format("  System memory:          %6d MB free out of %6d MB\n", freePhysical, totalPhysical));
                sb.append(String.format("  System swap space:      %6d MB free out of %6d MB\n", freeSwap, totalSwap));
            }
            sb.append(String.format("  JVM memory:             %6d MB free out of %6d MB", runtime.freeMemory() / MB, runtime.totalMemory() / MB));
            logger.info(sb.toString());
        }
    }
}

