/*
 * Decompiled with CFR 0.152.
 */
package ffx.utilities;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class DownloadUtils {
    private static final Logger logger = Logger.getLogger(DownloadUtils.class.getName());

    private DownloadUtils() {
    }

    public static String downloadPDB(String pdbID) {
        try {
            String url = "https://files.rcsb.org/download/" + pdbID + ".pdb";
            logger.fine(" Attempting to download PDB from:\n " + url);
            String fileName = pdbID + ".pdb";
            File file = new File(fileName);
            int connectionTimeoutMilliseconds = 5000;
            int readTimeoutMilliseconds = 5000;
            FileUtils.copyURLToFile((URL)new URI(url).toURL(), (File)file, (int)connectionTimeoutMilliseconds, (int)readTimeoutMilliseconds);
            logger.fine(" PDB saved to:\n " + file.getAbsolutePath());
            return fileName;
        }
        catch (Exception e) {
            logger.warning(" Error downloading PDB ID: " + pdbID + "\n " + String.valueOf(e));
            return null;
        }
    }
}

