/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.switching;

import ffx.numerics.switching.UnivariateSwitchingFunction;
import org.apache.commons.math3.util.FastMath;

public class MultiplicativeSwitch
implements UnivariateSwitchingFunction {
    private final double b;
    private final double a;
    private final double c0;
    private final double c1;
    private final double c2;
    private final double c3;
    private final double c4;
    private final double c5;
    private final double twoC2;
    private final double threeC3;
    private final double fourC4;
    private final double fiveC5;

    public MultiplicativeSwitch() {
        this(0.0, 1.0);
    }

    public MultiplicativeSwitch(double a, double b) {
        this.a = a;
        this.b = b;
        double a2 = a * a;
        double b2 = b * b;
        double denominator = FastMath.pow((double)(b - a), (double)5.0);
        this.c0 = b * b2 * (b2 - 5.0 * a * b + 10.0 * a2) / denominator;
        this.c1 = -30.0 * a2 * b2 / denominator;
        this.c2 = 30.0 * b * a * (b + a) / denominator;
        this.c3 = -10.0 * (a2 + 4.0 * a * b + b2) / denominator;
        this.c4 = 15.0 * (a + b) / denominator;
        this.c5 = -6.0 / denominator;
        this.twoC2 = 2.0 * this.c2;
        this.threeC3 = 3.0 * this.c3;
        this.fourC4 = 4.0 * this.c4;
        this.fiveC5 = 5.0 * this.c5;
    }

    @Override
    public boolean constantOutsideBounds() {
        return false;
    }

    public double dtaper(double r, double r2, double r3, double r4) {
        return this.fiveC5 * r4 + this.fourC4 * r3 + this.threeC3 * r2 + this.twoC2 * r + this.c1;
    }

    public double dtaper(double r) {
        double r2 = r * r;
        return this.dtaper(r, r2, r2 * r, r2 * r2);
    }

    @Override
    public double firstDerivative(double x) {
        return this.dtaper(x);
    }

    @Override
    public int getHighestOrderZeroDerivative() {
        return 2;
    }

    @Override
    public double getOneBound() {
        return FastMath.max((double)this.a, (double)this.b);
    }

    public double getSwitchEnd() {
        return this.b;
    }

    public double getSwitchStart() {
        return this.a;
    }

    @Override
    public double getZeroBound() {
        return FastMath.min((double)this.b, (double)this.a);
    }

    @Override
    public double nthDerivative(double x, int order) throws IllegalArgumentException {
        if (order < 1) {
            throw new IllegalArgumentException("Order must be >= 1");
        }
        switch (order) {
            case 1: {
                return this.dtaper(x);
            }
            case 2: {
                return this.secondDerivative(x);
            }
            case 3: {
                double val = 60.0 * this.c5 * x * x;
                val += 24.0 * this.c4 * x;
                return val += 6.0 * this.c3;
            }
            case 4: {
                double val = 120.0 * this.c5 * x;
                return val += 24.0 * this.c4;
            }
            case 5: {
                return 120.0 * this.c5;
            }
        }
        return 0.0;
    }

    @Override
    public double secondDerivative(double x) {
        double x2 = x * x;
        double val = 20.0 * this.c5 * x2 * x;
        val += 12.0 * this.c4 * x2;
        val += 6.0 * this.c3 * x;
        return val += 2.0 * this.c2;
    }

    @Override
    public boolean symmetricToUnity() {
        return true;
    }

    public double taper(double r, double r2, double r3, double r4, double r5) {
        return this.c5 * r5 + this.c4 * r4 + this.c3 * r3 + this.c2 * r2 + this.c1 * r + this.c0;
    }

    public double taper(double r) {
        double r2 = r * r;
        double r3 = r2 * r;
        return this.taper(r, r2, r3, r2 * r2, r3 * r2);
    }

    public String toString() {
        return String.format("Multiplicative switch of form f(x) = %8.4g*x^5 + %8.4g*x^4 + %8.4g*x^3 + %8.4g*x^2 + %8.4g*x + %8.4g", this.c5, this.c4, this.c3, this.c2, this.c1, this.c0);
    }

    @Override
    public boolean validOutsideBounds() {
        return false;
    }

    @Override
    public double valueAt(double x) throws IllegalArgumentException {
        return this.taper(x);
    }
}

