/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.spline;

import javax.annotation.Nullable;

public class TriCubicSpline {
    private static final double tau = 0.25;
    private static final double[][] catmullRomMat = new double[][]{{0.0, 1.0, 0.0, 0.0}, {-0.25, 0.0, 0.25, 0.0}, {0.5, -2.75, 2.5, -0.25}, {-0.25, 1.75, -1.75, 0.25}};
    private final double[] p;
    private final double[] q;
    private final double[] r;
    private final double[] u;
    private final double[] v;
    private final double[] w;
    private final double[] dp;
    private final double[] dq;
    private final double[] dr;
    private final double[] du;
    private final double[] dv;
    private final double[] dw = new double[4];

    public TriCubicSpline() {
        this.dv = new double[4];
        this.du = new double[4];
        this.dr = new double[4];
        this.dq = new double[4];
        this.dp = new double[4];
        this.w = new double[4];
        this.v = new double[4];
        this.u = new double[4];
        this.r = new double[4];
        this.q = new double[4];
        this.p = new double[4];
    }

    public double spline(double dx, double dy, double dz, double[][][] scalar, @Nullable double[] g) {
        int i;
        this.u[0] = 1.0;
        this.v[0] = 1.0;
        this.w[0] = 1.0;
        for (i = 1; i < 4; ++i) {
            this.u[i] = this.u[i - 1] * dx;
            this.v[i] = this.v[i - 1] * dy;
            this.w[i] = this.w[i - 1] * dz;
        }
        this.dw[0] = 0.0;
        this.dv[0] = 0.0;
        this.du[0] = 0.0;
        this.dw[1] = 1.0;
        this.dv[1] = 1.0;
        this.du[1] = 1.0;
        this.du[2] = 2.0 * dx;
        this.du[3] = 3.0 * dx * dx;
        this.dv[2] = 2.0 * dy;
        this.dv[3] = 3.0 * dy * dy;
        this.dw[2] = 2.0 * dz;
        this.dw[3] = 3.0 * dz * dz;
        for (i = 0; i < 4; ++i) {
            this.r[i] = 0.0;
            this.q[i] = 0.0;
            this.p[i] = 0.0;
            this.dr[i] = 0.0;
            this.dq[i] = 0.0;
            this.dp[i] = 0.0;
            for (int j = 0; j < 4; ++j) {
                int n = i;
                this.p[n] = this.p[n] + this.u[j] * catmullRomMat[j][i];
                int n2 = i;
                this.q[n2] = this.q[n2] + this.v[j] * catmullRomMat[j][i];
                int n3 = i;
                this.r[n3] = this.r[n3] + this.w[j] * catmullRomMat[j][i];
                int n4 = i;
                this.dp[n4] = this.dp[n4] + this.du[j] * catmullRomMat[j][i];
                int n5 = i;
                this.dq[n5] = this.dq[n5] + this.dv[j] * catmullRomMat[j][i];
                int n6 = i;
                this.dr[n6] = this.dr[n6] + this.dw[j] * catmullRomMat[j][i];
            }
        }
        double sum = 0.0;
        double gx = 0.0;
        double gy = 0.0;
        double gz = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    sum += this.p[i2] * this.q[j] * this.r[k] * scalar[i2][j][k];
                    gx += this.dp[i2] * this.q[j] * this.r[k] * scalar[i2][j][k];
                    gy += this.p[i2] * this.dq[j] * this.r[k] * scalar[i2][j][k];
                    gz += this.p[i2] * this.q[j] * this.dr[k] * scalar[i2][j][k];
                }
            }
        }
        if (g != null) {
            g[0] = gx;
            g[1] = gy;
            g[2] = gz;
        }
        return sum;
    }
}

