/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.special;

import org.apache.commons.math3.util.FastMath;

public class ModifiedBessel {
    private static final double[] A_i0 = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
    private static final double[] B_i0 = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
    private static final double[] A_i1 = new double[]{2.7779141127610464E-18, -2.111421214358166E-17, 1.5536319577362005E-16, -1.1055969477353862E-15, 7.600684294735408E-15, -5.042185504727912E-14, 3.223793365945575E-13, -1.9839743977649436E-12, 1.1736186298890901E-11, -6.663489723502027E-11, 3.625590281552117E-10, -1.8872497517228294E-9, 9.381537386495773E-9, -4.445059128796328E-8, 2.0032947535521353E-7, -8.568720264695455E-7, 3.4702513081376785E-6, -1.3273163656039436E-5, 4.781565107550054E-5, -1.6176081582589674E-4, 5.122859561685758E-4, -0.0015135724506312532, 0.004156422944312888, -0.010564084894626197, 0.024726449030626516, -0.05294598120809499, 0.1026436586898471, -0.17641651835783406, 0.25258718644363365};
    private static final double[] B_i1 = new double[]{7.517296310842105E-18, 4.414348323071708E-18, -4.6503053684893586E-17, -3.209525921993424E-17, 2.96262899764595E-16, 3.3082023109209285E-16, -1.8803547755107825E-15, -3.8144030724370075E-15, 1.0420276984128802E-14, 4.272440016711951E-14, -2.1015418427726643E-14, -4.0835511110921974E-13, -7.198551776245908E-13, 2.0356285441470896E-12, 1.4125807436613782E-11, 3.2526035830154884E-11, -1.8974958123505413E-11, -5.589743462196584E-10, -3.835380385964237E-9, -2.6314688468895196E-8, -2.512236237870209E-7, -3.882564808877691E-6, -1.1058893876262371E-4, -0.009761097491361469, 0.7785762350182801};

    private ModifiedBessel() {
    }

    public static double i0(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return 0.0;
        }
        if (x < 0.0) {
            x = -x;
        }
        if (x <= 8.0) {
            double y = x * 0.5 - 2.0;
            return ModifiedBessel.eToThe(x) * ModifiedBessel.evaluateChebyshev(y, A_i0, 30);
        }
        double ix = 1.0 / x;
        return ModifiedBessel.eToThe(x) * ModifiedBessel.evaluateChebyshev(32.0 * ix - 2.0, B_i0, 25) * FastMath.sqrt((double)ix);
    }

    public static double i1(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return 0.0;
        }
        double z = FastMath.abs((double)x);
        if (z <= 8.0) {
            double y = z * 0.5 - 2.0;
            z = ModifiedBessel.evaluateChebyshev(y, A_i1, 29) * z * ModifiedBessel.eToThe(z);
        } else {
            double iz = 1.0 / z;
            z = ModifiedBessel.eToThe(z) * ModifiedBessel.evaluateChebyshev(32.0 * iz - 2.0, B_i1, 25) * FastMath.sqrt((double)iz);
        }
        if (x < 0.0) {
            z = -z;
        }
        return z;
    }

    public static double i1OverI0(double x) {
        double result;
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return 0.0;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (FastMath.abs((double)x) < 1.0) {
            return ModifiedBessel.i1(x) / ModifiedBessel.i0(x);
        }
        double absX = FastMath.abs((double)x);
        if (absX <= 8.0) {
            double y = absX * 0.5 - 2.0;
            double expX = ModifiedBessel.eToThe(absX);
            double i0Val = expX * ModifiedBessel.evaluateChebyshev(y, A_i0, 30);
            double i1Val = ModifiedBessel.evaluateChebyshev(y, A_i1, 29) * absX * expX;
            result = i1Val / i0Val;
        } else {
            double ix = 1.0 / absX;
            double expX = ModifiedBessel.eToThe(absX);
            double sqrtIx = FastMath.sqrt((double)ix);
            double i0Val = expX * ModifiedBessel.evaluateChebyshev(32.0 * ix - 2.0, B_i0, 25) * sqrtIx;
            double i1Val = expX * ModifiedBessel.evaluateChebyshev(32.0 * ix - 2.0, B_i1, 25) * sqrtIx;
            result = i1Val / i0Val;
        }
        return x < 0.0 ? -result : result;
    }

    public static double lnI0(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (FastMath.abs((double)x) <= 8.0) {
            double i0Val = ModifiedBessel.i0(x);
            return i0Val > 0.0 ? FastMath.log((double)i0Val) : Double.NEGATIVE_INFINITY;
        }
        double absX = FastMath.abs((double)x);
        double ix = 1.0 / absX;
        double chebyshevTerm = ModifiedBessel.evaluateChebyshev(32.0 * ix - 2.0, B_i0, 25);
        if (chebyshevTerm <= 0.0) {
            return absX;
        }
        return absX + FastMath.log((double)(chebyshevTerm * FastMath.sqrt((double)ix)));
    }

    private static double evaluateChebyshev(double x, double[] coefficients, int N) {
        double b2;
        int p = 0;
        double b0 = coefficients[p++];
        double b1 = 0.0;
        int i = N - 1;
        do {
            b2 = b1;
            b1 = b0;
            b0 = x * b1 - b2 + coefficients[p++];
        } while (--i > 0);
        return 0.5 * (b0 - b2);
    }

    private static double eToThe(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x > 709.0) {
            return Double.MAX_VALUE;
        }
        if (x < -745.0) {
            return Double.MIN_VALUE;
        }
        double res = FastMath.exp((double)x);
        if (res == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (res == Double.NEGATIVE_INFINITY || res == 0.0) {
            return Double.MIN_VALUE;
        }
        return res;
    }
}

