/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.math.ScalarMath;
import java.util.HashMap;

public class MultipoleUtilities {
    public static int tensorCount(int order) {
        long ret = ScalarMath.binomial(order + 3, 3L);
        assert (ret < Integer.MAX_VALUE);
        return (int)ret;
    }

    protected static String rlmn(int l, int m, int n) {
        return String.format("R%d%d%d", l, m, n);
    }

    protected static String term(int l, int m, int n) {
        return String.format("term%d%d%d", l, m, n);
    }

    protected static String term(int l, int m, int n, int j) {
        return String.format("term%d%d%d%d", l, m, n, j);
    }

    protected static int ti(int dx, int dy, int dz, int order) {
        if (dx < 0 || dy < 0 || dz < 0 || dx + dy + dz > order) {
            return -1;
        }
        int size = (order + 1) * (order + 2) * (order + 3) / 6;
        int top = order + 1 - dz;
        top = top * (top + 1) * (top + 2) / 6;
        int zIndex = size - top;
        int yIndex = dy * (order - dz) - (dy - 1) * (dy - 2) / 2 + 1;
        return dx + yIndex + zIndex;
    }

    protected static String lmn(int l, int m, int n) {
        return String.format("%d%d%d", l, m, n);
    }

    protected static String loadTensor(int l, int n, int m, HashMap<Integer, String> tensorMap) {
        String s = MultipoleUtilities.lmn(l, n, m);
        String offset = "T" + MultipoleUtilities.lmn(l, n, m);
        String name = "t" + s;
        if (tensorMap.containsValue(name)) {
            return "";
        }
        int size = tensorMap.size();
        tensorMap.put(size, name);
        return String.format("\tDoubleVector %s = fromArray(SPECIES, t, %s);\n", name, offset);
    }

    protected static String storePotential(String to, int l, int n, int m) {
        String from = MultipoleUtilities.term(l, n, m);
        String offset = "T" + MultipoleUtilities.lmn(l, n, m);
        return String.format("\t%s.intoArray(%s, %s);\n", from, to, offset);
    }

    protected static String storePotentialNeg(String to, int l, int n, int m) {
        String from = MultipoleUtilities.term(l, n, m);
        String offset = "T" + MultipoleUtilities.lmn(l, n, m);
        return String.format("\t%s.neg().intoArray(%s, %s);\n", from, to, offset);
    }
}

