/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.math.ScalarMath;
import ffx.numerics.multipole.GKMultipoleOrder;
import ffx.numerics.multipole.GKSource;
import ffx.numerics.multipole.GKTensorMode;
import java.util.Arrays;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.commons.math3.util.FastMath;

public class GKSourceSIMD {
    private GKTensorMode mode = GKTensorMode.POTENTIAL;
    private DoubleVector rb2;
    private DoubleVector expTerm;
    private DoubleVector f;
    private DoubleVector f1;
    private DoubleVector f2;
    private final double gc;
    private final double igc;
    private DoubleVector gcAiAj;
    private DoubleVector ratio;
    private DoubleVector fr;
    private DoubleVector r2;
    private final int order;
    private final double[] kirkwoodSource;
    private final double[][] anmc;
    private final DoubleVector[] fn;
    protected final DoubleVector[] bn;
    private final DoubleVector[][] anm;
    private final DoubleVector[][] bnm;
    private final DoubleVector zero = DoubleVector.zero((VectorSpecies)DoubleVector.SPECIES_PREFERRED);
    private final DoubleVector one = this.zero.add(1.0);

    public GKSourceSIMD(int order, double gc) {
        int n;
        this.order = order;
        this.gc = gc;
        this.igc = 1.0 / gc;
        this.kirkwoodSource = new double[order + 1];
        for (n = 0; n <= order; n = (int)((short)(n + 1))) {
            this.kirkwoodSource[n] = FastMath.pow((double)-1.0, (int)n) * (double)ScalarMath.doubleFactorial(2 * n - 1);
        }
        this.anmc = new double[order + 1][];
        for (n = 0; n <= order; ++n) {
            this.anmc[n] = GKSource.anmc(n);
        }
        this.fn = new DoubleVector[order + 1];
        this.anm = new DoubleVector[order + 1][order + 1];
        this.bn = new DoubleVector[order + 1];
        this.bnm = new DoubleVector[order + 1][order + 1];
    }

    protected void source(DoubleVector[] work, GKMultipoleOrder multipoleOrder) {
        int mpoleOrder = multipoleOrder.getOrder();
        Arrays.fill(work, 0, mpoleOrder, this.zero);
        if (this.mode == GKTensorMode.POTENTIAL) {
            int derivatives = this.order - mpoleOrder;
            System.arraycopy(this.anm[mpoleOrder], 0, work, mpoleOrder, derivatives + 1);
        } else {
            int derivatives = this.order - 1 - mpoleOrder;
            System.arraycopy(this.bnm[mpoleOrder], 0, work, mpoleOrder, derivatives + 1);
        }
    }

    public void generateSource(GKTensorMode mode, GKMultipoleOrder multipole, DoubleVector r2, DoubleVector ai, DoubleVector aj) {
        int multipoleOrder = multipole.getOrder();
        this.mode = mode;
        this.r2 = r2;
        this.rb2 = ai.mul((Vector)aj);
        this.gcAiAj = this.rb2.mul(this.gc);
        this.ratio = r2.neg().div((Vector)this.gcAiAj);
        this.expTerm = this.ratio.lanewise(VectorOperators.EXP);
        this.fr = this.zero.sub(2.0).div((Vector)this.gcAiAj);
        this.f = r2.add((Vector)this.rb2.mul((Vector)this.expTerm)).sqrt();
        this.f1 = this.one.sub((Vector)this.expTerm.mul(this.igc));
        this.f2 = this.zero.add(2.0).mul((Vector)this.expTerm).div((Vector)this.gcAiAj.mul(this.gc));
        if (mode == GKTensorMode.POTENTIAL) {
            this.anm(this.order, this.order - multipoleOrder);
        } else {
            this.bnm(this.order - 1, this.order - 1 - multipoleOrder);
        }
    }

    private void anm(int n, int derivatives) {
        this.fn(n);
        this.an0(n);
        for (int d = 1; d <= derivatives; ++d) {
            double[] coef = this.anmc[d];
            int limit = n - d;
            for (int order = 0; order <= limit; ++order) {
                DoubleVector[] terms = this.anm[order + 1];
                DoubleVector sum = this.zero;
                for (int i = 1; i <= d; ++i) {
                    sum = sum.add((Vector)this.fn[i].mul((Vector)terms[d - i].mul(coef[i - 1])));
                }
                this.anm[order][d] = sum;
            }
        }
    }

    private void bnm(int n, int derivatives) {
        this.bn(n);
        this.bn0(n);
        for (int d = 1; d <= derivatives; ++d) {
            double[] coef = this.anmc[d];
            int limit = n - d;
            for (int order = 0; order <= limit; ++order) {
                DoubleVector[] terma = this.anm[order + 1];
                DoubleVector[] termb = this.bnm[order + 1];
                DoubleVector sum = this.zero;
                for (int i = 1; i <= d; ++i) {
                    sum = sum.add((Vector)this.bn[i].mul((Vector)terma[d - i].mul(coef[i - 1])));
                    sum = sum.add((Vector)this.fn[i].mul((Vector)termb[d - i].mul(coef[i - 1])));
                }
                this.bnm[order][d] = sum;
            }
        }
    }

    private void fn(int n) {
        switch (n) {
            case 0: {
                this.fn[0] = this.f;
                break;
            }
            case 1: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                break;
            }
            case 2: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                break;
            }
            case 3: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr.mul((Vector)this.f2);
                break;
            }
            case 4: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr.mul((Vector)this.f2);
                this.fn[4] = this.fr.mul((Vector)this.fn[3]);
                break;
            }
            case 5: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr.mul((Vector)this.f2);
                this.fn[4] = this.fr.mul((Vector)this.fn[3]);
                this.fn[5] = this.fr.mul((Vector)this.fn[4]);
                break;
            }
            case 6: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                this.fn[3] = this.fr.mul((Vector)this.f2);
                this.fn[4] = this.fr.mul((Vector)this.fn[3]);
                this.fn[5] = this.fr.mul((Vector)this.fn[4]);
                this.fn[6] = this.fr.mul((Vector)this.fn[5]);
                break;
            }
            default: {
                this.fn[0] = this.f;
                this.fn[1] = this.f1;
                this.fn[2] = this.f2;
                for (int i = 3; i <= n; ++i) {
                    this.fn[i] = this.fr.mul((Vector)this.fn[i - 1]);
                }
            }
        }
    }

    protected void bn(int n) {
        DoubleVector b2 = this.expTerm.mul(2.0).div((Vector)this.gcAiAj.mul((Vector)this.gcAiAj)).mul((Vector)this.ratio.neg().sub(1.0));
        switch (n) {
            case 0: {
                this.bn[0] = this.expTerm.mul(0.5).mul((Vector)this.ratio.neg().add(1.0));
                break;
            }
            case 1: {
                this.bn[0] = this.expTerm.mul(0.5).mul((Vector)this.ratio.neg().add(1.0));
                this.bn[1] = this.r2.mul((Vector)this.expTerm).div((Vector)this.gcAiAj.mul((Vector)this.gcAiAj)).neg();
                break;
            }
            case 2: {
                this.bn[0] = this.expTerm.mul(0.5).mul((Vector)this.ratio.neg().add(1.0));
                this.bn[1] = this.r2.mul((Vector)this.expTerm).div((Vector)this.gcAiAj.mul((Vector)this.gcAiAj)).neg();
                this.bn[2] = b2;
                break;
            }
            default: {
                this.bn[0] = this.expTerm.mul(0.5).mul((Vector)this.ratio.neg().add(1.0));
                this.bn[1] = this.r2.mul((Vector)this.expTerm).div((Vector)this.gcAiAj.mul((Vector)this.gcAiAj)).neg();
                this.bn[2] = b2;
                DoubleVector br = this.zero.add(2.0).div((Vector)this.gcAiAj.mul((Vector)this.rb2));
                DoubleVector f2 = this.zero.add(2.0).div((Vector)this.gcAiAj.mul(this.gc)).mul((Vector)this.expTerm);
                DoubleVector frA = this.one;
                DoubleVector frB = this.fr;
                for (int i = 3; i < n; ++i) {
                    this.bn[i] = frA.mul((double)(i - 2)).mul((Vector)br).mul((Vector)f2).add((Vector)frB.mul((Vector)b2));
                    frA = frA.mul((Vector)this.fr);
                    frB = frB.mul((Vector)this.fr);
                }
            }
        }
    }

    private void an0(int n) {
        DoubleVector inverseF = this.one.div((Vector)this.f);
        DoubleVector inverseF2 = inverseF.mul((Vector)inverseF);
        for (int i = 0; i <= n; ++i) {
            this.anm[i][0] = inverseF.mul(this.kirkwoodSource[i]);
            inverseF = inverseF.mul((Vector)inverseF2);
        }
    }

    private void bn0(int n) {
        for (int i = 0; i <= n; ++i) {
            this.bnm[i][0] = this.bn[0].mul((Vector)this.anm[i + 1][0]);
        }
    }
}

