/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.GKMultipoleOrder;
import ffx.numerics.multipole.GKSource;
import ffx.numerics.multipole.GKTensorGlobal;
import ffx.numerics.multipole.GKTensorMode;
import ffx.numerics.multipole.PolarizableMultipole;
import java.util.Arrays;

public class GKEnergyGlobal {
    private final GKSource gkSource;
    private final GKTensorGlobal gkMonopole;
    private final GKTensorGlobal gkDipole;
    private final GKTensorGlobal gkQuadrupole;

    public GKEnergyGlobal(double gkc, double epsilon, boolean gradient) {
        int monopoleOrder = 2;
        int dipoleOrder = 3;
        int quadrupoleOrder = 4;
        if (gradient) {
            monopoleOrder = 3;
            dipoleOrder = 4;
            quadrupoleOrder = 5;
        }
        this.gkSource = new GKSource(quadrupoleOrder, gkc);
        this.gkMonopole = new GKTensorGlobal(GKMultipoleOrder.MONOPOLE, monopoleOrder, this.gkSource, 1.0, epsilon);
        this.gkDipole = new GKTensorGlobal(GKMultipoleOrder.DIPOLE, dipoleOrder, this.gkSource, 1.0, epsilon);
        this.gkQuadrupole = new GKTensorGlobal(GKMultipoleOrder.QUADRUPOLE, quadrupoleOrder, this.gkSource, 1.0, epsilon);
    }

    public void initPotential(double[] r, double r2, double rbi, double rbk) {
        this.gkSource.generateSource(GKTensorMode.POTENTIAL, GKMultipoleOrder.QUADRUPOLE, r2, rbi, rbk);
        this.gkMonopole.setR(r);
        this.gkDipole.setR(r);
        this.gkQuadrupole.setR(r);
        this.gkMonopole.generateTensor();
        this.gkDipole.generateTensor();
        this.gkQuadrupole.generateTensor();
    }

    public void initBorn(double[] r, double r2, double rbi, double rbk) {
        this.gkSource.generateSource(GKTensorMode.BORN, GKMultipoleOrder.QUADRUPOLE, r2, rbi, rbk);
        this.gkMonopole.setR(r);
        this.gkDipole.setR(r);
        this.gkQuadrupole.setR(r);
        this.gkMonopole.generateTensor();
        this.gkDipole.generateTensor();
        this.gkQuadrupole.generateTensor();
    }

    public double multipoleEnergy(PolarizableMultipole mI, PolarizableMultipole mK) {
        double em = this.gkMonopole.multipoleEnergy(mI, mK);
        double ed = this.gkDipole.multipoleEnergy(mI, mK);
        double eq = this.gkQuadrupole.multipoleEnergy(mI, mK);
        return em + ed + eq;
    }

    public double polarizationEnergy(PolarizableMultipole mI, PolarizableMultipole mK) {
        double emp = this.gkMonopole.polarizationEnergy(mI, mK);
        double edp = this.gkDipole.polarizationEnergy(mI, mK);
        double eqp = this.gkQuadrupole.polarizationEnergy(mI, mK);
        return emp + edp + eqp;
    }

    public double multipoleEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double[] gradI, double[] torqueI, double[] torqueK) {
        double[] gI = new double[3];
        double[] gK = new double[3];
        double[] tI = new double[3];
        double[] tK = new double[3];
        double em = this.gkMonopole.multipoleEnergyAndGradient(mI, mK, gI, gK, tI, tK);
        for (int j = 0; j < 3; ++j) {
            gradI[j] = gI[j];
            torqueI[j] = tI[j];
            torqueK[j] = tK[j];
        }
        Arrays.fill(gI, 0.0);
        Arrays.fill(gK, 0.0);
        Arrays.fill(tI, 0.0);
        Arrays.fill(tK, 0.0);
        double ed = this.gkDipole.multipoleEnergyAndGradient(mI, mK, gI, gK, tI, tK);
        for (int j = 0; j < 3; ++j) {
            int n = j;
            gradI[n] = gradI[n] + gI[j];
            int n2 = j;
            torqueI[n2] = torqueI[n2] + tI[j];
            int n3 = j;
            torqueK[n3] = torqueK[n3] + tK[j];
        }
        Arrays.fill(gI, 0.0);
        Arrays.fill(gK, 0.0);
        Arrays.fill(tI, 0.0);
        Arrays.fill(tK, 0.0);
        double eq = this.gkQuadrupole.multipoleEnergyAndGradient(mI, mK, gI, gK, tI, tK);
        for (int j = 0; j < 3; ++j) {
            int n = j;
            gradI[n] = gradI[n] + gI[j];
            int n4 = j;
            torqueI[n4] = torqueI[n4] + tI[j];
            int n5 = j;
            torqueK[n5] = torqueK[n5] + tK[j];
        }
        return em + ed + eq;
    }

    public double polarizationEnergyAndGradient(PolarizableMultipole mI, PolarizableMultipole mK, double mutualMask, double[] gradI, double[] torqueI, double[] torqueK) {
        double[] gI = new double[3];
        double[] tI = new double[3];
        double[] tK = new double[3];
        double emp = this.gkMonopole.polarizationEnergyAndGradient(mI, mK, 1.0, 1.0, mutualMask, gI, tI, tK);
        for (int j = 0; j < 3; ++j) {
            gradI[j] = gI[j];
            torqueI[j] = tI[j];
            torqueK[j] = tK[j];
        }
        Arrays.fill(gI, 0.0);
        Arrays.fill(tI, 0.0);
        Arrays.fill(tK, 0.0);
        double edp = this.gkDipole.polarizationEnergyAndGradient(mI, mK, 1.0, 1.0, mutualMask, gI, tI, tK);
        for (int j = 0; j < 3; ++j) {
            int n = j;
            gradI[n] = gradI[n] + gI[j];
            int n2 = j;
            torqueI[n2] = torqueI[n2] + tI[j];
            int n3 = j;
            torqueK[n3] = torqueK[n3] + tK[j];
        }
        Arrays.fill(gI, 0.0);
        Arrays.fill(tI, 0.0);
        Arrays.fill(tK, 0.0);
        double eqp = this.gkQuadrupole.polarizationEnergyAndGradient(mI, mK, 1.0, 1.0, mutualMask, gI, tI, tK);
        for (int j = 0; j < 3; ++j) {
            int n = j;
            gradI[n] = gradI[n] + gI[j];
            int n4 = j;
            torqueI[n4] = torqueI[n4] + tI[j];
            int n5 = j;
            torqueK[n5] = torqueK[n5] + tK[j];
        }
        return emp + edp + eqp;
    }

    public double multipoleEnergyBornGrad(PolarizableMultipole mI, PolarizableMultipole mK) {
        double db = this.gkMonopole.multipoleEnergyBornGrad(mI, mK);
        db += this.gkDipole.multipoleEnergyBornGrad(mI, mK);
        return db += this.gkQuadrupole.multipoleEnergyBornGrad(mI, mK);
    }

    public double polarizationEnergyBornGrad(PolarizableMultipole mI, PolarizableMultipole mK, boolean mutual) {
        double db = this.gkMonopole.polarizationEnergyBornGrad(mI, mK);
        db += this.gkDipole.polarizationEnergyBornGrad(mI, mK);
        db += this.gkQuadrupole.polarizationEnergyBornGrad(mI, mK);
        if (mutual) {
            db += this.gkDipole.mutualPolarizationEnergyBornGrad(mI, mK);
        }
        return db;
    }
}

