/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoulombTensorQISIMD;
import ffx.numerics.multipole.EwaldTensorGlobal;
import ffx.numerics.multipole.EwaldTensorGlobalSIMD;
import ffx.numerics.multipole.Operator;
import jdk.incubator.vector.DoubleVector;

public class EwaldTensorQISIMD
extends CoulombTensorQISIMD {
    private final double[] ewaldSource;
    private final double beta;
    private final double[] work;

    public EwaldTensorQISIMD(int order, double beta) {
        super(order);
        this.beta = beta;
        this.operator = Operator.SCREENED_COULOMB;
        this.ewaldSource = new double[this.o1];
        this.work = new double[this.o1];
        EwaldTensorGlobal.initEwaldSource(order, beta, this.ewaldSource);
    }

    @Override
    protected void source(DoubleVector[] T000) {
        if (this.beta > 0.0) {
            EwaldTensorGlobalSIMD.fillEwaldSource(this.order, this.beta, this.ewaldSource, this.R, T000, this.work);
        } else {
            super.source(T000);
        }
    }
}

