/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.multipole;

import ffx.numerics.multipole.CoordinateSystem;
import ffx.numerics.multipole.MultipoleTensorSIMD;
import ffx.numerics.multipole.Operator;
import ffx.numerics.multipole.PolarizableMultipoleSIMD;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public class CoulombTensorQISIMD
extends MultipoleTensorSIMD {
    private static final DoubleVector zero = DoubleVector.zero((VectorSpecies)DoubleVector.SPECIES_PREFERRED);

    public CoulombTensorQISIMD(int order) {
        super(CoordinateSystem.QI, order);
        this.operator = Operator.COULOMB;
    }

    @Override
    public void setR(DoubleVector dx, DoubleVector dy, DoubleVector dz) {
        this.x = DoubleVector.broadcast((VectorSpecies)dz.species(), (double)0.0);
        this.y = DoubleVector.broadcast((VectorSpecies)dz.species(), (double)0.0);
        DoubleVector dx2 = dx.mul((Vector)dx);
        DoubleVector dy2 = dy.mul((Vector)dy);
        DoubleVector dz2 = dz.mul((Vector)dz);
        this.r2 = dx2.add((Vector)dy2).add((Vector)dz2);
        this.R = this.z = this.r2.sqrt();
    }

    @Override
    protected void source(DoubleVector[] T000) {
        DoubleVector ONE = DoubleVector.broadcast((VectorSpecies)this.R.species(), (double)1.0);
        DoubleVector ir = ONE.div((Vector)this.R);
        DoubleVector ir2 = ir.mul((Vector)ir);
        for (int n = 0; n < this.o1; ++n) {
            T000[n] = ir.mul(this.coulombSource[n]);
            ir = ir.mul((Vector)ir2);
        }
    }

    @Override
    protected void order1() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        this.R000 = term0000;
        this.R001 = this.z.mul((Vector)term0001);
    }

    @Override
    protected void order2() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        this.R000 = term0000;
        this.R200 = term0001;
        this.R020 = term0001;
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
    }

    @Override
    protected void order3() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        this.R000 = term0000;
        this.R200 = term0001;
        this.R020 = term0001;
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        this.R021 = this.z.mul((Vector)term0002);
        this.R201 = this.z.mul((Vector)term0002);
    }

    @Override
    protected void order4() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        DoubleVector term0004 = this.work[4];
        this.R000 = term0000;
        this.R200 = term0001;
        this.R400 = term0002.mul(3.0);
        this.R020 = term0001;
        this.R040 = term0002.mul(3.0);
        this.R220 = term0002;
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        DoubleVector term0013 = this.z.mul((Vector)term0004);
        DoubleVector term0022 = this.z.fma((Vector)term0013, (Vector)term0003);
        DoubleVector term0031 = this.z.fma((Vector)term0022, (Vector)term0012.mul(2.0));
        this.R004 = this.z.fma((Vector)term0031, (Vector)term0021.mul(3.0));
        this.R021 = this.z.mul((Vector)term0002);
        DoubleVector term0211 = this.z.mul((Vector)term0003);
        this.R022 = this.z.fma((Vector)term0211, (Vector)term0002);
        this.R201 = this.z.mul((Vector)term0002);
        DoubleVector term2011 = this.z.mul((Vector)term0003);
        this.R202 = this.z.fma((Vector)term2011, (Vector)term0002);
    }

    @Override
    protected void order5() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        DoubleVector term0004 = this.work[4];
        DoubleVector term0005 = this.work[5];
        this.R000 = term0000;
        this.R200 = term0001;
        this.R400 = term0002.mul(3.0);
        DoubleVector term4001 = term0003.mul(3.0);
        this.R020 = term0001;
        this.R040 = term0002.mul(3.0);
        DoubleVector term0401 = term0003.mul(3.0);
        this.R220 = term0002;
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        DoubleVector term0013 = this.z.mul((Vector)term0004);
        DoubleVector term0022 = this.z.fma((Vector)term0013, (Vector)term0003);
        DoubleVector term0031 = this.z.fma((Vector)term0022, (Vector)term0012.mul(2.0));
        this.R004 = this.z.fma((Vector)term0031, (Vector)term0021.mul(3.0));
        DoubleVector term0014 = this.z.mul((Vector)term0005);
        DoubleVector term0023 = this.z.fma((Vector)term0014, (Vector)term0004);
        DoubleVector term0032 = this.z.fma((Vector)term0023, (Vector)term0013.mul(2.0));
        DoubleVector term0041 = this.z.fma((Vector)term0032, (Vector)term0022.mul(3.0));
        this.R005 = this.z.fma((Vector)term0041, (Vector)term0031.mul(4.0));
        this.R021 = this.z.mul((Vector)term0002);
        DoubleVector term0211 = this.z.mul((Vector)term0003);
        this.R022 = this.z.fma((Vector)term0211, (Vector)term0002);
        DoubleVector term0212 = this.z.mul((Vector)term0004);
        DoubleVector term0221 = this.z.fma((Vector)term0212, (Vector)term0003);
        this.R023 = this.z.fma((Vector)term0221, (Vector)term0211.mul(2.0));
        this.R041 = this.z.mul((Vector)term0401);
        this.R201 = this.z.mul((Vector)term0002);
        DoubleVector term2011 = this.z.mul((Vector)term0003);
        this.R202 = this.z.fma((Vector)term2011, (Vector)term0002);
        DoubleVector term2012 = this.z.mul((Vector)term0004);
        DoubleVector term2021 = this.z.fma((Vector)term2012, (Vector)term0003);
        this.R203 = this.z.fma((Vector)term2021, (Vector)term2011.mul(2.0));
        this.R221 = this.z.mul((Vector)term0003);
        this.R401 = this.z.mul((Vector)term4001);
    }

    @Override
    protected void order6() {
        this.source(this.work);
        DoubleVector term0000 = this.work[0];
        DoubleVector term0001 = this.work[1];
        DoubleVector term0002 = this.work[2];
        DoubleVector term0003 = this.work[3];
        DoubleVector term0004 = this.work[4];
        DoubleVector term0005 = this.work[5];
        DoubleVector term0006 = this.work[6];
        this.R000 = term0000;
        this.R200 = term0001;
        this.R400 = term0002.mul(3.0);
        DoubleVector term4001 = term0003.mul(3.0);
        DoubleVector term4002 = term0004.mul(3.0);
        this.R600 = term4001.mul(5.0);
        this.R020 = term0001;
        this.R040 = term0002.mul(3.0);
        DoubleVector term0401 = term0003.mul(3.0);
        DoubleVector term0402 = term0004.mul(3.0);
        this.R060 = term0401.mul(5.0);
        this.R220 = term0002;
        this.R240 = term0003.mul(3.0);
        this.R420 = term4001;
        this.R001 = this.z.mul((Vector)term0001);
        DoubleVector term0011 = this.z.mul((Vector)term0002);
        this.R002 = this.z.fma((Vector)term0011, (Vector)term0001);
        DoubleVector term0012 = this.z.mul((Vector)term0003);
        DoubleVector term0021 = this.z.fma((Vector)term0012, (Vector)term0002);
        this.R003 = this.z.fma((Vector)term0021, (Vector)term0011.mul(2.0));
        DoubleVector term0013 = this.z.mul((Vector)term0004);
        DoubleVector term0022 = this.z.fma((Vector)term0013, (Vector)term0003);
        DoubleVector term0031 = this.z.fma((Vector)term0022, (Vector)term0012.mul(2.0));
        this.R004 = this.z.fma((Vector)term0031, (Vector)term0021.mul(3.0));
        DoubleVector term0014 = this.z.mul((Vector)term0005);
        DoubleVector term0023 = this.z.fma((Vector)term0014, (Vector)term0004);
        DoubleVector term0032 = this.z.fma((Vector)term0023, (Vector)term0013.mul(2.0));
        DoubleVector term0041 = this.z.fma((Vector)term0032, (Vector)term0022.mul(3.0));
        this.R005 = this.z.fma((Vector)term0041, (Vector)term0031.mul(4.0));
        DoubleVector term0015 = this.z.mul((Vector)term0006);
        DoubleVector term0024 = this.z.fma((Vector)term0015, (Vector)term0005);
        DoubleVector term0033 = this.z.fma((Vector)term0024, (Vector)term0014.mul(2.0));
        DoubleVector term0042 = this.z.fma((Vector)term0033, (Vector)term0023.mul(3.0));
        DoubleVector term0051 = this.z.fma((Vector)term0042, (Vector)term0032.mul(4.0));
        this.R006 = this.z.fma((Vector)term0051, (Vector)term0041.mul(5.0));
        this.R021 = this.z.mul((Vector)term0002);
        DoubleVector term0211 = this.z.mul((Vector)term0003);
        this.R022 = this.z.fma((Vector)term0211, (Vector)term0002);
        DoubleVector term0212 = this.z.mul((Vector)term0004);
        DoubleVector term0221 = this.z.fma((Vector)term0212, (Vector)term0003);
        this.R023 = this.z.fma((Vector)term0221, (Vector)term0211.mul(2.0));
        DoubleVector term0213 = this.z.mul((Vector)term0005);
        DoubleVector term0222 = this.z.fma((Vector)term0213, (Vector)term0004);
        DoubleVector term0231 = this.z.fma((Vector)term0222, (Vector)term0212.mul(2.0));
        this.R024 = this.z.fma((Vector)term0231, (Vector)term0221.mul(3.0));
        this.R041 = this.z.mul((Vector)term0401);
        DoubleVector term0411 = this.z.mul((Vector)term0402);
        this.R042 = this.z.fma((Vector)term0411, (Vector)term0401);
        this.R201 = this.z.mul((Vector)term0002);
        DoubleVector term2011 = this.z.mul((Vector)term0003);
        this.R202 = this.z.fma((Vector)term2011, (Vector)term0002);
        DoubleVector term2012 = this.z.mul((Vector)term0004);
        DoubleVector term2021 = this.z.fma((Vector)term2012, (Vector)term0003);
        this.R203 = this.z.fma((Vector)term2021, (Vector)term2011.mul(2.0));
        DoubleVector term2013 = this.z.mul((Vector)term0005);
        DoubleVector term2022 = this.z.fma((Vector)term2013, (Vector)term0004);
        DoubleVector term2031 = this.z.fma((Vector)term2022, (Vector)term2012.mul(2.0));
        this.R204 = this.z.fma((Vector)term2031, (Vector)term2021.mul(3.0));
        this.R221 = this.z.mul((Vector)term0003);
        DoubleVector term2211 = this.z.mul((Vector)term0004);
        this.R222 = this.z.fma((Vector)term2211, (Vector)term0003);
        this.R401 = this.z.mul((Vector)term4001);
        DoubleVector term4011 = this.z.mul((Vector)term4002);
        this.R402 = this.z.fma((Vector)term4011, (Vector)term4001);
    }

    @Override
    protected void multipoleKPotentialAtI(PolarizableMultipoleSIMD mK, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = mK.dx.mul((Vector)this.R400);
                term300 = mK.qxz.fma((Vector)this.R401, (Vector)term300);
                this.E300 = term300.neg();
                DoubleVector term030 = mK.dy.mul((Vector)this.R040);
                term030 = mK.qyz.fma((Vector)this.R041, (Vector)term030);
                this.E030 = term030.neg();
                DoubleVector term003 = mK.q.mul((Vector)this.R003);
                term003 = mK.dz.fma((Vector)this.R004, (Vector)term003);
                term003 = mK.qxx.fma((Vector)this.R203, (Vector)term003);
                term003 = mK.qyy.fma((Vector)this.R023, (Vector)term003);
                term003 = mK.qzz.fma((Vector)this.R005, (Vector)term003);
                this.E003 = term003.neg();
                DoubleVector term210 = mK.dy.mul((Vector)this.R220);
                term210 = mK.qyz.fma((Vector)this.R221, (Vector)term210);
                this.E210 = term210.neg();
                DoubleVector term201 = mK.q.mul((Vector)this.R201);
                term201 = mK.dz.fma((Vector)this.R202, (Vector)term201);
                term201 = mK.qxx.fma((Vector)this.R401, (Vector)term201);
                term201 = mK.qyy.fma((Vector)this.R221, (Vector)term201);
                term201 = mK.qzz.fma((Vector)this.R203, (Vector)term201);
                this.E201 = term201.neg();
                DoubleVector term120 = mK.dx.mul((Vector)this.R220);
                term120 = mK.qxz.fma((Vector)this.R221, (Vector)term120);
                this.E120 = term120.neg();
                DoubleVector term021 = mK.q.mul((Vector)this.R021);
                term021 = mK.dz.fma((Vector)this.R022, (Vector)term021);
                term021 = mK.qxx.fma((Vector)this.R221, (Vector)term021);
                term021 = mK.qyy.fma((Vector)this.R041, (Vector)term021);
                term021 = mK.qzz.fma((Vector)this.R023, (Vector)term021);
                this.E021 = term021.neg();
                DoubleVector term102 = mK.dx.mul((Vector)this.R202);
                term102 = mK.qxz.fma((Vector)this.R203, (Vector)term102);
                this.E102 = term102.neg();
                DoubleVector term012 = mK.dy.mul((Vector)this.R022);
                term012 = mK.qyz.fma((Vector)this.R023, (Vector)term012);
                this.E012 = term012.neg();
                DoubleVector term111 = mK.qxy.mul((Vector)this.R221);
                this.E111 = term111.neg();
            }
            case 2: {
                DoubleVector term200 = mK.q.mul((Vector)this.R200);
                term200 = mK.dz.fma((Vector)this.R201, (Vector)term200);
                term200 = mK.qxx.fma((Vector)this.R400, (Vector)term200);
                term200 = mK.qyy.fma((Vector)this.R220, (Vector)term200);
                this.E200 = term200 = mK.qzz.fma((Vector)this.R202, (Vector)term200);
                DoubleVector term020 = mK.q.mul((Vector)this.R020);
                term020 = mK.dz.fma((Vector)this.R021, (Vector)term020);
                term020 = mK.qxx.fma((Vector)this.R220, (Vector)term020);
                term020 = mK.qyy.fma((Vector)this.R040, (Vector)term020);
                this.E020 = term020 = mK.qzz.fma((Vector)this.R022, (Vector)term020);
                DoubleVector term002 = mK.q.mul((Vector)this.R002);
                term002 = mK.dz.fma((Vector)this.R003, (Vector)term002);
                term002 = mK.qxx.fma((Vector)this.R202, (Vector)term002);
                term002 = mK.qyy.fma((Vector)this.R022, (Vector)term002);
                this.E002 = term002 = mK.qzz.fma((Vector)this.R004, (Vector)term002);
                this.E110 = mK.qxy.mul((Vector)this.R220);
                DoubleVector term101 = mK.dx.mul((Vector)this.R201);
                this.E101 = term101 = mK.qxz.fma((Vector)this.R202, (Vector)term101);
                DoubleVector term011 = mK.dy.mul((Vector)this.R021);
                this.E011 = term011 = mK.qyz.fma((Vector)this.R022, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = mK.dx.mul((Vector)this.R200);
                term100 = mK.qxz.fma((Vector)this.R201, (Vector)term100);
                this.E100 = term100.neg();
                DoubleVector term010 = mK.dy.mul((Vector)this.R020);
                term010 = mK.qyz.fma((Vector)this.R021, (Vector)term010);
                this.E010 = term010.neg();
                DoubleVector term001 = mK.q.mul((Vector)this.R001);
                term001 = mK.dz.fma((Vector)this.R002, (Vector)term001);
                term001 = mK.qxx.fma((Vector)this.R201, (Vector)term001);
                term001 = mK.qyy.fma((Vector)this.R021, (Vector)term001);
                term001 = mK.qzz.fma((Vector)this.R003, (Vector)term001);
                this.E001 = term001.neg();
            }
            case 0: 
        }
        DoubleVector term000 = mK.q.mul((Vector)this.R000);
        term000 = mK.dz.fma((Vector)this.R001, (Vector)term000);
        term000 = mK.qxx.fma((Vector)this.R200, (Vector)term000);
        term000 = mK.qyy.fma((Vector)this.R020, (Vector)term000);
        this.E000 = term000 = mK.qzz.fma((Vector)this.R002, (Vector)term000);
    }

    @Override
    protected void chargeKPotentialAtI(PolarizableMultipoleSIMD mK, int order) {
        switch (order) {
            default: {
                this.E300 = zero;
                this.E030 = zero;
                this.E003 = mK.q.mul((Vector)this.R003).neg();
                this.E210 = zero;
                this.E201 = mK.q.mul((Vector)this.R201).neg();
                this.E120 = zero;
                this.E021 = mK.q.mul((Vector)this.R021).neg();
                this.E102 = zero;
                this.E012 = zero;
                this.E111 = zero;
            }
            case 2: {
                this.E200 = mK.q.mul((Vector)this.R200);
                this.E020 = mK.q.mul((Vector)this.R020);
                this.E002 = mK.q.mul((Vector)this.R002);
                this.E110 = zero;
                this.E101 = zero;
                this.E011 = zero;
            }
            case 1: {
                this.E100 = zero;
                this.E010 = zero;
                this.E001 = mK.q.mul((Vector)this.R001).neg();
            }
            case 0: 
        }
        this.E000 = mK.q.mul((Vector)this.R000);
    }

    @Override
    protected void dipoleKPotentialAtI(DoubleVector uxk, DoubleVector uyk, DoubleVector uzk, int order) {
        switch (order) {
            default: {
                this.E300 = uxk.mul((Vector)this.R400).neg();
                this.E030 = uyk.mul((Vector)this.R040).neg();
                this.E003 = uzk.mul((Vector)this.R004).neg();
                this.E210 = uyk.mul((Vector)this.R220).neg();
                this.E201 = uzk.mul((Vector)this.R202).neg();
                this.E120 = uxk.mul((Vector)this.R220).neg();
                this.E021 = uzk.mul((Vector)this.R022).neg();
                this.E102 = uxk.mul((Vector)this.R202).neg();
                this.E012 = uyk.mul((Vector)this.R022).neg();
                this.E111 = zero;
            }
            case 2: {
                this.E200 = uzk.mul((Vector)this.R201);
                this.E020 = uzk.mul((Vector)this.R021);
                this.E002 = uzk.mul((Vector)this.R003);
                this.E110 = zero;
                this.E101 = uxk.mul((Vector)this.R201);
                this.E011 = uyk.mul((Vector)this.R021);
            }
            case 1: {
                this.E100 = uxk.mul((Vector)this.R200).neg();
                this.E010 = uyk.mul((Vector)this.R020).neg();
                this.E001 = uzk.mul((Vector)this.R002).neg();
            }
            case 0: 
        }
        this.E000 = uzk.mul((Vector)this.R001);
    }

    @Override
    protected void quadrupoleKPotentialAtI(PolarizableMultipoleSIMD mK, int order) {
        switch (order) {
            default: {
                this.E300 = mK.qxz.mul((Vector)this.R401).neg();
                this.E030 = mK.qyz.mul((Vector)this.R041).neg();
                DoubleVector term003 = mK.qxx.mul((Vector)this.R203);
                term003 = mK.qyy.fma((Vector)this.R023, (Vector)term003);
                this.E003 = term003 = mK.qzz.fma((Vector)this.R005, (Vector)term003);
                this.E210 = mK.qyz.mul((Vector)this.R221).neg();
                DoubleVector term201 = mK.qxx.mul((Vector)this.R401);
                term201 = mK.qyy.fma((Vector)this.R221, (Vector)term201);
                term201 = mK.qzz.fma((Vector)this.R203, (Vector)term201);
                this.E201 = term201.neg();
                this.E120 = mK.qxz.mul((Vector)this.R221).neg();
                DoubleVector term021 = mK.qxx.mul((Vector)this.R221);
                term021 = mK.qyy.fma((Vector)this.R041, (Vector)term021);
                term021 = mK.qzz.fma((Vector)this.R023, (Vector)term021);
                this.E021 = term021.neg();
                this.E102 = mK.qxz.mul((Vector)this.R203).neg();
                this.E012 = mK.qyz.mul((Vector)this.R023).neg();
                this.E111 = mK.qxy.mul((Vector)this.R221).neg();
            }
            case 2: {
                DoubleVector term200 = mK.qxx.mul((Vector)this.R400);
                term200 = mK.qyy.fma((Vector)this.R220, (Vector)term200);
                this.E200 = term200 = mK.qzz.fma((Vector)this.R202, (Vector)term200);
                DoubleVector term020 = mK.qxx.mul((Vector)this.R220);
                term020 = mK.qyy.fma((Vector)this.R040, (Vector)term020);
                this.E020 = term020 = mK.qzz.fma((Vector)this.R022, (Vector)term020);
                DoubleVector term002 = mK.qxx.mul((Vector)this.R202);
                term002 = mK.qyy.fma((Vector)this.R022, (Vector)term002);
                this.E002 = term002 = mK.qzz.fma((Vector)this.R004, (Vector)term002);
                this.E110 = mK.qxy.mul((Vector)this.R220);
                this.E101 = mK.qxz.mul((Vector)this.R202);
                this.E011 = mK.qyz.mul((Vector)this.R022);
            }
            case 1: {
                this.E100 = mK.qxz.mul((Vector)this.R201).neg();
                this.E010 = mK.qyz.mul((Vector)this.R021).neg();
                DoubleVector term001 = mK.qxx.mul((Vector)this.R201);
                term001 = mK.qyy.fma((Vector)this.R021, (Vector)term001);
                term001 = mK.qzz.fma((Vector)this.R003, (Vector)term001);
                this.E001 = term001.neg();
            }
            case 0: 
        }
        DoubleVector term000 = mK.qxx.mul((Vector)this.R200);
        term000 = mK.qyy.fma((Vector)this.R020, (Vector)term000);
        this.E000 = term000 = mK.qzz.fma((Vector)this.R002, (Vector)term000);
    }

    @Override
    protected void multipoleIPotentialAtK(PolarizableMultipoleSIMD mI, int order) {
        switch (order) {
            default: {
                DoubleVector term300 = mI.dx.mul((Vector)this.R400.neg());
                this.E300 = term300 = mI.qxz.fma((Vector)this.R401, (Vector)term300);
                DoubleVector term030 = mI.dy.mul((Vector)this.R040.neg());
                this.E030 = term030 = mI.qyz.fma((Vector)this.R041, (Vector)term030);
                DoubleVector term003 = mI.q.mul((Vector)this.R003);
                term003 = mI.dz.fma((Vector)this.R004.neg(), (Vector)term003);
                term003 = mI.qxx.fma((Vector)this.R203, (Vector)term003);
                term003 = mI.qyy.fma((Vector)this.R023, (Vector)term003);
                this.E003 = term003 = mI.qzz.fma((Vector)this.R005, (Vector)term003);
                DoubleVector term210 = mI.dy.mul((Vector)this.R220.neg());
                this.E210 = term210 = mI.qyz.fma((Vector)this.R221, (Vector)term210);
                DoubleVector term201 = mI.q.mul((Vector)this.R201);
                term201 = mI.dz.fma((Vector)this.R202.neg(), (Vector)term201);
                term201 = mI.qxx.fma((Vector)this.R401, (Vector)term201);
                term201 = mI.qyy.fma((Vector)this.R221, (Vector)term201);
                this.E201 = term201 = mI.qzz.fma((Vector)this.R203, (Vector)term201);
                DoubleVector term120 = mI.dx.mul((Vector)this.R220.neg());
                this.E120 = term120 = mI.qxz.fma((Vector)this.R221, (Vector)term120);
                DoubleVector term021 = mI.q.mul((Vector)this.R021);
                term021 = mI.dz.fma((Vector)this.R022.neg(), (Vector)term021);
                term021 = mI.qxx.fma((Vector)this.R221, (Vector)term021);
                term021 = mI.qyy.fma((Vector)this.R041, (Vector)term021);
                this.E021 = term021 = mI.qzz.fma((Vector)this.R023, (Vector)term021);
                DoubleVector term102 = mI.dx.mul((Vector)this.R202.neg());
                this.E102 = term102 = mI.qxz.fma((Vector)this.R203, (Vector)term102);
                DoubleVector term012 = mI.dy.mul((Vector)this.R022.neg());
                this.E012 = term012 = mI.qyz.fma((Vector)this.R023, (Vector)term012);
                this.E111 = mI.qxy.mul((Vector)this.R221);
            }
            case 2: {
                DoubleVector term200 = mI.q.mul((Vector)this.R200);
                term200 = mI.dz.fma((Vector)this.R201.neg(), (Vector)term200);
                term200 = mI.qxx.fma((Vector)this.R400, (Vector)term200);
                term200 = mI.qyy.fma((Vector)this.R220, (Vector)term200);
                this.E200 = term200 = mI.qzz.fma((Vector)this.R202, (Vector)term200);
                DoubleVector term020 = mI.q.mul((Vector)this.R020);
                term020 = mI.dz.fma((Vector)this.R021.neg(), (Vector)term020);
                term020 = mI.qxx.fma((Vector)this.R220, (Vector)term020);
                term020 = mI.qyy.fma((Vector)this.R040, (Vector)term020);
                this.E020 = term020 = mI.qzz.fma((Vector)this.R022, (Vector)term020);
                DoubleVector term002 = mI.q.mul((Vector)this.R002);
                term002 = mI.dz.fma((Vector)this.R003.neg(), (Vector)term002);
                term002 = mI.qxx.fma((Vector)this.R202, (Vector)term002);
                term002 = mI.qyy.fma((Vector)this.R022, (Vector)term002);
                this.E002 = term002 = mI.qzz.fma((Vector)this.R004, (Vector)term002);
                this.E110 = mI.qxy.mul((Vector)this.R220);
                DoubleVector term101 = mI.dx.mul((Vector)this.R201.neg());
                this.E101 = term101 = mI.qxz.fma((Vector)this.R202, (Vector)term101);
                DoubleVector term011 = mI.dy.mul((Vector)this.R021.neg());
                this.E011 = term011 = mI.qyz.fma((Vector)this.R022, (Vector)term011);
            }
            case 1: {
                DoubleVector term100 = mI.dx.mul((Vector)this.R200.neg());
                this.E100 = term100 = mI.qxz.fma((Vector)this.R201, (Vector)term100);
                DoubleVector term010 = mI.dy.mul((Vector)this.R020.neg());
                this.E010 = term010 = mI.qyz.fma((Vector)this.R021, (Vector)term010);
                DoubleVector term001 = mI.q.mul((Vector)this.R001);
                term001 = mI.dz.fma((Vector)this.R002.neg(), (Vector)term001);
                term001 = mI.qxx.fma((Vector)this.R201, (Vector)term001);
                term001 = mI.qyy.fma((Vector)this.R021, (Vector)term001);
                this.E001 = term001 = mI.qzz.fma((Vector)this.R003, (Vector)term001);
            }
            case 0: 
        }
        DoubleVector term000 = mI.q.mul((Vector)this.R000);
        term000 = mI.dz.fma((Vector)this.R001.neg(), (Vector)term000);
        term000 = mI.qxx.fma((Vector)this.R200, (Vector)term000);
        term000 = mI.qyy.fma((Vector)this.R020, (Vector)term000);
        this.E000 = term000 = mI.qzz.fma((Vector)this.R002, (Vector)term000);
    }

    @Override
    protected void chargeIPotentialAtK(PolarizableMultipoleSIMD mI, int order) {
        switch (order) {
            default: {
                this.E300 = zero;
                this.E030 = zero;
                this.E003 = mI.q.mul((Vector)this.R003);
                this.E210 = zero;
                this.E201 = mI.q.mul((Vector)this.R201);
                this.E120 = zero;
                this.E021 = mI.q.mul((Vector)this.R021);
                this.E102 = zero;
                this.E012 = zero;
                this.E111 = zero;
            }
            case 2: {
                this.E200 = mI.q.mul((Vector)this.R200);
                this.E020 = mI.q.mul((Vector)this.R020);
                this.E002 = mI.q.mul((Vector)this.R002);
                this.E110 = zero;
                this.E101 = zero;
                this.E011 = zero;
            }
            case 1: {
                this.E100 = zero;
                this.E010 = zero;
                this.E001 = mI.q.mul((Vector)this.R001);
            }
            case 0: 
        }
        this.E000 = mI.q.mul((Vector)this.R000);
    }

    @Override
    protected void dipoleIPotentialAtK(DoubleVector uxi, DoubleVector uyi, DoubleVector uzi, int order) {
        switch (order) {
            default: {
                this.E300 = uxi.mul((Vector)this.R400).neg();
                this.E030 = uyi.mul((Vector)this.R040).neg();
                this.E003 = uzi.mul((Vector)this.R004).neg();
                this.E210 = uyi.mul((Vector)this.R220).neg();
                this.E201 = uzi.mul((Vector)this.R202).neg();
                this.E120 = uxi.mul((Vector)this.R220).neg();
                this.E021 = uzi.mul((Vector)this.R022).neg();
                this.E102 = uxi.mul((Vector)this.R202).neg();
                this.E012 = uyi.mul((Vector)this.R022).neg();
                this.E111 = zero;
            }
            case 2: {
                this.E200 = uzi.mul((Vector)this.R201.neg());
                this.E020 = uzi.mul((Vector)this.R021.neg());
                this.E002 = uzi.mul((Vector)this.R003.neg());
                this.E110 = zero;
                this.E101 = uxi.mul((Vector)this.R201.neg());
                this.E011 = uyi.mul((Vector)this.R021.neg());
            }
            case 1: {
                this.E100 = uxi.mul((Vector)this.R200.neg());
                this.E010 = uyi.mul((Vector)this.R020.neg());
                this.E001 = uzi.mul((Vector)this.R002.neg());
            }
            case 0: 
        }
        this.E000 = uzi.mul((Vector)this.R001.neg());
    }

    @Override
    protected void quadrupoleIPotentialAtK(PolarizableMultipoleSIMD mI, int order) {
        switch (order) {
            default: {
                this.E300 = mI.qxz.mul((Vector)this.R401);
                this.E030 = mI.qyz.mul((Vector)this.R041);
                DoubleVector term003 = mI.qxx.mul((Vector)this.R203);
                term003 = mI.qyy.fma((Vector)this.R023, (Vector)term003);
                this.E003 = term003 = mI.qzz.fma((Vector)this.R005, (Vector)term003);
                this.E210 = mI.qyz.mul((Vector)this.R221);
                DoubleVector term201 = mI.qxx.mul((Vector)this.R401);
                term201 = mI.qyy.fma((Vector)this.R221, (Vector)term201);
                this.E201 = term201 = mI.qzz.fma((Vector)this.R203, (Vector)term201);
                this.E120 = mI.qxz.mul((Vector)this.R221);
                DoubleVector term021 = mI.qxx.mul((Vector)this.R221);
                term021 = mI.qyy.fma((Vector)this.R041, (Vector)term021);
                this.E021 = term021 = mI.qzz.fma((Vector)this.R023, (Vector)term021);
                this.E102 = mI.qxz.mul((Vector)this.R203);
                this.E012 = mI.qyz.mul((Vector)this.R023);
                this.E111 = mI.qxy.mul((Vector)this.R221);
            }
            case 2: {
                DoubleVector term200 = mI.qxx.mul((Vector)this.R400);
                term200 = mI.qyy.fma((Vector)this.R220, (Vector)term200);
                this.E200 = term200 = mI.qzz.fma((Vector)this.R202, (Vector)term200);
                DoubleVector term020 = mI.qxx.mul((Vector)this.R220);
                term020 = mI.qyy.fma((Vector)this.R040, (Vector)term020);
                this.E020 = term020 = mI.qzz.fma((Vector)this.R022, (Vector)term020);
                DoubleVector term002 = mI.qxx.mul((Vector)this.R202);
                term002 = mI.qyy.fma((Vector)this.R022, (Vector)term002);
                this.E002 = term002 = mI.qzz.fma((Vector)this.R004, (Vector)term002);
                this.E110 = mI.qxy.mul((Vector)this.R220);
                this.E101 = mI.qxz.mul((Vector)this.R202);
                this.E011 = mI.qyz.mul((Vector)this.R022);
            }
            case 1: {
                this.E100 = mI.qxz.mul((Vector)this.R201);
                this.E010 = mI.qyz.mul((Vector)this.R021);
                DoubleVector term001 = mI.qxx.mul((Vector)this.R201);
                term001 = mI.qyy.fma((Vector)this.R021, (Vector)term001);
                this.E001 = term001 = mI.qzz.fma((Vector)this.R003, (Vector)term001);
            }
            case 0: 
        }
        DoubleVector term000 = mI.qxx.mul((Vector)this.R200);
        term000 = mI.qyy.fma((Vector)this.R020, (Vector)term000);
        this.E000 = term000 = mI.qzz.fma((Vector)this.R002, (Vector)term000);
    }
}

