/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.math;

import ffx.numerics.math.FloatMath;

public class Float3 {
    private final float[] a;

    public Float3() {
        this.a = new float[]{0.0f, 0.0f, 0.0f};
    }

    public Float3(float x, float y, float z) {
        this.a = new float[]{x, y, z};
    }

    public Float3(float[] a) {
        this.a = new float[]{a[0], a[1], a[2]};
    }

    public Float3 fma(float b, Float3 c) {
        Float3 ret = new Float3();
        FloatMath.fma(this.a, b, c.get(), ret.get());
        return ret;
    }

    public Float3 fmaI(float b, Float3 c) {
        FloatMath.fma(this.a, b, c.get(), this.a);
        return this;
    }

    public Float3 X(Float3 b) {
        Float3 ret = new Float3();
        FloatMath.X(this.a, b.get(), ret.get());
        return ret;
    }

    public Float3 XI(Float3 b) {
        return this.set(this.X(b));
    }

    public Float3 add(Float3 b) {
        Float3 ret = new Float3();
        FloatMath.add(this.a, b.get(), ret.get());
        return ret;
    }

    public Float3 addI(Float3 b) {
        FloatMath.add(this.a, b.get(), this.a);
        return this;
    }

    public float angle(Float3 b) {
        return FloatMath.angle(this.a, b.get());
    }

    public Float3 copy() {
        return new Float3(this.a);
    }

    public float dist(Float3 b) {
        return FloatMath.dist(this.a, b.get());
    }

    public float dist2(Float3 b) {
        return FloatMath.dist2(this.a, b.get());
    }

    public float dot(Float3 b) {
        return FloatMath.dot(this.a, b.get());
    }

    public float[] get() {
        return this.a;
    }

    public float get(int i) {
        return this.a[i];
    }

    public float length() {
        return FloatMath.length(this.a);
    }

    public float length2() {
        return FloatMath.length2(this.a);
    }

    public void log() {
        FloatMath.log(this.a);
    }

    public Float3 normalize() {
        Float3 ret = new Float3();
        FloatMath.normalize(this.a, ret.get());
        return ret;
    }

    public Float3 normalizeI() {
        FloatMath.normalize(this.a, this.a);
        return this;
    }

    public Float3 scale(float d) {
        Float3 ret = new Float3();
        FloatMath.scale(this.a, d, ret.get());
        return ret;
    }

    public Float3 scaleI(float d) {
        FloatMath.scale(this.a, d, this.a);
        return this;
    }

    public Float3 square() {
        Float3 ret = new Float3();
        FloatMath.square(this.a, ret.get());
        return ret;
    }

    public Float3 squareI() {
        FloatMath.square(this.a, this.a);
        return this;
    }

    public Float3 sqrt() {
        Float3 ret = new Float3();
        FloatMath.squareRoot(this.a, ret.get());
        return ret;
    }

    public Float3 sqrtI() {
        FloatMath.squareRoot(this.a, this.a);
        return this;
    }

    public Float3 set(float x, float y, float z) {
        this.a[0] = x;
        this.a[1] = y;
        this.a[2] = z;
        return this;
    }

    public Float3 set(float[] b) {
        System.arraycopy(b, 0, this.a, 0, 3);
        return this;
    }

    public Float3 set(Float3 b) {
        System.arraycopy(b.get(), 0, this.a, 0, 3);
        return this;
    }

    public Float3 sub(Float3 b) {
        Float3 ret = new Float3();
        FloatMath.sub(this.a, b.get(), ret.get());
        return ret;
    }

    public Float3 subI(Float3 b) {
        FloatMath.sub(this.a, b.get(), this.a);
        return this;
    }

    public String toString() {
        return FloatMath.toString(this.a);
    }

    public float x() {
        return this.a[0];
    }

    public float y() {
        return this.a[1];
    }

    public float z() {
        return this.a[2];
    }
}

