/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import ffx.numerics.integrate.DataSet;
import org.apache.commons.math3.util.FastMath;

public abstract class FunctionDataCurve
implements DataSet {
    protected double lb = 0.0;
    protected double ub = 0.0;
    protected double[] points = new double[0];
    protected double[] x = new double[0];
    protected boolean halfWidthEnd = false;

    public static boolean approxEquals(double x1, double x2) {
        return FunctionDataCurve.approxEquals(x1, x2, 10.0);
    }

    public static boolean approxEquals(double x1, double x2, double ulpMultiple) {
        double ulp;
        double diff = FastMath.abs((double)(x1 - x2));
        return diff < (ulp = FastMath.ulp((double)FastMath.max((double)FastMath.abs((double)x1), (double)FastMath.abs((double)x2)))) * ulpMultiple;
    }

    public double analyticalIntegral() {
        return this.analyticalIntegral(this.lowerBound(), this.upperBound());
    }

    public double analyticalIntegral(double lb, double ub) {
        return this.integralAt(ub) - this.integralAt(lb);
    }

    @Override
    public double binWidth() {
        double divisor = this.halfWidthEnds() ? (double)(this.points.length - 2) : (double)(this.points.length - 1);
        return (this.ub - this.lb) / divisor;
    }

    public abstract double fX(double var1);

    @Override
    public double[] getAllFxPoints() {
        int nPoints = this.points.length;
        double[] retArray = new double[nPoints];
        System.arraycopy(this.points, 0, retArray, 0, nPoints);
        return retArray;
    }

    @Override
    public double getFxPoint(int index) {
        return this.points[index];
    }

    @Override
    public double[] getX() {
        double[] copyX = new double[this.x.length];
        System.arraycopy(this.x, 0, copyX, 0, this.x.length);
        return copyX;
    }

    @Override
    public boolean halfWidthEnds() {
        return this.halfWidthEnd;
    }

    public abstract double integralAt(double var1);

    @Override
    public double lowerBound() {
        return this.lb;
    }

    @Override
    public int numPoints() {
        return this.points.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("Function f(x) curve with %d points from lower bound %9.3g and upper bound %9.3g", this.points.length, this.lb, this.ub));
        if (this.halfWidthEnd) {
            sb.append(" and half-width start/end bins");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public double upperBound() {
        return this.ub;
    }

    protected final void assertXIntegrity() {
        assert (this.ub > this.lb);
        int nX = this.numPoints();
        double sep = this.binWidth();
        if (this.halfWidthEnd) {
            assert (this.x.length == nX);
            assert (this.lb == this.x[0]);
            assert (this.ub == this.x[nX - 1]);
            assert (FunctionDataCurve.approxEquals(this.x[1], this.lb + 0.5 * sep));
            assert (FunctionDataCurve.approxEquals(this.x[nX - 2], this.ub - 0.5 * sep));
            for (int i = 2; i < nX - 2; ++i) {
                double target = this.lb + 0.5 * sep;
                assert (FunctionDataCurve.approxEquals(this.x[i], target += (double)(i - 1) * sep));
            }
        } else {
            for (int i = 0; i < this.x.length; ++i) {
                assert (FunctionDataCurve.approxEquals(this.x[i], this.x[0] + (double)i * sep));
            }
        }
    }
}

