/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.integrate;

import ffx.numerics.integrate.FunctionDataCurve;
import org.apache.commons.math3.util.FastMath;

public class CosineWave
extends FunctionDataCurve {
    private final double a;
    private final double n;
    private final double nInverse;

    public CosineWave(double[] x, double a, double n) {
        this(x, false, a, n);
    }

    public CosineWave(double[] x, boolean halfWidthEnds, double a, double n) {
        int nPoints = x.length;
        this.points = new double[nPoints];
        this.a = a;
        this.n = n;
        this.nInverse = 1.0 / n;
        this.halfWidthEnd = halfWidthEnds;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = this.cosAt(x[i]);
        }
        this.lb = x[0];
        this.ub = x[nPoints - 1];
        this.x = new double[x.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
    }

    @Override
    public double fX(double x) {
        return this.cosAt(x);
    }

    @Override
    public double integralAt(double x) {
        return this.a * this.nInverse * FastMath.sin((double)(this.n * x));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Cosine wave f(x) = ");
        sb.append(this.a).append("*cos(").append(this.n).append("x)");
        sb.append(String.format(" with %d points from lower bound %9.3g and upper bound %9.3g", this.points.length, this.lb, this.ub));
        if (this.halfWidthEnd) {
            sb.append(" and half-width start/end bins");
        }
        return sb.toString();
    }

    private double cosAt(double x) {
        return this.a * FastMath.cos((double)(this.n * x));
    }
}

